/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PlotWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class ProfilePlot {
    static final int MIN_WIDTH = 350;
    static final double ASPECT_RATIO = 0.5;
    private double min;
    private double max;
    private boolean minAndMaxCalculated;
    private static boolean horizProf;
    private static double fixedMin;
    private static double fixedMax;
    protected ImagePlus imp;
    protected double[] profile;
    protected double magnification;
    protected double pixelSize;
    protected String units;
    protected String yLabel;
    private Roi region;
    private static int id;

    public ProfilePlot() {
    }

    public ProfilePlot(ImagePlus imp) {
        this(imp, false, false);
    }

    public ProfilePlot(ImagePlus imp, boolean averageHorizontally, boolean horizProf) {
        this.imp = imp;
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error(IJ.getBundle().getString("SelReqErr"));
            return;
        }
        int roiType = roi.getType();
        if (roiType != 5) {
            IJ.error(IJ.getBundle().getString("HorizLineSelReqErr"));
            return;
        }
        Calibration cal = imp.getCalibration();
        this.pixelSize = cal.pixelWidth;
        this.units = cal.getUnits();
        this.yLabel = cal.getValueUnit();
        ImageProcessor ip = imp.getProcessor();
        ip.setCalibrationTable(cal.getCTable());
        ip.setInterpolate(true);
        this.profile = ((Line)roi).getPixels();
        ip.setCalibrationTable(null);
        ImageWindow win = imp.getWindow();
        this.magnification = win != null ? win.getCanvas().getMagnification() : 1.0;
        this.region = (Roi)roi.clone();
        ProfilePlot.horizProf = horizProf;
    }

    public Dimension getPlotSize() {
        if (this.profile == null) {
            return null;
        }
        int width = (int)((double)this.profile.length * this.magnification);
        int height = (int)((double)width * 0.5);
        if (width < 350) {
            width = 350;
            height = (int)((double)width * 0.5);
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int maxWidth = Math.min(screen.width - 200, 1000);
        if (width > maxWidth) {
            width = maxWidth;
            height = (int)((double)width * 0.5);
        }
        return new Dimension(width, height);
    }

    public void createWindow() {
        if (this.profile == null) {
            return;
        }
        Dimension d = this.getPlotSize();
        String xLabel = IJ.getBundle().getString("Distance") + " (" + this.units + ")";
        int n = this.profile.length;
        float[] xValues = new float[n];
        IJ.showProgress(0.0);
        for (int i = 0; i < n; ++i) {
            xValues[i] = (float)((double)i * this.pixelSize);
        }
        float[] yValues = new float[n];
        for (int i = 0; i < n; ++i) {
            yValues[i] = (float)this.profile[i];
        }
        boolean fixedYScale = fixedMin != 0.0 || fixedMax != 0.0;
        PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + " " + this.imp.getShortTitle() + (this.imp.getStackSize() > 1 ? "#" + this.imp.getCurrentSlice() : "") + " - " + id++, xLabel, this.yLabel, xValues, yValues, horizProf, this.imp, this.region);
        if (fixedYScale) {
            double[] a = Tools.getMinMax(xValues);
            pw.setLimits(a[0], a[1], fixedMin, fixedMax);
        }
        pw.draw();
    }

    public double[] getProfile() {
        return this.profile;
    }

    public double getMin() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public static boolean gethorizProf() {
        return horizProf;
    }

    public static void setMinAndMax(double min, double max) {
        fixedMin = min;
        fixedMax = max;
        IJ.register(ProfilePlot.class);
    }

    public static double getFixedMin() {
        return fixedMin;
    }

    public static double getFixedMax() {
        return fixedMax;
    }

    double[] getRowAverageProfile(Rectangle rect, Calibration cal, ImageProcessor ip) {
        double[] profile = new double[rect.height];
        ip.setInterpolate(false);
        for (int x = rect.x; x < rect.x + rect.width; ++x) {
            double[] aLine = ip.getLine(x, rect.y, x, rect.y + rect.height - 1);
            for (int i = 0; i < rect.height; ++i) {
                int n = i;
                profile[n] = profile[n] + aLine[i];
            }
        }
        int i = 0;
        while (i < rect.height) {
            int n = i++;
            profile[n] = profile[n] / (double)rect.width;
        }
        if (cal != null) {
            this.pixelSize = cal.pixelHeight;
        }
        return profile;
    }

    double[] getColumnAverageProfile(Rectangle rect, ImageProcessor ip) {
        double[] profile = new double[rect.width];
        ip.setInterpolate(false);
        for (int y = rect.y; y < rect.y + rect.height; ++y) {
            double[] aLine = ip.getLine(rect.x, y, rect.x + rect.width - 1, y);
            for (int i = 0; i < rect.width; ++i) {
                int n = i;
                profile[n] = profile[n] + aLine[i];
            }
        }
        int i = 0;
        while (i < rect.width) {
            int n = i++;
            profile[n] = profile[n] / (double)rect.height;
        }
        return profile;
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor ip) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] x = ((PolygonRoi)roi).getXCoordinates();
        int[] y = ((PolygonRoi)roi).getYCoordinates();
        Rectangle r = roi.getBoundingRect();
        int xbase = r.x;
        int ybase = r.y;
        double length = 0.0;
        double[] segmentLengths = new double[n];
        int[] dx = new int[n];
        int[] dy = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            int xdelta = x[i + 1] - x[i];
            int ydelta = y[i + 1] - y[i];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            length += segmentLength;
            segmentLengths[i] = segmentLength;
            dx[i] = xdelta;
            dy[i] = ydelta;
        }
        double[] values = new double[(int)length];
        double leftOver = 1.0;
        double distance = 0.0;
        for (int i = 0; i < n; ++i) {
            double len = segmentLengths[i];
            if (len == 0.0) continue;
            double xinc = (double)dx[i] / len;
            double yinc = (double)dy[i] / len;
            double start = 1.0 - leftOver;
            double rx = (double)(xbase + x[i]) + start * xinc;
            double ry = (double)(ybase + y[i]) + start * yinc;
            double len2 = len - start;
            int n2 = (int)len2;
            for (int j = 0; j <= n2; ++j) {
                int index = (int)distance + j;
                if (index < values.length) {
                    values[index] = ip.getInterpolatedValue(rx, ry);
                }
                rx += xinc;
                ry += yinc;
            }
            distance += len;
            leftOver = len2 - (double)n2;
        }
        return values;
    }

    private double[] getLineSegment(ImageProcessor ip, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double[] data = new double[++n];
        double rx = x1;
        double ry = y1;
        for (int i = 0; i < n; ++i) {
            data[i] = ip.getInterpolatedValue(rx, ry);
            rx += xinc;
            ry += yinc;
        }
        return data;
    }

    void findMinAndMax() {
        if (this.profile == null) {
            return;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.profile.length; ++i) {
            double value = this.profile[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        this.min = min;
        this.max = max;
    }

    static {
        fixedMin = Prefs.getDouble("pp.min", 0.0);
        fixedMax = Prefs.getDouble("pp.max", 0.0);
        id = 1;
    }
}

