/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Macro;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SaveChangesDialog
extends Dialog
implements ActionListener {
    private Button dontSave;
    private Button cancel;
    private Button save;
    private boolean cancelPressed;
    private boolean savePressed;

    public SaveChangesDialog(Frame parent, String fileName) {
        super(parent, IJ.getBundle().getString("DoSave"), true);
        Component message;
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setResizable(false);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        if (fileName.startsWith(IJ.getBundle().getString("SaveCmd") + " ")) {
            message = new Label(fileName);
        } else if (fileName.length() > 22) {
            message = new MultiLineLabel(IJ.getBundle().getString("SaveChanges") + "\n" + "\"" + fileName + "\"?");
        } else {
            Label mes = message = new Label(IJ.getBundle().getString("SaveChanges") + " \"" + fileName + "\"?");
            mes.setAlignment(1);
        }
        message.setFont(new Font("Dialog", 1, 12));
        panel.add(message);
        this.add("North", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.save = new Button(IJ.getBundle().getString("YNCDialYes"));
        this.save.addActionListener(this);
        this.cancel = new Button(IJ.getBundle().getString("YNCDialCan"));
        this.cancel.addActionListener(this);
        this.dontSave = new Button(IJ.getBundle().getString("YNCDialNo"));
        this.dontSave.addActionListener(this);
        if (IJ.isMacintosh()) {
            panel.add(this.dontSave);
            panel.add(this.cancel);
            panel.add(this.save);
        } else {
            panel.add(this.save);
            panel.add(this.dontSave);
            panel.add(this.cancel);
        }
        this.add("Center", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.add("South", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.add("East", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.add("West", panel);
        if (IJ.isMacintosh()) {
            this.setResizable(false);
        }
        this.pack();
        GUI.center(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancel) {
            this.cancelPressed = true;
        } else if (e.getSource() == this.save) {
            this.savePressed = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean cancelPressed() {
        if (this.cancelPressed) {
            Macro.abort();
        }
        return this.cancelPressed;
    }

    public boolean savePressed() {
        return this.savePressed;
    }
}

