/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.Prefs;
import ij.gui.GUI;
import ij.plugin.frame.Recorder;
import java.awt.FileDialog;
import java.awt.Frame;

public class OpenDialog {
    private String dir;
    private String name;
    private boolean recordPath;
    private static String defaultDirectory;
    private String title;

    public OpenDialog(String title, String path) {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && ((path = Macro.getValue(macroOptions, title, path)) == null || path.equals(""))) {
            path = Macro.getValue(macroOptions, "path", path);
        }
        if (path == null || path.equals("")) {
            ImageJ ij = IJ.getInstance();
            Frame parent = ij != null ? ij : new Frame();
            FileDialog fd = new FileDialog(parent, title, 0);
            this.title = title;
            defaultDirectory = OpenDialog.getDefaultDirectory();
            if (defaultDirectory != null) {
                fd.setDirectory(defaultDirectory);
            }
            GUI.center(fd);
            fd.show();
            this.name = fd.getFile();
            if (this.name == null) {
                Macro.abort();
            } else {
                defaultDirectory = this.dir = fd.getDirectory();
            }
            this.recordPath = true;
            fd.dispose();
            if (ij == null) {
                parent.dispose();
            }
        } else {
            this.decodePath(path);
            this.recordPath = IJ.macroRunning();
        }
        IJ.register(OpenDialog.class);
    }

    public OpenDialog(String title, String defaultDir, String defaultName) {
        String path = null;
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            path = Macro.getValue(macroOptions, title, path);
        }
        if (path != null) {
            this.decodePath(path);
        } else {
            ImageJ ij = IJ.getInstance();
            Frame parent = ij != null ? ij : new Frame();
            FileDialog fd = new FileDialog(parent, title, 0);
            this.title = title;
            if (defaultDir != null) {
                fd.setDirectory(defaultDir);
            }
            if (defaultName != null) {
                fd.setFile(defaultName);
            }
            GUI.center(fd);
            fd.show();
            this.name = fd.getFile();
            if (this.name == null) {
                Macro.abort();
            }
            this.dir = fd.getDirectory();
            this.recordPath = true;
            fd.dispose();
            if (ij == null) {
                parent.dispose();
            }
        }
    }

    void decodePath(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            this.dir = path.substring(0, i + 1);
            this.name = path.substring(i + 1);
        } else {
            this.dir = "";
            this.name = path;
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record && this.recordPath) {
            Recorder.recordPath(this.title, this.dir + this.name);
        }
        return this.name;
    }

    public static String getDefaultDirectory() {
        if (defaultDirectory == null) {
            defaultDirectory = Prefs.getString("dir.image");
        }
        return defaultDirectory;
    }

    static void setDefaultDirectory(String defaultDir) {
        defaultDirectory = defaultDir;
        IJ.register(OpenDialog.class);
    }
}

