/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class RoiDecoder {
    private final int polygon = 0;
    private final int rect = 1;
    private final int oval = 2;
    private final int line = 3;
    private final int freeline = 4;
    private final int polyline = 5;
    private final int noRoi = 6;
    private final int freehand = 7;
    private final int traced = 8;
    private final int angle = 9;
    private byte[] data;
    private String path;

    public RoiDecoder(String path) {
        this.path = path;
    }

    public Roi getRoi() throws IOException {
        File f = new File(this.path);
        int size = (int)f.length();
        if (size > 500000) {
            throw new IOException("This is not an ImageJ ROI");
        }
        FileInputStream fis = new FileInputStream(this.path);
        this.data = new byte[size];
        for (int total = 0; total < size; total += fis.read(this.data, total, size - total)) {
        }
        if (this.getByte(0) != 73 || this.getByte(1) != 111) {
            throw new IOException("This is not an ImageJ ROI");
        }
        int type = this.getByte(6);
        int top = this.getShort(8);
        int left = this.getShort(10);
        int bottom = this.getShort(12);
        int right = this.getShort(14);
        int width = right - left;
        int height = bottom - top;
        int n = this.getShort(16);
        Roi roi = null;
        switch (type) {
            case 1: {
                roi = new Roi(left, top, width, height);
                break;
            }
            case 2: {
                roi = new OvalRoi(left, top, width, height);
                break;
            }
            case 3: {
                int x1 = (int)this.getFloat(18);
                int y1 = (int)this.getFloat(22);
                int x2 = (int)this.getFloat(26);
                int y2 = (int)this.getFloat(30);
                roi = new Line(x1, y1, x2, y2);
                break;
            }
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                if (n == 0) break;
                int[] x = new int[n];
                int[] y = new int[n];
                int base1 = 64;
                int base2 = base1 + 2 * n;
                for (int i = 0; i < n; ++i) {
                    int ytmp;
                    int xtmp = this.getShort(base1 + i * 2);
                    if (xtmp < 0) {
                        xtmp = 0;
                    }
                    if ((ytmp = this.getShort(base2 + i * 2)) < 0) {
                        ytmp = 0;
                    }
                    x[i] = left + xtmp;
                    y[i] = top + ytmp;
                }
                int roiType = type == 0 ? 2 : (type == 7 ? 3 : (type == 8 ? 4 : (type == 5 ? 6 : (type == 4 ? 7 : (type == 9 ? 8 : 3)))));
                roi = new PolygonRoi(x, y, n, roiType);
                break;
            }
        }
        return roi;
    }

    int getByte(int base) {
        return this.data[base] & 0xFF;
    }

    int getShort(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        return (short)((b0 << 8) + b1);
    }

    int getInt(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        int b2 = this.data[base + 2] & 0xFF;
        int b3 = this.data[base + 3] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    float getFloat(int base) {
        return Float.intBitsToFloat(this.getInt(base));
    }
}

