/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.io.FileInfo;
import ij.io.ImageWriter;
import java.io.DataOutputStream;
import java.io.IOException;

public class TiffEncoder {
    static final int IMAGE_START = 768;
    static final int HDR_SIZE = 8;
    static final int MAP_SIZE = 768;
    static final int BPS_DATA_SIZE = 6;
    static final int SCALE_DATA_SIZE = 16;
    private FileInfo fi;
    private int bitsPerSample;
    private int photoInterp;
    private int samplesPerPixel;
    private int nEntries;
    private int ifdSize;
    private int imageOffset = 768;
    private int imageSize;
    private int stackSize;
    private byte[] description;

    public TiffEncoder(FileInfo fi) {
        this.fi = fi;
        fi.intelByteOrder = false;
        this.bitsPerSample = 8;
        this.samplesPerPixel = 1;
        this.nEntries = 9;
        int bytesPerPixel = 1;
        switch (fi.fileType) {
            case 0: {
                this.photoInterp = fi.whiteIsZero ? 0 : 1;
                break;
            }
            case 1: 
            case 2: {
                this.bitsPerSample = 16;
                this.photoInterp = fi.whiteIsZero ? 0 : 1;
                bytesPerPixel = 2;
                break;
            }
            case 4: {
                this.bitsPerSample = 32;
                this.photoInterp = fi.whiteIsZero ? 0 : 1;
                bytesPerPixel = 4;
                break;
            }
            case 6: {
                this.photoInterp = 2;
                this.samplesPerPixel = 3;
                bytesPerPixel = 3;
                break;
            }
            case 5: {
                this.photoInterp = 3;
                this.nEntries = 10;
                break;
            }
            default: {
                this.photoInterp = 0;
            }
        }
        if (fi.unit != null && fi.pixelWidth != 0.0 && fi.pixelHeight != 0.0) {
            this.nEntries += 3;
        }
        if (fi.fileType == 4) {
            ++this.nEntries;
        }
        this.makeDescriptionString();
        if (this.description != null) {
            ++this.nEntries;
        }
        this.ifdSize = 2 + this.nEntries * 12 + 4;
        this.imageSize = fi.width * fi.height * bytesPerPixel;
        this.stackSize = this.imageSize * fi.nImages;
    }

    public void write(DataOutputStream out) throws IOException {
        this.writeHeader(out);
        int nextIFD = 0;
        if (this.fi.nImages > 1) {
            nextIFD = 768 + this.stackSize;
            if (this.fi.fileType == 5) {
                nextIFD += 1536;
            }
        }
        this.writeIFD(out, this.imageOffset, nextIFD);
        int bpsSize = 0;
        int scaleSize = 0;
        int descriptionSize = 0;
        if (this.fi.fileType == 6) {
            bpsSize = this.writeBitsPerPixel(out);
        }
        if (this.description != null) {
            descriptionSize = this.writeDescription(out);
        }
        if (this.fi.unit != null && this.fi.pixelWidth != 0.0 && this.fi.pixelHeight != 0.0) {
            scaleSize = this.writeScale(out);
        }
        byte[] filler = new byte[768 - (8 + this.ifdSize + bpsSize + descriptionSize + scaleSize)];
        out.write(filler);
        new ImageWriter(this.fi).write(out);
        if (this.fi.fileType == 5) {
            this.writeColorMap(out);
        }
        for (int i = 2; i <= this.fi.nImages; ++i) {
            nextIFD = i == this.fi.nImages ? 0 : (nextIFD += this.ifdSize);
            this.imageOffset += this.imageSize;
            this.writeIFD(out, this.imageOffset, nextIFD);
        }
    }

    void writeHeader(DataOutputStream out) throws IOException {
        byte[] hdr = new byte[]{77, 77, 0, 42, 0, 0, 0, 8};
        out.write(hdr);
    }

    void writeEntry(DataOutputStream out, int tag, int fieldType, int count, int value) throws IOException {
        out.writeShort(tag);
        out.writeShort(fieldType);
        out.writeInt(count);
        if (count == 1 && fieldType == 3) {
            value <<= 16;
        }
        out.writeInt(value);
    }

    void writeIFD(DataOutputStream out, int imageOffset, int nextIFD) throws IOException {
        int tagDataOffset = 8 + this.ifdSize;
        out.writeShort(this.nEntries);
        this.writeEntry(out, 254, 4, 1, 0);
        this.writeEntry(out, 256, 3, 1, this.fi.width);
        this.writeEntry(out, 257, 3, 1, this.fi.height);
        if (this.fi.fileType == 6) {
            this.writeEntry(out, 258, 3, 3, tagDataOffset);
            tagDataOffset += 6;
        } else {
            this.writeEntry(out, 258, 3, 1, this.bitsPerSample);
        }
        this.writeEntry(out, 262, 3, 1, this.photoInterp);
        if (this.description != null) {
            this.writeEntry(out, 270, 2, this.description.length, tagDataOffset);
            tagDataOffset += this.description.length;
        }
        this.writeEntry(out, 273, 4, 1, imageOffset);
        this.writeEntry(out, 277, 3, 1, this.samplesPerPixel);
        this.writeEntry(out, 278, 3, 1, this.fi.height);
        this.writeEntry(out, 279, 4, 1, this.imageSize);
        if (this.fi.unit != null && this.fi.pixelWidth != 0.0 && this.fi.pixelHeight != 0.0) {
            this.writeEntry(out, 282, 5, 1, tagDataOffset);
            this.writeEntry(out, 283, 5, 1, tagDataOffset + 8);
            tagDataOffset += 16;
            int unit = 1;
            if (this.fi.unit.equals("inch")) {
                unit = 2;
            } else if (this.fi.unit.equals("cm")) {
                unit = 3;
            }
            this.writeEntry(out, 296, 3, 1, unit);
        }
        if (this.fi.fileType == 4) {
            int format = 3;
            this.writeEntry(out, 339, 3, 1, format);
        }
        if (this.fi.fileType == 5) {
            this.writeEntry(out, 320, 3, 768, 768 + this.stackSize);
        }
        out.writeInt(nextIFD);
    }

    int writeBitsPerPixel(DataOutputStream out) throws IOException {
        out.writeShort(8);
        out.writeShort(8);
        out.writeShort(8);
        return 6;
    }

    int writeScale(DataOutputStream out) throws IOException {
        double xscale = 1.0 / this.fi.pixelWidth;
        double yscale = 1.0 / this.fi.pixelHeight;
        double scale = 1000000.0;
        if (xscale > 1000.0) {
            scale = 1000.0;
        }
        out.writeInt((int)(xscale * scale));
        out.writeInt((int)scale);
        out.writeInt((int)(yscale * scale));
        out.writeInt((int)scale);
        return 16;
    }

    int writeDescription(DataOutputStream out) throws IOException {
        out.write(this.description, 0, this.description.length);
        return this.description.length;
    }

    void writeColorMap(DataOutputStream out) throws IOException {
        byte[] colorTable16 = new byte[1536];
        int j = 0;
        for (int i = 0; i < this.fi.lutSize; ++i) {
            colorTable16[j] = this.fi.reds[i];
            colorTable16[512 + j] = this.fi.greens[i];
            colorTable16[1024 + j] = this.fi.blues[i];
            j += 2;
        }
        out.write(colorTable16);
    }

    void makeDescriptionString() {
        if (this.fi.description != null) {
            if (this.fi.description.charAt(this.fi.description.length() - 1) != '\u0000') {
                this.fi.description = this.fi.description + " ";
            }
            this.description = this.fi.description.getBytes();
            this.description[this.description.length - 1] = 0;
        } else {
            this.description = null;
        }
    }
}

