/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PlotWindow;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Variable;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Info;
import ij.plugin.frame.Editor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class Functions
implements MacroConstants,
Measurements {
    Interpreter interp;
    Program pgm;
    boolean updateNeeded;
    boolean autoUpdate = true;
    ImagePlus imp;
    ImageProcessor ip;
    int imageType;
    boolean colorSet;
    Random ran;

    Functions(Interpreter interp, Program pgm) {
        this.interp = interp;
        this.pgm = pgm;
        Variable.doHash = false;
    }

    void doFunction(int type) {
        switch (type) {
            case 300: {
                this.doRun();
                break;
            }
            case 302: {
                IJ.selectWindow(this.getStringArg());
                this.resetImage();
                break;
            }
            case 303: {
                IJ.wait((int)this.getArg());
                break;
            }
            case 304: {
                this.interp.getParens();
                IJ.beep();
                break;
            }
            case 305: {
                this.interp.getParens();
                IJ.resetMinAndMax();
                this.resetImage();
                break;
            }
            case 306: {
                this.interp.getParens();
                IJ.resetThreshold();
                this.resetImage();
                break;
            }
            case 307: {
                IJ.log(this.getStringArg());
                break;
            }
            case 308: {
                IJ.write(this.getStringArg());
                break;
            }
            case 309: {
                IJ.doWand((int)this.getFirstArg(), (int)this.getLastArg());
                this.resetImage();
                break;
            }
            case 310: {
                IJ.setMinAndMax(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 311: {
                IJ.setThreshold(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 312: {
                IJ.setTool((int)this.getArg());
                break;
            }
            case 313: {
                this.setForegroundColor();
                break;
            }
            case 314: {
                this.setBackgroundColor();
                break;
            }
            case 336: {
                this.setColor();
                break;
            }
            case 315: {
                this.makeLine();
                break;
            }
            case 316: {
                this.makeOval();
                break;
            }
            case 317: {
                this.makeRectangle();
                break;
            }
            case 318: {
                this.interp.dump();
                break;
            }
            case 320: {
                this.lineTo();
                break;
            }
            case 319: {
                this.moveTo();
                break;
            }
            case 321: {
                this.drawLine();
                break;
            }
            case 322: {
                this.requires();
                break;
            }
            case 323: {
                this.autoUpdate = this.getBooleanArg();
                break;
            }
            case 324: {
                this.interp.getParens();
                this.updateDisplay();
                break;
            }
            case 325: {
                this.drawString();
                break;
            }
            case 326: {
                IJ.setPasteMode(this.getStringArg());
                break;
            }
            case 327: {
                IJ.doCommand(this.getStringArg());
                break;
            }
            case 328: {
                IJ.showStatus(this.getStringArg());
                this.interp.statusUpdated = true;
                break;
            }
            case 329: {
                this.showProgress();
                break;
            }
            case 330: {
                this.showMessage(false);
                break;
            }
            case 352: {
                this.showMessage(true);
                break;
            }
            case 331: 
            case 332: {
                this.setPixel();
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                this.doIPMethod(type);
                break;
            }
            case 337: {
                this.getProcessor().setLineWidth((int)this.getArg());
                break;
            }
            case 338: {
                this.changeValues();
                break;
            }
            case 339: {
                IJ.selectWindow((int)this.getArg());
                this.resetImage();
                break;
            }
            case 340: {
                this.exit();
                break;
            }
            case 341: {
                this.getImage().getWindow().setLocation((int)this.getFirstArg(), (int)this.getLastArg());
                break;
            }
            case 342: {
                this.getCursorLoc();
                break;
            }
            case 343: {
                this.getLine();
                break;
            }
            case 344: {
                this.getVoxelSize();
                break;
            }
            case 345: {
                this.getHistogram();
                break;
            }
            case 346: {
                this.getStatistics();
                break;
            }
            case 347: {
                this.graph();
                break;
            }
            case 348: {
                this.getBoundingRect();
                break;
            }
            case 349: {
                this.getLut();
                break;
            }
            case 350: {
                this.setLut();
                break;
            }
            case 351: {
                this.getCoordinates();
            }
        }
    }

    final double getFunctionValue(int type) {
        double value = 0.0;
        switch (type) {
            case 1000: {
                value = this.getPixel();
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1027: {
                value = this.math(type);
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: {
                value = this.math2(type);
                break;
            }
            case 1013: {
                this.interp.getParens();
                value = System.currentTimeMillis();
                break;
            }
            case 1014: {
                this.interp.getParens();
                value = this.getImage().getWidth();
                break;
            }
            case 1015: {
                this.interp.getParens();
                value = this.getImage().getHeight();
                break;
            }
            case 1016: {
                value = this.random();
                break;
            }
            case 1018: 
            case 1023: {
                value = this.getResultsCount();
                break;
            }
            case 1017: {
                value = this.getResult();
                break;
            }
            case 1019: {
                value = this.getNumber();
                break;
            }
            case 1020: {
                value = this.getImageCount();
                break;
            }
            case 1021: {
                value = this.getStackSize();
                break;
            }
            case 1022: {
                value = this.lengthOf();
                break;
            }
            case 1024: {
                this.interp.getParens();
                value = this.getImage().getID();
                break;
            }
            case 1025: {
                this.interp.getParens();
                value = this.getImage().getBitDepth();
                break;
            }
            case 1026: {
                value = this.getSelectionType();
                break;
            }
            case 1028: {
                value = this.isOpen();
                break;
            }
            case 1029: {
                value = this.isActive();
                break;
            }
            case 1030: {
                value = this.indexOf();
                break;
            }
            case 1031: {
                value = this.getFirstStringArg().lastIndexOf(this.getLastStringArg());
                break;
            }
            case 1032: {
                value = this.getFirstStringArg().charAt((int)this.getLastArg());
                break;
            }
            default: {
                this.interp.error("Numeric function expected");
            }
        }
        return value;
    }

    String getStringFunction(int type) {
        String str;
        switch (type) {
            case 2000: {
                str = this.d2s();
                break;
            }
            case 2001: {
                str = this.toString(16);
                break;
            }
            case 2002: {
                str = this.toString(2);
                break;
            }
            case 2003: {
                this.interp.getParens();
                str = this.getImage().getTitle();
                break;
            }
            case 2004: {
                str = this.getStringDialog();
                break;
            }
            case 2005: {
                str = this.substring();
                break;
            }
            case 2006: {
                str = this.fromCharCode();
                break;
            }
            case 2007: {
                str = this.getInfo();
                break;
            }
            default: {
                str = "";
                this.interp.error("String function expected");
            }
        }
        return str;
    }

    Variable[] getArrayFunction(int type) {
        Variable[] array;
        switch (type) {
            case 3000: {
                array = this.getProfile();
                break;
            }
            case 3001: {
                array = this.newArray();
                break;
            }
            case 3002: {
                array = this.split();
                break;
            }
            default: {
                array = null;
                this.interp.error("Array function expected");
            }
        }
        return array;
    }

    final double math(int type) {
        double arg = this.getArg();
        switch (type) {
            case 1001: {
                return Math.abs(arg);
            }
            case 1002: {
                return Math.cos(arg);
            }
            case 1003: {
                return Math.exp(arg);
            }
            case 1004: {
                return Math.floor(arg);
            }
            case 1005: {
                return Math.log(arg);
            }
            case 1009: {
                return Math.round(arg);
            }
            case 1010: {
                return Math.sin(arg);
            }
            case 1011: {
                return Math.sqrt(arg);
            }
            case 1012: {
                return Math.tan(arg);
            }
            case 1027: {
                return Math.atan(arg);
            }
        }
        return 0.0;
    }

    final double math2(int type) {
        double a1 = this.getFirstArg();
        double a2 = this.getLastArg();
        switch (type) {
            case 1007: {
                return Math.min(a1, a2);
            }
            case 1006: {
                return Math.max(a1, a2);
            }
            case 1008: {
                return Math.pow(a1, a2);
            }
        }
        return 0.0;
    }

    final String getString() {
        String str = this.interp.getStringTerm();
        while (true) {
            this.interp.getToken();
            if (this.interp.token != 43) break;
            str = str + this.interp.getStringTerm();
        }
        this.interp.putTokenBack();
        return str;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.interp.tokenAddress];
        return symbol.type == 2000;
    }

    final double getArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    final double getFirstArg() {
        this.interp.getLeftParen();
        return this.interp.getExpression();
    }

    final double getNextArg() {
        this.interp.getComma();
        return this.interp.getExpression();
    }

    final double getLastArg() {
        this.interp.getComma();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    String getStringArg() {
        this.interp.getLeftParen();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    final String getFirstStringArg() {
        this.interp.getLeftParen();
        return this.getString();
    }

    final String getNextStringArg() {
        this.interp.getComma();
        return this.getString();
    }

    final String getLastStringArg() {
        this.interp.getComma();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    boolean getBooleanArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getBooleanExpression();
        this.interp.checkBoolean(arg);
        this.interp.getRightParen();
        return arg != 0.0;
    }

    final Variable getFirstVariable() {
        this.interp.getLeftParen();
        return this.getVariable();
    }

    final Variable getNextVariable() {
        this.interp.getComma();
        return this.getVariable();
    }

    final Variable getLastVariable() {
        this.interp.getComma();
        Variable v = this.getVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getVariable() {
        Variable[] array;
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        if ((array = v.getArray()) != null) {
            int index = this.interp.getIndex();
            this.checkIndex(index, 0, array.length - 1);
            v = array[index];
        }
        return v;
    }

    final Variable getFirstArrayVariable() {
        this.interp.getLeftParen();
        return this.getArrayVariable();
    }

    final Variable getNextArrayVariable() {
        this.interp.getComma();
        return this.getArrayVariable();
    }

    final Variable getLastArrayVariable() {
        this.interp.getComma();
        Variable v = this.getArrayVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getArrayVariable() {
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        return v;
    }

    final double[] getFirstArray() {
        this.interp.getLeftParen();
        return this.getArray();
    }

    final double[] getNextArray() {
        this.interp.getComma();
        return this.getArray();
    }

    final double[] getLastArray() {
        this.interp.getComma();
        double[] a = this.getArray();
        this.interp.getRightParen();
        return a;
    }

    double[] getArray() {
        Variable[] a1;
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Array expected");
        }
        if ((v = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            this.interp.error("Undefined variable");
        }
        if ((a1 = v.getArray()) == null) {
            this.interp.error("Array expected");
        }
        double[] a2 = new double[a1.length];
        for (int i = 0; i < a1.length; ++i) {
            a2[i] = a1[i].getValue();
        }
        return a2;
    }

    void checkIndex(int index, int lower, int upper) {
        if (index < lower || index > upper) {
            this.interp.error("Index (" + index + ") is outside of the " + lower + "-" + upper + " range");
        }
    }

    void doRun() {
        this.interp.getLeftParen();
        String arg1 = this.getString();
        this.interp.getToken();
        if (this.interp.token != 41 && this.interp.token != 44) {
            this.interp.error("',' or ')'  expected");
        }
        String arg2 = null;
        if (this.interp.token == 44) {
            arg2 = this.getString();
            this.interp.getRightParen();
        }
        if (arg2 != null) {
            IJ.run(arg1, arg2);
        } else {
            IJ.run(arg1);
        }
        this.resetImage();
    }

    void setForegroundColor() {
        IJ.setForegroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setBackgroundColor() {
        IJ.setBackgroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setColor() {
        double color = this.getFirstArg();
        this.colorSet = true;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            this.setColor(color);
            return;
        }
        int red = (int)color;
        int green = (int)this.getNextArg();
        int blue = (int)this.getLastArg();
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        Color c = new Color(red, green, blue);
        this.getProcessor().setColor(c);
    }

    void setColor(double color) {
        ImageProcessor ip = this.getProcessor();
        switch (this.imp.getBitDepth()) {
            case 8: {
                if (color < 0.0 || color > 255.0) {
                    this.interp.error("Argument out of 8-bit range (0-255)");
                }
                ip.setValue(color);
                break;
            }
            case 16: {
                if (color < 0.0 || color > 65535.0) {
                    this.interp.error("Argument out of 16-bit range (0-65535)");
                }
                ip.setValue(color);
                break;
            }
            default: {
                ip.setValue(color);
            }
        }
    }

    void makeLine() {
        IJ.makeLine((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeOval() {
        IJ.makeOval((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeRectangle() {
        IJ.makeRectangle((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    ImagePlus getImage() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        if (this.imp.getWindow() == null) {
            throw new RuntimeException("Macro canceled");
        }
        return this.imp;
    }

    void resetImage() {
        this.imp = null;
        this.ip = null;
    }

    ImageProcessor getProcessor() {
        if (this.ip == null) {
            this.ip = this.getImage().getProcessor();
        }
        return this.ip;
    }

    int getType() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        this.imageType = this.imp.getType();
        return this.imageType;
    }

    double getPixel() {
        this.interp.getLeftParen();
        int a1 = (int)this.interp.getExpression();
        this.interp.getComma();
        int a2 = (int)this.interp.getExpression();
        this.interp.getRightParen();
        double value = 0.0;
        ImageProcessor ip = this.getProcessor();
        value = this.getType() == 2 ? (double)ip.getPixelValue(a1, a2) : (double)ip.getPixel(a1, a2);
        return value;
    }

    void setPixel() {
        this.interp.getLeftParen();
        int a1 = (int)this.interp.getExpression();
        this.interp.getComma();
        int a2 = (int)this.interp.getExpression();
        this.interp.getComma();
        double a3 = this.interp.getExpression();
        this.interp.getRightParen();
        if (this.getType() == 2) {
            this.getProcessor().putPixelValue(a1, a2, a3);
        } else {
            this.getProcessor().putPixel(a1, a2, (int)a3);
        }
        this.updateNeeded = true;
    }

    void moveTo() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().moveTo(a1, a2);
    }

    void lineTo() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.lineTo(a1, a2);
        this.updateAndDraw(this.imp);
    }

    void drawLine() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a3 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a4 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.drawLine(a1, a2, a3, a4);
        this.updateAndDraw(this.imp);
    }

    void setForegroundColor(ImageProcessor ip) {
        ip.setColor(Toolbar.getForegroundColor());
        this.colorSet = true;
    }

    void doIPMethod(int type) {
        this.interp.getParens();
        ImageProcessor ip = this.getProcessor();
        switch (type) {
            case 333: {
                ip.snapshot();
                break;
            }
            case 334: {
                ip.reset();
                break;
            }
            case 335: {
                ImagePlus imp = this.getImage();
                Roi roi = imp.getRoi();
                if (!this.colorSet) {
                    this.setForegroundColor(ip);
                }
                if (roi == null) {
                    ip.resetRoi();
                    ip.fill();
                } else {
                    ip.setRoi(roi.getBoundingRect());
                    ip.fill(imp.getMask());
                }
                this.updateAndDraw(imp);
            }
        }
    }

    void updateAndDraw(ImagePlus imp) {
        if (this.autoUpdate) {
            imp.updateAndDraw();
        } else {
            this.updateNeeded = true;
        }
    }

    void updateDisplay() {
        if (this.updateNeeded) {
            ImagePlus imp = this.getImage();
            imp.updateAndDraw();
            this.updateNeeded = false;
        }
    }

    void drawString() {
        this.interp.getLeftParen();
        String str = this.getString();
        this.interp.getComma();
        int x = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int y = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.drawString(str, x, y);
        this.updateAndDraw(this.imp);
    }

    void changeValues() {
        double darg1 = this.getFirstArg();
        double darg2 = this.getNextArg();
        double darg3 = this.getLastArg();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        Roi roi = imp.getRoi();
        int[] mask = null;
        if (roi == null || roi.getType() > 4) {
            ip.resetRoi();
            roi = null;
        } else {
            ip.setRoi(roi.getBoundingRect());
            mask = imp.getMask();
            ip.setMask(mask);
            if (mask != null) {
                ip.snapshot();
            }
        }
        int xmin = 0;
        int ymin = 0;
        int xmax = imp.getWidth();
        int ymax = imp.getHeight();
        if (roi != null) {
            Rectangle r = roi.getBoundingRect();
            xmin = r.x;
            ymin = r.y;
            xmax = r.x + r.width;
            ymax = r.y + r.height;
        }
        boolean isFloat = this.getType() == 2;
        for (int y = ymin; y < ymax; ++y) {
            for (int x = xmin; x < xmax; ++x) {
                double v;
                double d = v = isFloat ? (double)ip.getPixelValue(x, y) : (double)(ip.getPixel(x, y) & 0xFFFFFF);
                if (!(v >= darg1) || !(v <= darg2)) continue;
                if (isFloat) {
                    ip.putPixelValue(x, y, darg3);
                    continue;
                }
                ip.putPixel(x, y, (int)darg3);
            }
        }
        if (mask != null) {
            ip.reset(mask);
        }
        if (imp.getType() == 1 || imp.getType() == 2) {
            ip.resetMinAndMax();
        }
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void requires() {
        if (IJ.versionLessThan(this.getStringArg())) {
            this.interp.done = true;
        }
    }

    double random() {
        this.interp.getParens();
        if (this.ran == null) {
            this.ran = new Random();
        }
        return this.ran.nextDouble();
    }

    double getResult() {
        this.interp.getLeftParen();
        String kind = this.getString();
        this.interp.getComma();
        int row = (int)this.interp.getExpression();
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        int col = rt.getColumnIndex(kind);
        if (col == -1) {
            this.interp.error("'" + kind + "' not found");
        }
        if (row < 0 || row >= rt.getCounter()) {
            this.interp.error("Row (" + row + ") out of range");
        }
        return rt.getValue(col, row);
    }

    double getNumber() {
        String title;
        this.interp.getLeftParen();
        String prompt = this.getString();
        this.interp.getComma();
        double defaultValue = this.interp.getExpression();
        this.interp.getRightParen();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        int decimalPlaces = (double)((int)defaultValue) == defaultValue ? 0 : 2;
        gd.addNumericField(prompt, defaultValue, decimalPlaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.interp.done = true;
            return defaultValue;
        }
        double v = gd.getNextNumber();
        if (gd.invalidNumber()) {
            return defaultValue;
        }
        return v;
    }

    String getStringDialog() {
        String title;
        this.interp.getLeftParen();
        String prompt = this.getString();
        this.interp.getComma();
        String defaultStr = this.getString();
        this.interp.getRightParen();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField(prompt, defaultStr, 20);
        gd.showDialog();
        String str = "";
        if (gd.wasCanceled()) {
            this.interp.done = true;
        } else {
            str = gd.getNextString();
        }
        return str;
    }

    String d2s() {
        return IJ.d2s(this.getFirstArg(), (int)this.getLastArg());
    }

    String toString(int base) {
        int arg = (int)this.getArg();
        if (base == 2) {
            return Integer.toBinaryString(arg);
        }
        return Integer.toHexString(arg);
    }

    double getStackSize() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return this.getImage().getStackSize();
    }

    double getImageCount() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return WindowManager.getWindowCount();
    }

    double getResultsCount() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return Analyzer.getResultsTable().getCounter();
    }

    void getCoordinates() {
        Variable xCoordinates = this.getFirstArrayVariable();
        Variable yCoordinates = this.getLastArrayVariable();
        this.resetImage();
        ImageProcessor ip = this.getProcessor();
        Roi roi = this.imp.getRoi();
        if (roi == null || !(roi instanceof PolygonRoi)) {
            this.interp.error("Polygonal selection required");
        }
        int[] x = ((PolygonRoi)roi).getXCoordinates();
        int[] y = ((PolygonRoi)roi).getYCoordinates();
        int n = ((PolygonRoi)roi).getNCoordinates();
        Rectangle r = roi.getBoundingRect();
        int[] x2 = new int[n];
        int[] y2 = new int[n];
        for (int i = 0; i < n; ++i) {
            x2[i] = r.x + x[i];
            y2[i] = r.y + y[i];
        }
        xCoordinates.setArray(new Variable(x2).getArray());
        yCoordinates.setArray(new Variable(y2).getArray());
    }

    Variable[] getProfile() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ProfilePlot pp = new ProfilePlot(imp, false, false);
        double[] array = pp.getProfile();
        if (array == null) {
            this.interp.done = true;
            return null;
        }
        return new Variable(array).getArray();
    }

    Variable[] newArray() {
        this.interp.getLeftParen();
        if (this.interp.nextNonEolToken() == 133 || this.interp.nextNextNonEolToken() == 44) {
            return this.initNewArray();
        }
        int size = (int)this.interp.getExpression();
        this.interp.getRightParen();
        Variable[] array = new Variable[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new Variable();
        }
        return array;
    }

    Variable[] split() {
        String[] strings;
        String s1 = this.getFirstStringArg();
        String s2 = this.getLastStringArg();
        StringTokenizer t = s2.equals("") ? new StringTokenizer(s1) : new StringTokenizer(s1, s2);
        int tokens = t.countTokens();
        if (tokens > 0) {
            strings = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                strings[i] = t.nextToken();
            }
        } else {
            strings = new String[]{s1};
            tokens = 1;
        }
        Variable[] array = new Variable[tokens];
        for (int i = 0; i < tokens; ++i) {
            array[i] = new Variable(0, 0.0, strings[i]);
        }
        return array;
    }

    Variable[] initNewArray() {
        Vector<Variable> vector = new Vector<Variable>();
        int size = 0;
        do {
            Variable v = new Variable();
            if (this.interp.nextNonEolToken() == 133) {
                v.setString(this.getString());
            } else {
                v.setValue(this.interp.getExpression());
            }
            vector.addElement(v);
            ++size;
            this.interp.getToken();
        } while (this.interp.token == 44);
        if (this.interp.token != 41) {
            this.interp.error("';' expected");
        }
        Object[] array = new Variable[size];
        vector.copyInto(array);
        return array;
    }

    String fromCharCode() {
        char[] chars = new char[100];
        int count = 0;
        this.interp.getLeftParen();
        while (this.interp.nextToken() != 41) {
            int value = (int)this.interp.getExpression();
            if (value < 0 || value > 65535) {
                this.interp.error("Value (" + value + ") out of 0-65535 range");
            }
            chars[count++] = (char)value;
            if (this.interp.nextToken() != 44) continue;
            this.interp.getToken();
        }
        this.interp.getRightParen();
        return new String(chars);
    }

    public String getInfo() {
        this.interp.getParens();
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextPanel tp = ((TextWindow)frame).getTextPanel();
            return tp.getText();
        }
        if (frame != null && frame instanceof Editor) {
            return ((Editor)frame).getText();
        }
        ImagePlus imp = this.getImage();
        Info infoPlugin = new Info();
        return infoPlugin.getImageInfo(imp, this.getProcessor());
    }

    double getSelectionType() {
        this.interp.getParens();
        double type = -1.0;
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            type = roi.getType();
        }
        return type;
    }

    void showMessage(boolean withCancel) {
        String message;
        this.interp.getLeftParen();
        String title = this.getString();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            message = this.getString();
        } else {
            message = title;
            title = "";
        }
        this.interp.getRightParen();
        if (withCancel) {
            IJ.showMessageWithCancel(title, message);
        } else {
            IJ.showMessage(title, message);
        }
    }

    double lengthOf() {
        int length = 0;
        this.interp.getLeftParen();
        switch (this.interp.nextToken()) {
            case 133: 
            case 136: 
            case 138: {
                length = this.getString().length();
                break;
            }
            case 129: {
                this.interp.getToken();
                Variable v = this.interp.lookupNumericVariable();
                if (v == null) {
                    return 0.0;
                }
                String s = v.getString();
                if (s != null) {
                    length = s.length();
                    break;
                }
                Variable[] array = v.getArray();
                if (array != null) {
                    length = array.length;
                    break;
                }
                this.interp.error("String or array expected");
                break;
            }
            default: {
                this.interp.error("String or array expected");
            }
        }
        this.interp.getRightParen();
        return length;
    }

    void getCursorLoc() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable z = this.getNextVariable();
        Variable flags = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        ImageCanvas ic = win.getCanvas();
        Point p = ic.getCursorLoc();
        x.setValue(p.x);
        y.setValue(p.y);
        z.setValue(imp.getCurrentSlice() - 1);
        flags.setValue(ic.getModifiers());
    }

    void getLine() {
        Variable vx1 = this.getFirstVariable();
        Variable vy1 = this.getNextVariable();
        Variable vx2 = this.getNextVariable();
        Variable vy2 = this.getNextVariable();
        Variable lineWidth = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        int x1 = -1;
        int y1 = -1;
        int x2 = -1;
        int y2 = -1;
        Roi roi = imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1;
            y1 = line.y1;
            x2 = line.x2;
            y2 = line.y2;
        }
        vx1.setValue(x1);
        vy1.setValue(y1);
        vx2.setValue(x2);
        vy2.setValue(y2);
        lineWidth.setValue(Line.getWidth());
    }

    void getVoxelSize() {
        Variable width = this.getFirstVariable();
        Variable height = this.getNextVariable();
        Variable depth = this.getNextVariable();
        Variable unit = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Calibration cal = imp.getCalibration();
        width.setValue(cal.pixelWidth);
        height.setValue(cal.pixelHeight);
        depth.setValue(cal.pixelDepth);
        unit.setString(cal.getUnit());
    }

    void getHistogram() {
        Variable[] array;
        this.interp.getLeftParen();
        Variable values = null;
        if (this.interp.nextToken() == 130) {
            this.interp.getExpression();
        } else {
            values = this.getArrayVariable();
        }
        Variable counts = this.getNextArrayVariable();
        int nBins = (int)this.getLastArg();
        ImagePlus imp = this.getImage();
        int bitDepth = imp.getBitDepth();
        if (bitDepth != 32 && nBins != 256) {
            this.interp.error("Bin count (" + nBins + ") must be 256 for non-float images");
        }
        ImageStatistics stats = imp.getStatistics(27, nBins);
        if (values != null) {
            Calibration cal = imp.getCalibration();
            double[] array2 = new double[nBins];
            double value = cal.getCValue(stats.histMin);
            double inc = 1.0;
            if (bitDepth == 16 || bitDepth == 32 || cal.calibrated()) {
                inc = (cal.getCValue(stats.histMax) - cal.getCValue(stats.histMin)) / (double)stats.nBins;
            }
            for (int i = 0; i < nBins; ++i) {
                array2[i] = value;
                value += inc;
            }
            values.setArray(new Variable(array2).getArray());
        }
        if ((array = counts.getArray()) != null && array.length == nBins) {
            for (int i = 0; i < nBins; ++i) {
                array[i].setValue(stats.histogram[i]);
            }
        } else {
            counts.setArray(new Variable(stats.histogram).getArray());
        }
    }

    void getLut() {
        Variable reds = this.getFirstArrayVariable();
        Variable greens = this.getNextArrayVariable();
        Variable blues = this.getLastArrayVariable();
        this.resetImage();
        ImageProcessor ip = this.getProcessor();
        if (ip instanceof ColorProcessor) {
            this.interp.error("Non-RGB image expected");
        }
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        int mapSize = cm.getMapSize();
        byte[] rLUT = new byte[mapSize];
        byte[] gLUT = new byte[mapSize];
        byte[] bLUT = new byte[mapSize];
        cm.getReds(rLUT);
        cm.getGreens(gLUT);
        cm.getBlues(bLUT);
        reds.setArray(new Variable(rLUT).getArray());
        greens.setArray(new Variable(gLUT).getArray());
        blues.setArray(new Variable(bLUT).getArray());
    }

    void setLut() {
        double[] reds = this.getFirstArray();
        double[] greens = this.getNextArray();
        double[] blues = this.getLastArray();
        int length = reds.length;
        if (greens.length != length || blues.length != length) {
            this.interp.error("Arrays are not the same length");
        }
        this.resetImage();
        ImagePlus imp = this.getImage();
        if (imp.getBitDepth() == 24) {
            this.interp.error("Non-RGB image expected");
        }
        ImageProcessor ip = this.getProcessor();
        byte[] r = new byte[length];
        byte[] g = new byte[length];
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            r[i] = (byte)reds[i];
            g[i] = (byte)greens[i];
            b[i] = (byte)blues[i];
        }
        ip.setColorModel(new IndexColorModel(8, length, r, g, b));
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void graph() {
        this.interp.getLeftParen();
        String title = this.getString();
        this.interp.getComma();
        double[] x = this.getArray();
        this.interp.getComma();
        double[] y = this.getArray();
        this.interp.getComma();
        String xLabel = this.getString();
        this.interp.getComma();
        String yLabel = this.getString();
        this.interp.getRightParen();
        PlotWindow pw = new PlotWindow(title, xLabel, yLabel, x, y);
        pw.draw();
    }

    void getBoundingRect() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable width = this.getNextVariable();
        Variable height = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBoundingRect();
            x.setValue(r.x);
            y.setValue(r.y);
            width.setValue(r.width);
            height.setValue(r.height);
        } else {
            x.setValue(0.0);
            y.setValue(0.0);
            width.setValue(imp.getWidth());
            height.setValue(imp.getHeight());
        }
    }

    void getStatistics() {
    }

    String substring() {
        int index2;
        String s = this.getFirstStringArg();
        int index1 = (int)this.getNextArg();
        if (index1 > (index2 = (int)this.getLastArg())) {
            this.interp.error("beginIndex>endIndex");
        }
        this.checkIndex(index1, 0, s.length());
        this.checkIndex(index2, 0, s.length());
        return s.substring(index1, index2);
    }

    int indexOf() {
        String s1 = this.getFirstStringArg();
        String s2 = this.getNextStringArg();
        int fromIndex = 0;
        if (this.interp.nextToken() == 44) {
            fromIndex = (int)this.getLastArg();
            this.checkIndex(fromIndex, 0, s1.length() - 1);
        } else {
            this.interp.getRightParen();
        }
        if (fromIndex == 0) {
            return s1.indexOf(s2);
        }
        return s1.indexOf(s2, fromIndex);
    }

    double isActive() {
        int id = (int)this.getArg();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getID() != id) {
            return 0.0;
        }
        return 1.0;
    }

    double isOpen() {
        this.interp.getLeftParen();
        if (this.interp.nextToken() == 133) {
            String title = this.getString();
            this.interp.getRightParen();
            return WindowManager.getFrame(title) == null ? 0.0 : 1.0;
        }
        int id = (int)this.interp.getExpression();
        this.interp.getRightParen();
        return WindowManager.getImage(id) == null ? 0.0 : 1.0;
    }

    void exit() {
        String msg = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.interp.nextToken() == 133 || this.interp.nextToken() == 136) {
                msg = this.getString();
            }
            this.interp.getRightParen();
        }
        IJ.showStatus("");
        IJ.showProgress(1.0);
        if (msg != null) {
            IJ.showMessage("Macro", msg);
        }
        throw new RuntimeException("Macro canceled");
    }

    void showProgress() {
        this.interp.getLeftParen();
        double arg1 = this.interp.getExpression();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double arg2 = this.interp.getExpression();
            IJ.showProgress((int)arg1, (int)arg2);
        } else {
            IJ.showProgress(arg1);
        }
        this.interp.getRightParen();
        this.interp.showingProgress = true;
    }
}

