/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.process.ColorProcessor;
import java.awt.Color;

class ColorGenerator
extends ColorProcessor {
    int w;
    int h;
    int[] colors = new int[]{0xFFFFFF, 0x700000, 0xB00000, 0xFF0000, 0xFF6000, 0xFFAABB, 14381203, 16716947, 0xCD5C5C, 0x900090, 12211667, 0xEE82EE, 0xFF00FF, 4734347, 0xBB0088, 0, 112, 176, 255, 11584734, 49151, 6266528, 65535, 2142890, 6737322, 64154, 28672, 45056, 65280, 28768, 10145074, 0x808000, 0xFFFFC0, 0xFFFF00, 12433259, 15787660, 12092939, 16762880, 16768685, 16750080, 13789470, 15308410, 14729436, 16772043, 0x606000, 0x600060, 0x8080A0, 0x80A080};

    public ColorGenerator(int width, int height, int[] pixels) {
        super(width, height, pixels);
    }

    void drawColors(int colorWidth, int colorHeight, int columns, int rows) {
        this.w = colorWidth;
        this.h = colorHeight;
        this.drawRamp();
        int x = 0;
        int y = 1;
        for (int i = 0; i < this.colors.length; ++i) {
            this.drawColor(x, y, new Color(this.colors[i]));
            if (++x != columns) continue;
            x = 0;
            if (++y == rows) break;
        }
        this.setRoi(null);
    }

    void drawColor(int x, int y, Color c) {
        this.setRoi(x * this.w, y * this.h, this.w, this.h);
        this.setColor(c);
        this.fill();
    }

    void drawRamp() {
        for (int y = 0; y < this.h; ++y) {
            for (int x = 0; x < 256; ++x) {
                byte b;
                byte g = b = (byte)x;
                byte r = b;
                this.pixels[y * this.width + x] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
            }
        }
    }
}

