/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.plugin.frame.PlugInFrame;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.util.BufferToImage;

public class JMF_Movie_Reader
extends PlugInFrame
implements ControllerListener,
ActionListener {
    Player p;
    FramePositioningControl fpc;
    FrameGrabbingControl fgc;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    int totalFrames = Integer.MAX_VALUE;
    BufferToImage frameConverter;
    String name;
    boolean grayscale = false;
    ImageStack stack;

    public JMF_Movie_Reader() {
        super("JMF Movie Reader");
    }

    public void run(String arg) {
        IJ.showStatus("");
        OpenDialog od = new OpenDialog("Open Movie...", "");
        String dir = od.getDirectory();
        this.name = od.getFileName();
        if (this.name == null) {
            return;
        }
        String path = dir + this.name;
        String url = this.encodeURL("file://" + path);
        MediaLocator ml = new MediaLocator(url);
        if (ml == null) {
            IJ.write("Cannot build media locator from: ");
            return;
        }
        DataSource ds = null;
        IJ.showStatus("creating JMF data source");
        try {
            ds = Manager.createDataSource((MediaLocator)ml);
        }
        catch (Exception e) {
            IJ.write("Cannot create DataSource from: " + ml);
            return;
        }
        this.openMovie(ds);
    }

    public String encodeURL(String url) {
        int index = 0;
        while (index > -1) {
            index = url.indexOf(32);
            if (index <= -1) continue;
            url = url.substring(0, index) + "%20" + url.substring(index + 1, url.length());
        }
        return url;
    }

    public boolean openMovie(DataSource ds) {
        IJ.showStatus("opening: " + ds.getContentType());
        try {
            this.p = Manager.createPlayer((DataSource)ds);
        }
        catch (Exception e) {
            this.error("Failed to create a player from the given DataSource:\n \n" + e.getMessage());
            return false;
        }
        this.p.addControllerListener((ControllerListener)this);
        this.p.realize();
        if (!this.waitForState(300)) {
            this.error("Failed to realize the JMF player.");
            return false;
        }
        this.fpc = (FramePositioningControl)this.p.getControl("javax.media.control.FramePositioningControl");
        if (this.fpc == null) {
            this.error("The player does not support FramePositioningControl.");
            return false;
        }
        this.fgc = (FrameGrabbingControl)this.p.getControl("javax.media.control.FrameGrabbingControl");
        if (this.fgc == null) {
            this.error("The player does not support FrameGrabbingControl.");
            return false;
        }
        Time duration = this.p.getDuration();
        if (duration != Duration.DURATION_UNKNOWN) {
            this.totalFrames = this.fpc.mapTimeToFrame(duration) + 1;
            if (this.totalFrames == Integer.MAX_VALUE) {
                IJ.write("The FramePositioningControl does not support mapTimeToFrame.");
            }
        } else {
            IJ.write("Movie duration: unknown");
        }
        this.p.prefetch();
        if (!this.waitForState(500)) {
            this.error("Failed to prefetch the player.");
            return false;
        }
        this.setLayout(new FlowLayout());
        Component vc = this.p.getVisualComponent();
        if (vc != null) {
            this.add(vc);
        }
        Buffer frame = this.fgc.grabFrame();
        VideoFormat format = (VideoFormat)frame.getFormat();
        this.frameConverter = new BufferToImage(format);
        this.setVisible(true);
        for (int i = 0; i < this.totalFrames; ++i) {
            int currentFrame = this.fpc.mapTimeToFrame(this.p.getMediaTime());
            IJ.showStatus(currentFrame + 1 + "/" + this.totalFrames);
            IJ.showProgress((double)(currentFrame + 1) / (double)this.totalFrames);
            if (!this.saveImage(i + 1, this.fgc.grabFrame())) break;
            this.fpc.skip(1);
        }
        if (this.stack != null) {
            new ImagePlus(this.name, this.stack).show();
        }
        this.setVisible(false);
        this.dispose();
        IJ.showStatus("");
        return true;
    }

    public void addNotify() {
        super.addNotify();
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (this.p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    public void actionPerformed(ActionEvent ae) {
        int currentFrame = this.fpc.mapTimeToFrame(this.p.getMediaTime());
        if (currentFrame != Integer.MAX_VALUE) {
            IJ.write("Current frame: " + currentFrame);
        }
    }

    private void error(String msg) {
        IJ.showMessage("JMF Movie Reader", msg);
        IJ.showStatus("");
    }

    private boolean saveImage(int count, Buffer frame) {
        Image img = this.frameConverter.createImage(frame);
        ImageProcessor ip = new ColorProcessor(img);
        if (count == 1) {
            int width = ip.getWidth();
            int height = ip.getHeight();
            int size = width * height * this.totalFrames * 4 / 0x100000;
            IJ.showStatus("Allocating " + width + "x" + height + "x" + this.totalFrames + " stack (" + size + "MB)");
            this.stack = this.allocateStack(width, height, this.totalFrames);
            if (this.stack == null) {
                IJ.outOfMemory("JMF Movie Opener");
                return false;
            }
            this.grayscale = this.isGrayscale(ip);
        }
        if (this.grayscale) {
            ip = ip.convertToByte(false);
        }
        this.stack.setPixels(((ImageProcessor)ip).getPixels(), count);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            this.p.setMediaTime(new Time(0L));
        } else if (evt instanceof SizeChangeEvent) {
            // empty if block
        }
    }

    ImageStack allocateStack(int width, int height, int size) {
        byte[] temp;
        ImageStack stack = null;
        try {
            stack = new ImageStack(width, height);
            for (int i = 0; i < size; ++i) {
                if (this.grayscale) {
                    stack.addSlice(null, new byte[width * height]);
                    continue;
                }
                stack.addSlice(null, new int[width * height]);
            }
            temp = new byte[width * height * 4 * 5 + 1000000];
        }
        catch (OutOfMemoryError e) {
            Object[] arrays;
            if (stack != null && (arrays = stack.getImageArray()) != null) {
                for (int i = 0; i < arrays.length; ++i) {
                    arrays[i] = null;
                }
            }
            stack = null;
        }
        temp = null;
        System.gc();
        System.gc();
        return stack;
    }

    boolean isGrayscale(ImageProcessor ip) {
        int[] pixels = (int[])ip.getPixels();
        boolean grayscale = true;
        for (int i = 0; i < pixels.length; ++i) {
            int c = pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            if (r == g && r == b && g == b) continue;
            grayscale = false;
            break;
        }
        return grayscale;
    }
}

