/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GUI;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.plugin.PlugIn;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class MacroInstaller
implements PlugIn,
MacroConstants,
ActionListener {
    public static final int MAX_SIZE = 28000;
    public static final int MAX_MACROS = 50;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final char commandPrefix = '^';
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb = new MenuBar();
    private int nMacros;
    private Program pgm;
    private boolean firstEvent = true;
    private String shortcutsInUse;
    private int inUseCount;
    private int nShortcuts;
    private String text;
    private String anonymousName;
    private Menu macrosMenu;
    private static String defaultDir;
    private static String fileName;
    private static MacroInstaller instance;
    private static MacroInstaller listener;

    public void run(String path) {
        if (path == null || path.equals("")) {
            path = this.showDialog();
        }
        if (path == null) {
            return;
        }
        String text = this.open(path);
        if (text != null) {
            this.install(text);
        }
    }

    void install() {
        int i;
        if (this.text != null) {
            Tokenizer tok = new Tokenizer();
            this.pgm = tok.tokenize(this.text);
        }
        IJ.showStatus("");
        int[] code = this.pgm.getCode();
        Symbol[] symbolTable = this.pgm.getSymbolTable();
        int count = 0;
        this.shortcutsInUse = null;
        this.inUseCount = 0;
        this.nShortcuts = 0;
        this.macroStarts = new int[50];
        this.macroNames = new String[50];
        int toolCount = 0;
        int itemCount = this.macrosMenu.getItemCount();
        int baseCount = this.macrosMenu == Menus.getMacrosMenu() ? 3 : 2;
        ResourceBundle ijBundle = IJ.getBundle();
        if (itemCount > baseCount) {
            for (i = itemCount - 1; i >= baseCount; --i) {
                this.macrosMenu.remove(i);
            }
        }
        for (i = 0; i < code.length; ++i) {
            int token = code[i] & 0xFFFF;
            if (token == 200) {
                int nextToken = code[i + 1] & 0xFFFF;
                if (nextToken != 133) continue;
                int address = code[i + 1] >> 16;
                Symbol symbol = symbolTable[address];
                String name = symbol.str;
                this.macroStarts[count] = i + 2;
                this.macroNames[count] = name;
                System.out.println(name);
                if (name.indexOf(45) != -1 && (name.indexOf("Tool") != -1 || name.indexOf("tool") != -1)) {
                    Toolbar.getInstance().addMacroTool(name, this, toolCount);
                    ++toolCount;
                } else {
                    this.addShortcut(name);
                    int i1 = name.indexOf(32);
                    if (i1 != -1) {
                        name = name.substring(0, i1);
                    }
                    String labl = null;
                    if (name.startsWith("-")) {
                        labl = name;
                    } else {
                        try {
                            labl = ijBundle.getString(name);
                        }
                        catch (Exception exc) {
                            labl = Prefs.getString(name);
                        }
                    }
                    if (labl == null) {
                        labl = name;
                    }
                    if (labl != null) {
                        this.macrosMenu.add(new MenuItem(labl));
                    }
                }
                if (++count != 50) continue;
                break;
            }
            if (token == 128) break;
        }
        this.nMacros = count;
        if (toolCount > 0) {
            Toolbar tb = Toolbar.getInstance();
            if (Toolbar.getToolId() >= 15) {
                tb.setTool(0);
            }
            tb.repaint();
        }
        if (this.pgm.hasVars() && this.pgm.getGlobals() == null) {
            new Interpreter().saveGlobals(this.pgm);
        }
        MacroInstaller macroInstaller = instance = this.nShortcuts > 0 ? this : null;
        if (this.shortcutsInUse != null && this.text != null) {
            IJ.showMessage("Install Macros", (this.inUseCount == 1 ? "This keyboard shortcut is" : "These keyboard shortcuts are") + " already in use:" + this.shortcutsInUse);
        }
        if (this.nMacros == 0 && fileName != null) {
            int dotIndex = fileName.lastIndexOf(46);
            this.anonymousName = dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
            this.macrosMenu.add(new MenuItem(this.anonymousName));
            this.nMacros = 1;
        }
        String word = this.nMacros == 1 ? " macro" : " macros";
        IJ.showStatus(this.nMacros + word + " installed");
    }

    public int install(String text) {
        if (text == null && this.pgm == null) {
            return 0;
        }
        this.text = text;
        this.macrosMenu = Menus.getMacrosMenu();
        if (listener != null) {
            this.macrosMenu.removeActionListener(listener);
        }
        this.macrosMenu.addActionListener(this);
        listener = this;
        this.install();
        return this.nShortcuts;
    }

    public int install(String text, Menu menu) {
        this.text = text;
        this.macrosMenu = menu;
        this.install();
        return this.nShortcuts;
    }

    void removeShortcuts() {
        Hashtable shortcuts = Menus.getShortcuts();
        Enumeration en = shortcuts.keys();
        while (en.hasMoreElements()) {
            Integer key = (Integer)en.nextElement();
            String value = (String)shortcuts.get(key);
            if (value.charAt(0) != '^') continue;
            shortcuts.remove(key);
        }
    }

    void addShortcut(String name) {
        Hashtable shortcuts;
        int index1 = name.indexOf(91);
        if (index1 == -1) {
            return;
        }
        int index2 = name.lastIndexOf(93);
        if (index2 <= index1 + 1) {
            return;
        }
        String shortcut = name.substring(index1 + 1, index2);
        int len = (shortcut = shortcut.replace('f', 'F')).length();
        if (len > 3 || len > 1 && shortcut.charAt(0) != 'F') {
            return;
        }
        int code = Menus.convertShortcutToCode(shortcut);
        if (code == 0) {
            return;
        }
        if (this.nShortcuts == 0) {
            this.removeShortcuts();
        }
        if ((shortcuts = Menus.getShortcuts()).get(new Integer(code)) != null) {
            if (this.shortcutsInUse == null) {
                this.shortcutsInUse = "\n \n";
            }
            this.shortcutsInUse = this.shortcutsInUse + "    " + name + "\n";
            ++this.inUseCount;
            return;
        }
        shortcuts.put(new Integer(code), '^' + name);
        ++this.nShortcuts;
    }

    String showDialog() {
        FileDialog fd = new FileDialog((Frame)IJ.getInstance(), "Install Macros...");
        if (defaultDir != null) {
            fd.setDirectory(defaultDir);
        } else {
            String macrosDir = Menus.getMacrosPath();
            if (macrosDir != null) {
                fd.setDirectory(macrosDir);
            }
        }
        if (fileName != null) {
            fd.setFile(fileName);
        }
        GUI.center(fd);
        fd.show();
        String name = fd.getFile();
        if (name == null) {
            return null;
        }
        String dir = fd.getDirectory();
        fd.dispose();
        if (!name.endsWith(".txt")) {
            IJ.showMessage("Macro Installer", "File name must end with \".txt\".");
            return null;
        }
        fileName = name;
        defaultDir = dir;
        return dir + name;
    }

    String open(String path) {
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(path));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            return new String(sb);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return null;
        }
    }

    public void runMacroTool(String name) {
        for (int i = 0; i < this.nMacros; ++i) {
            if (!this.macroNames[i].startsWith(name)) continue;
            new MacroRunner(this.pgm, this.macroStarts[i], name);
            return;
        }
    }

    public static void doShortcut(String name) {
        if (instance == null) {
            return;
        }
        for (int i = 0; i < MacroInstaller.instance.nMacros; ++i) {
            if (!name.endsWith(MacroInstaller.instance.macroNames[i])) continue;
            new MacroRunner(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts[i], name);
            return;
        }
    }

    public void runMacro(String name) {
        if (this.anonymousName != null && name.equals(this.anonymousName)) {
            new MacroRunner(this.pgm, 0, this.anonymousName);
            return;
        }
        for (int i = 0; i < this.nMacros; ++i) {
            if (!name.equals(this.macroNames[i])) continue;
            new MacroRunner(this.pgm, this.macroStarts[i], name);
            return;
        }
    }

    public int getMacroCount() {
        return this.nMacros;
    }

    public void setFileName(String fileName) {
        MacroInstaller.fileName = fileName;
    }

    public void actionPerformed(ActionEvent evt) {
        this.runMacro(evt.getActionCommand());
    }
}

