/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.WindowManager;
import ij.gui.NewImage;
import ij.plugin.PlugIn;
import java.util.Vector;

public class MemoryTest
implements PlugIn {
    public void run(String arg) {
        boolean okay = IJ.showMessageWithCancel("Memory Test", "The MemoryTest plugin opens as many\n1024x1024x8-bit images as possible and then\ncalculates how much memory was used for each\nimage. This is a demanding test that may require\nImageJ to be restarted, may crash your browser, \nor may even crash your machine.");
        if (!okay) {
            return;
        }
        int width = 1024;
        int arraySize = 0x100000;
        int nArrays = 0;
        int nImages = 0;
        Object saveImg = null;
        IJ.write("");
        IJ.write("Opening " + width + "x" + width + " 8-bit image windows...");
        this.collectGarbage();
        int[] times = new int[2000];
        long time = System.currentTimeMillis();
        try {
            while (true) {
                NewImage.open("" + (nImages + 1), width, width, 1, 0, 0);
                long time2 = System.currentTimeMillis();
                times[nImages] = (int)(time2 - time);
                time = time2;
                ++nImages;
            }
        }
        catch (OutOfMemoryError ex) {
            IJ.write("Closing windows...");
            WindowManager.closeAllWindows();
            this.collectGarbage();
            IJ.wait(100);
            Vector<byte[]> objects = new Vector<byte[]>();
            IJ.write("Probing memory...");
            try {
                while (true) {
                    System.gc();
                    byte[] a = new byte[arraySize];
                    objects.addElement(a);
                    IJ.showStatus(++nArrays * arraySize / 0x100000 + "MB");
                    IJ.wait(50);
                }
            }
            catch (OutOfMemoryError e) {
                objects = null;
                this.collectGarbage();
                IJ.write(arraySize * nArrays / 0x100000 + "MB is available");
                IJ.write(nImages + " images were opened");
                if (nImages > 0) {
                    IJ.write("~" + arraySize * nArrays / (nImages * 1024) + "K was required for each image");
                }
                IJ.write("");
                IJ.showStatus("");
                return;
            }
        }
    }

    void collectGarbage() {
        for (int i = 0; i < 10; ++i) {
            System.gc();
        }
    }
}

