/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.util.ResourceBundle;

public class StackEditor
implements PlugIn {
    String arg;
    ImagePlus imp;
    int nSlices;
    int width;
    int height;
    static int nbStack = 0;
    static ResourceBundle bun = IJ.getPluginBundle();

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (arg.equals("tostack")) {
            this.convertImagesToStack();
            return;
        }
        if (arg.equals("add")) {
            this.addSlice();
            return;
        }
        if (this.nSlices < 2) {
            IJ.error(bun.getString("StackReqErr"));
            return;
        }
        if (arg.equals("delete")) {
            this.deleteSlice();
        } else if (arg.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        ImageProcessor ip = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        stack.addSlice(null, ip.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, stack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
    }

    void deleteSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        if (stack.getSize() == 1) {
            this.imp.setProcessor(null, stack.getProcessor(1));
            new ImageWindow(this.imp);
        } else {
            this.imp.setStack(null, stack);
            if (n-- < 1) {
                n = 1;
            }
            this.imp.setSlice(n);
        }
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error(bun.getString("NoImgErr"));
            return;
        }
        if (wList.length < 2) {
            IJ.error(bun.getString("OneImgErr"));
            return;
        }
        ImagePlus[] image = new ImagePlus[wList.length];
        ImagePlus cimg = new ImagePlus();
        int nbless = 0;
        for (int i = 0; i < wList.length; ++i) {
            cimg = WindowManager.getImage(wList[i]);
            if (cimg.getStackSize() > 1) {
                ++nbless;
                continue;
            }
            image[i - nbless] = cimg;
        }
        if (nbless == wList.length) {
            IJ.error(bun.getString("ImgErr"));
            return;
        }
        int wList_length = wList.length - nbless;
        Calibration cal2 = image[0].getCalibration();
        for (int i = 0; i < wList_length - 1; ++i) {
            if (image[i].getType() != image[i + 1].getType()) {
                IJ.error(bun.getString("ImgTypeErr"));
                return;
            }
            if (image[i].getWidth() != image[i + 1].getWidth() || image[i].getHeight() != image[i + 1].getHeight()) {
                IJ.error(bun.getString("ImgSizeErr"));
                return;
            }
            Calibration cal = image[i].getCalibration();
            if (image[i].getCalibration().equals(cal2)) continue;
            cal2 = null;
        }
        int width = image[0].getWidth();
        int height = image[0].getHeight();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        ImageStack stack = new ImageStack(width, height);
        for (int i = 0; i < wList_length; ++i) {
            ImageProcessor ip = image[i].getProcessor();
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (ip.getMax() > max) {
                max = ip.getMax();
            }
            stack.addSlice(null, ip);
            image[i].changes = false;
            image[i].getWindow().close();
        }
        ImagePlus imp = new ImagePlus(bun.getString("StackTitle") + " " + ++nbStack, stack);
        if (imp.getType() == 1 || imp.getType() == 2) {
            imp.getProcessor().setMinAndMax(min, max);
        }
        if (cal2 != null) {
            imp.setCalibration(cal2);
        }
        imp.show();
    }

    public void convertStackToImages(ImagePlus imp) {
        boolean ok;
        if (!imp.lock()) {
            return;
        }
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (size > 30 && !(ok = IJ.showMessageWithCancel(bun.getString("ConvertTitle"), bun.getString("Convert1") + " " + size + " " + bun.getString("Convert2")))) {
            imp.unlock();
            return;
        }
        Calibration cal = imp.getCalibration();
        for (int i = 1; i <= size; ++i) {
            String label = stack.getSliceLabel(i);
            String title = label != null && !label.equals("") ? label : this.getDigits(i);
            ImagePlus imp2 = new ImagePlus(title, stack.getProcessor(i));
            imp2.setCalibration(cal);
            imp2.show();
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.close();
        }
        imp.unlock();
    }

    String getDigits(int n) {
        String digits = "00000000" + n;
        return digits.substring(digits.length() - 4, digits.length());
    }
}

