/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Zip_Reader
extends ImagePlus
implements PlugIn {
    private static final String TEMP_NAME = "temp.tif";
    private int width;
    private int height;
    private boolean rawBits;
    private String tifName = "";
    private String dir = Prefs.getHomeDir() + "/";

    public void run(String arg) {
        ImagePlus imp;
        OpenDialog od = new OpenDialog("ZIP/TIFF Reader...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        IJ.showStatus(IJ.getBundle().getString("Opening") + path);
        try {
            imp = this.openZip(path);
        }
        catch (Exception e) {
            IJ.showMessage("ZIP Reader", e.getMessage());
            return;
        }
        if (imp != null) {
            this.setStack(this.tifName, imp.getStack());
            this.setCalibration(imp.getCalibration());
            if (arg.equals("")) {
                this.show();
            }
        }
    }

    public ImagePlus openZip(String path) throws IOException {
        String name = this.extractTiffFile(path);
        if (name == null) {
            return null;
        }
        this.tifName = name;
        ImagePlus imp = new Opener().openTiff(this.dir, TEMP_NAME);
        new File(this.dir + TEMP_NAME).delete();
        return imp;
    }

    String extractTiffFile(String path) throws IOException {
        int len;
        ZipInputStream in = new ZipInputStream(new FileInputStream(path));
        FileOutputStream out = new FileOutputStream(this.dir + TEMP_NAME);
        byte[] buf = new byte[1024];
        ZipEntry entry = in.getNextEntry();
        if (entry == null) {
            return null;
        }
        String name = entry.getName();
        if (!name.endsWith(".tif")) {
            throw new IOException("This ZIP archive does not appear to contain a TIFF file");
        }
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
        return name;
    }
}

