/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class AVIWriter
implements PlugInFilter {
    private ImagePlus imp;
    private RandomAccessFile raFile;
    private int bytesPerPixel;
    private File file;
    private int bufferFactor;
    private int xDim;
    private int yDim;
    private int zDim;
    private int tDim;
    private int[] lutBufferRemapped = null;
    private int microSecPerFrame;
    private int xPad;
    private byte[] bufferWrite;
    private int bufferSize;
    private int indexA;
    private int indexB;
    private float opacityPrime;
    private int bufferAdr;
    private byte[] lutWrite = null;
    private int[] dcLength = null;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        try {
            this.writeImage(this.imp);
            IJ.showStatus("");
        }
        catch (IOException e) {
            IJ.showMessage("AVI Writer", "An error occured writing the file.\n \n" + e);
        }
        IJ.showStatus("");
    }

    public void writeImage(ImagePlus imp) throws IOException {
        int z;
        boolean resXUnit = false;
        boolean resYUnit = false;
        float xResol = 0.0f;
        float yResol = 0.0f;
        long biXPelsPerMeter = 0L;
        long biYPelsPerMeter = 0L;
        this.bytesPerPixel = imp.getType() == 4 ? 3 : 1;
        this.lutBufferRemapped = new int[1];
        SaveDialog sd = new SaveDialog("Save as AVI...", imp.getTitle(), ".avi");
        String fileName = sd.getFileName();
        if (fileName == null) {
            return;
        }
        String fileDir = sd.getDirectory();
        this.file = new File(fileDir + fileName);
        this.raFile = new RandomAccessFile(this.file, "rw");
        imp.startTiming();
        this.writeString("RIFF");
        long saveFileSize = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("AVI ");
        this.writeString("LIST");
        long saveLIST1Size = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("hdrl");
        this.writeString("avih");
        this.writeInt(56);
        this.microSecPerFrame = (int)(1.0 / Animator.getFrameRate() * 1000000.0);
        this.writeInt(this.microSecPerFrame);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        this.tDim = 1;
        this.zDim = imp.getStackSize();
        this.yDim = imp.getHeight();
        this.xDim = imp.getWidth();
        this.xPad = 0;
        int xMod = this.xDim % 4;
        if (xMod != 0) {
            this.xPad = 4 - xMod;
            this.xDim += this.xPad;
        }
        this.writeInt(this.zDim * this.tDim);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(this.xDim - this.xPad);
        this.writeInt(this.yDim);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeString("LIST");
        long saveLIST1subSize = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("strl");
        this.writeString("strh");
        this.writeInt(56);
        this.writeString("vids");
        this.writeString("DIB ");
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt((int)Animator.getFrameRate());
        this.writeInt(0);
        this.writeInt(this.tDim * this.zDim);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeString("strf");
        long savestrfSize = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeInt(40);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeShort(1);
        int bitsPerPixel = this.bytesPerPixel == 3 ? 24 : 8;
        this.writeShort((short)bitsPerPixel);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        if (bitsPerPixel == 8) {
            this.writeInt(256);
        } else {
            this.writeInt(0);
        }
        this.writeInt(0);
        if (this.bytesPerPixel == 1) {
            this.createLUT();
            this.raFile.write(this.lutWrite);
        }
        long savestrnPos = this.raFile.getFilePointer();
        this.raFile.seek(savestrfSize);
        this.writeInt((int)(savestrnPos - (savestrfSize + 4L)));
        this.raFile.seek(savestrnPos);
        this.writeString("strn");
        this.writeInt(16);
        this.writeString("FileAVI write  ");
        this.raFile.write(0);
        long saveJUNKsignature = this.raFile.getFilePointer();
        this.raFile.seek(saveLIST1Size);
        this.writeInt((int)(saveJUNKsignature - (saveLIST1Size + 4L)));
        this.raFile.seek(saveLIST1subSize);
        this.writeInt((int)(saveJUNKsignature - (saveLIST1subSize + 4L)));
        this.raFile.seek(saveJUNKsignature);
        this.writeString("JUNK");
        int paddingBytes = (int)(4084L - (saveJUNKsignature + 8L));
        this.writeInt(paddingBytes);
        for (int i = 0; i < paddingBytes / 2; ++i) {
            this.writeShort(0);
        }
        this.writeString("LIST");
        long saveLIST2Size = this.raFile.getFilePointer();
        this.writeInt(0);
        long savemovi = this.raFile.getFilePointer();
        this.writeString("movi");
        long[] savedbLength = new long[this.tDim * this.zDim];
        long[] savedcLength = new long[this.tDim * this.zDim];
        this.dcLength = new int[this.tDim * this.zDim];
        byte[] dataSignature = new byte[]{48, 48, 100, 98};
        this.bufferWrite = new byte[this.bytesPerPixel * this.xDim * this.yDim];
        for (z = 0; z < this.zDim; ++z) {
            IJ.showProgress((double)z / (double)this.zDim);
            this.raFile.write(dataSignature);
            savedbLength[z] = this.raFile.getFilePointer();
            this.writeInt(this.bytesPerPixel * this.xDim * this.yDim);
            if (this.bytesPerPixel == 1) {
                this.writeByteFrame(z + 1);
                continue;
            }
            this.writeRGBFrame(z + 1);
        }
        long idx1Pos = this.raFile.getFilePointer();
        this.raFile.seek(saveLIST2Size);
        this.writeInt((int)(idx1Pos - (saveLIST2Size + 4L)));
        this.raFile.seek(idx1Pos);
        this.writeString("idx1");
        long saveidx1Length = this.raFile.getFilePointer();
        this.writeInt(0);
        for (z = 0; z < this.zDim; ++z) {
            this.raFile.write(dataSignature);
            if (z == 0) {
                this.writeInt(16);
            } else {
                this.writeInt(0);
            }
            this.writeInt((int)(savedbLength[z] - 4L - savemovi));
            this.writeInt(this.bytesPerPixel * this.xDim * this.yDim);
        }
        long endPos = this.raFile.getFilePointer();
        this.raFile.seek(saveFileSize);
        this.writeInt((int)(endPos - (saveFileSize + 4L)));
        this.raFile.seek(saveidx1Length);
        this.writeInt((int)(endPos - (saveidx1Length + 4L)));
        this.raFile.close();
        IJ.showProgress(1.0);
    }

    public void writeByteFrame(int slice) throws IOException {
        ImageProcessor ip = this.imp.getStack().getProcessor(slice);
        ip = ip.convertToByte(true);
        byte[] pixels = (byte[])ip.getPixels();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int index = 0;
        for (int y = height - 1; y >= 0; --y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                this.bufferWrite[index++] = pixels[offset++];
            }
            for (int i = 0; i < this.xPad; ++i) {
                this.bufferWrite[index++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    public void writeRGBFrame(int slice) throws IOException {
        ImageProcessor ip = this.imp.getStack().getProcessor(slice);
        ip = ip.convertToRGB();
        int[] pixels = (int[])ip.getPixels();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int index = 0;
        for (int y = height - 1; y >= 0; --y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int c = pixels[offset++];
                this.bufferWrite[index++] = (byte)(c & 0xFF);
                this.bufferWrite[index++] = (byte)((c & 0xFF00) >> 8);
                this.bufferWrite[index++] = (byte)((c & 0xFF0000) >> 16);
            }
            for (int i = 0; i < this.xPad; ++i) {
                this.bufferWrite[index++] = 0;
                this.bufferWrite[index++] = 0;
                this.bufferWrite[index++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    public void createLUT() {
        LookUpTable lut = this.imp.createLut();
        IndexColorModel cm = (IndexColorModel)lut.getColorModel();
        int mapSize = cm.getMapSize();
        this.lutWrite = new byte[1024];
        for (int i = 0; i < 256; ++i) {
            if (i >= mapSize) continue;
            this.lutWrite[4 * i] = (byte)cm.getBlue(i);
            this.lutWrite[4 * i + 1] = (byte)cm.getGreen(i);
            this.lutWrite[4 * i + 2] = (byte)cm.getRed(i);
            this.lutWrite[4 * i + 3] = 0;
        }
    }

    final void writeString(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF8");
        this.raFile.write(bytes);
    }

    final void writeInt(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
        this.raFile.write(v >>> 16 & 0xFF);
        this.raFile.write(v >>> 24 & 0xFF);
    }

    final void writeShort(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
    }
}

