/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class Binary
implements PlugInFilter {
    String arg;
    ImagePlus imp;
    static int iterations = 1;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(Binary.class);
        if (arg.equals("set")) {
            this.setIterations();
            return 4096;
        }
        if (arg.equals("outline") || arg.equals("skel")) {
            if (imp != null && (imp.getType() == 0 || imp.getType() == 3)) {
                ImageStatistics stats = imp.getStatistics();
                if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                    IJ.error("8-bit binary (black and white only) image required.");
                    return 4096;
                }
            }
            return IJ.setupDialog(imp, 67);
        }
        return IJ.setupDialog(imp, 83);
    }

    public void run(ImageProcessor ip) {
        if (this.arg.equals("erode")) {
            this.erode(ip);
        } else if (this.arg.equals("dilate")) {
            this.dilate(ip);
        } else if (this.arg.equals("open")) {
            this.open(ip);
        } else if (this.arg.equals("close")) {
            this.close(ip);
        } else if (this.arg.equals("outline")) {
            ((ByteProcessor)ip).outline();
        } else if (this.arg.equals("skel")) {
            ((ByteProcessor)ip).skeletonize();
        }
    }

    void erode(ImageProcessor ip) {
        for (int i = 0; i < iterations; ++i) {
            ip.erode();
            if (iterations <= 1) continue;
            this.imp.updateAndDraw();
        }
    }

    void dilate(ImageProcessor ip) {
        for (int i = 0; i < iterations; ++i) {
            ip.dilate();
            if (iterations <= 1) continue;
            this.imp.updateAndDraw();
        }
    }

    void open(ImageProcessor ip) {
        int i;
        for (i = 0; i < iterations; ++i) {
            ip.erode();
            if (iterations <= 1) continue;
            this.imp.updateAndDraw();
        }
        for (i = 0; i < iterations; ++i) {
            ip.dilate();
            if (iterations <= 1) continue;
            this.imp.updateAndDraw();
        }
    }

    void close(ImageProcessor ip) {
        int i;
        for (i = 0; i < iterations; ++i) {
            ip.dilate();
            if (iterations <= 1) continue;
            this.imp.updateAndDraw();
        }
        for (i = 0; i < iterations; ++i) {
            ip.erode();
            if (iterations <= 1) continue;
            this.imp.updateAndDraw();
        }
    }

    void setIterations() {
        int n = (int)IJ.getNumber("Iterations (1-25):", iterations);
        if (n == Integer.MIN_VALUE) {
            return;
        }
        if (n > 25) {
            n = 25;
        }
        if (n < 1) {
            n = 1;
        }
        iterations = n;
    }
}

