/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.util.StringTokenizer;

public class Calibrator
implements PlugInFilter,
Measurements {
    private static String NONE = "None";
    private static String INVERTER = "CalPixelInverter";
    private static boolean showSettings;
    static boolean global;
    private static boolean oldGlobal;
    private ImagePlus imp;
    private int choiceIndex;
    private String[] functions;
    private int nFits = CurveFitter.fitList.length;
    private int spacerIndex = this.nFits + 1;
    private int inverterIndex = this.nFits + 2;
    private String xText;
    private static String yText;
    private String unit;
    private double lx = 0.02;
    private double ly = 0.1;
    private int oldFunction;
    private String sumResiduals;
    private String fitGoodness;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(Calibrator.class);
        return 135;
    }

    public void run(ImageProcessor ip) {
        oldGlobal = global;
        if (!this.showDialog(this.imp)) {
            return;
        }
        this.calibrate(this.imp);
        if (global || global != oldGlobal) {
            int[] list = WindowManager.getIDList();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                ImagePlus imp2 = WindowManager.getImage(list[i]);
                if (imp2 == null) continue;
                imp2.getWindow().repaint();
            }
        } else {
            this.imp.getWindow().repaint();
        }
    }

    public boolean showDialog(ImagePlus imp) {
        int function;
        Calibration cal = imp.getCalibration();
        this.functions = this.getFunctionList();
        this.oldFunction = function = cal.getFunction();
        double[] p = cal.getCoefficients();
        this.unit = cal.getValueUnit();
        String defaultChoice = function == 20 ? NONE : (function < this.nFits && function == 0 && p != null && p[0] == 255.0 && p[1] == -1.0 ? INVERTER : (function < this.nFits ? CurveFitter.fitList[function] : NONE));
        this.xText = this.getMeans();
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("CalibrTitle"));
        gd.addChoice(IJ.getPluginBundle().getString("CalibrFunc"), this.functions, defaultChoice);
        gd.addStringField(IJ.getPluginBundle().getString("Unit") + ":", this.unit, 16);
        gd.addTextAreas(this.xText, yText, 20, 14);
        gd.addCheckbox(IJ.getPluginBundle().getString("CalibrGlob"), global);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.choiceIndex = gd.getNextChoiceIndex();
        this.unit = gd.getNextString();
        this.xText = gd.getNextText();
        yText = gd.getNextText();
        global = gd.getNextBoolean();
        return true;
    }

    public void calibrate(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        int function = 20;
        boolean is16Bits = imp.getType() == 1;
        double[] parameters = null;
        double[] x = null;
        double[] y = null;
        boolean zeroClip = false;
        if (this.choiceIndex <= 0) {
            if (this.oldFunction == 20 && !yText.equals("") && !this.xText.equals("")) {
                IJ.showMessage(IJ.getPluginBundle().getString("Calibrator"), IJ.getPluginBundle().getString("CalibrErr1"));
            }
            function = 20;
        } else if (this.choiceIndex <= this.nFits) {
            function = this.choiceIndex - 1;
            if (function > 0 && is16Bits) {
                IJ.error(IJ.getPluginBundle().getString("CalibrErr16b"));
                return;
            }
            x = this.getData(this.xText);
            y = this.getData(yText);
            if (!(cal.calibrated() && y.length == 0 && function == this.oldFunction || (parameters = this.doCurveFitting(x, y, function)) != null)) {
                return;
            }
            zeroClip = true;
            for (int i = 0; i < y.length; ++i) {
                if (!(y[i] < 0.0)) continue;
                zeroClip = false;
            }
        } else if (this.choiceIndex == this.inverterIndex) {
            function = 0;
            parameters = new double[]{is16Bits ? 65535.0 : 255.0, -1.0};
        }
        cal.setFunction(function, parameters, this.unit, zeroClip);
        if (global) {
            imp.setGlobalCalibration(cal);
        } else {
            imp.setCalibration(cal);
            imp.setGlobalCalibration(null);
        }
        if (function != 20) {
            this.showPlot(x, y, cal, this.sumResiduals, this.fitGoodness);
        }
    }

    double[] doCurveFitting(double[] x, double[] y, int fitType) {
        if (x.length != y.length || y.length == 0) {
            IJ.showMessage(IJ.getPluginBundle().getString("Calibrator"), IJ.getPluginBundle().getString("CalibrMan") + IJ.getPluginBundle().getString("LeftCol") + ": " + x.length + IJ.getPluginBundle().getString("Values") + "\n" + IJ.getPluginBundle().getString("RightCol") + ": " + x.length + IJ.getPluginBundle().getString("Values") + "\n");
            return null;
        }
        int n = x.length;
        double xmin = 0.0;
        double xmax = this.imp.getType() == 1 ? 65535.0 : 255.0;
        double[] a = Tools.getMinMax(y);
        double ymin = a[0];
        double ymax = a[1];
        CurveFitter cf = new CurveFitter(x, y);
        cf.doFit(fitType, showSettings);
        int np = cf.getNumParams();
        double[] p = cf.getParams();
        double sumResidualsSqr = p[np];
        double sumY = 0.0;
        for (int i = 0; i < n; ++i) {
            sumY += y[i];
        }
        this.sumResiduals = IJ.d2s(Math.sqrt(sumResidualsSqr / (double)n), 6);
        double mean = sumY / (double)n;
        double sumMeanDiffSqr = 0.0;
        int degreesOfFreedom = n - np;
        double goodness = 1.0;
        for (int i = 0; i < n; ++i) {
            if (!((sumMeanDiffSqr += this.sqr(y[i] - mean)) > 0.0) || degreesOfFreedom == 0) continue;
            goodness = 1.0 - sumResidualsSqr / (double)degreesOfFreedom * ((double)(n - 1) / sumMeanDiffSqr);
        }
        this.fitGoodness = IJ.d2s(goodness, 6);
        double[] parameters = new double[np];
        for (int i = 0; i < np; ++i) {
            parameters[i] = p[i];
        }
        return parameters;
    }

    void showPlot(double[] x, double[] y, Calibration cal, String sumResiduals, String fitGoodness) {
        int i;
        int xmax;
        boolean xmin;
        if (!cal.calibrated()) {
            return;
        }
        float[] ctable = cal.getCTable();
        if (ctable.length == 256) {
            xmin = false;
            xmax = 255;
        } else {
            xmin = false;
            xmax = 65535;
        }
        int range = 256;
        float[] px = new float[range];
        float[] py = new float[range];
        for (i = 0; i < range; ++i) {
            px[i] = (float)((double)i / 255.0 * (double)xmax);
        }
        for (i = 0; i < range; ++i) {
            py[i] = ctable[(int)px[i]];
        }
        double[] a = Tools.getMinMax(py);
        double ymin = a[0];
        double ymax = a[1];
        int fit = cal.getFunction();
        String unit = cal.getValueUnit();
        PlotWindow pw = new PlotWindow(IJ.getPluginBundle().getString("CalibrFuncTitle"), IJ.getBundle().getString("CalGrayVal"), unit, px, py);
        pw.setLimits((double)xmin, xmax, ymin, ymax);
        if (x != null && y != null && x.length > 0 && y.length > 0) {
            pw.addPoints(x, y, 0);
        }
        double[] p = cal.getCoefficients();
        if (fit <= 8) {
            this.drawLabel(pw, CurveFitter.fList[fit]);
            this.ly += 0.04;
        }
        if (p != null) {
            int np = p.length;
            this.drawLabel(pw, "a=" + IJ.d2s(p[0], 6));
            this.drawLabel(pw, "b=" + IJ.d2s(p[1], 6));
            if (np >= 3) {
                this.drawLabel(pw, "c=" + IJ.d2s(p[2], 6));
            }
            if (np >= 4) {
                this.drawLabel(pw, "d=" + IJ.d2s(p[3], 6));
            }
            if (np >= 5) {
                this.drawLabel(pw, "e=" + IJ.d2s(p[4], 6));
            }
            this.ly += 0.04;
        }
        if (sumResiduals != null) {
            this.drawLabel(pw, "S.D.=" + sumResiduals);
            sumResiduals = null;
        }
        if (fitGoodness != null) {
            this.drawLabel(pw, "R^2=" + fitGoodness);
            fitGoodness = null;
        }
        pw.draw();
    }

    void drawLabel(PlotWindow pw, String label) {
        pw.addLabel(this.lx, this.ly, label);
        this.ly += 0.08;
    }

    double sqr(double x) {
        return x * x;
    }

    String[] getFunctionList() {
        String[] list = new String[this.nFits + 3];
        list[0] = NONE;
        for (int i = 0; i < this.nFits; ++i) {
            list[1 + i] = CurveFitter.fitList[i];
        }
        list[this.spacerIndex] = "-";
        list[this.inverterIndex] = INVERTER;
        return list;
    }

    String getMeans() {
        float[] umeans = Analyzer.getUMeans();
        int count = Analyzer.getCounter();
        if (umeans == null || count == 0) {
            return "";
        }
        if (count > 20) {
            count = 20;
        }
        String s = "";
        for (int i = 0; i < count; ++i) {
            s = s + IJ.d2s(umeans[i], 2) + "\n";
        }
        return s;
    }

    double[] getData(String xData) {
        StringTokenizer st = new StringTokenizer(xData);
        int nTokens = st.countTokens();
        if (nTokens < 1) {
            return new double[0];
        }
        int n = nTokens;
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.getNum(st);
        }
        return data;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    static {
        yText = "";
        NONE = IJ.getPluginBundle().getString(NONE);
        INVERTER = IJ.getPluginBundle().getString(INVERTER);
    }
}

