/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ResourceBundle;

public class ImageMath
implements PlugInFilter {
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private boolean first;
    private static double addValue = 25.0;
    private static double mulValue = 1.25;
    private static double minValue = 0.0;
    private static double maxValue = 255.0;
    private static final String defaultAndValue = "11110000";
    private static String andValue = "11110000";
    private static final double defaultGammaValue = 0.5;
    private static double gammaValue = 0.5;
    private static ResourceBundle etiq;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        this.first = true;
        etiq = IJ.getPluginBundle();
        IJ.register(ImageMath.class);
        return IJ.setupDialog(imp, 95);
    }

    public void run(ImageProcessor ip) {
        double[] dt = null;
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            if (this.first) {
                addValue = this.getValue(etiq.getString("Add"), etiq.getString("Value") + " ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.add(addValue);
            return;
        }
        if (this.arg.equals("sub")) {
            if (this.first) {
                addValue = this.getValue(etiq.getString("Subtract"), etiq.getString("Value") + " ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.add(-addValue);
            return;
        }
        if (this.arg.equals("mul")) {
            if (this.first) {
                mulValue = this.getValue(etiq.getString("Multiply"), etiq.getString("Value") + " ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            ip.multiply(mulValue);
            float[] ct = ip.getCalibrationTable();
            Calibration ocal = this.imp.getCalibration();
            Calibration cal = ocal != null ? ocal.copy() : new Calibration(this.imp);
            if (ct != null && cal.getFunction() == 0) {
                dt = cal.getCoefficients();
                dt[0] = dt[0] * mulValue;
                dt[1] = dt[1] * mulValue;
                cal.setFunction(0, dt, cal.getUnit());
                this.imp.setCalibration(cal);
            }
            return;
        }
        if (this.arg.equals("div")) {
            if (this.first) {
                mulValue = this.getValue(etiq.getString("Divide"), etiq.getString("Value") + " ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (mulValue != 0.0) {
                ip.multiply(1.0 / mulValue);
            }
            return;
        }
        if (this.arg.equals("and")) {
            if (this.first) {
                andValue = this.getBinaryValue(etiq.getString("AND"), etiq.getString("BinValue") + " ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.and(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error(etiq.getString("BinValReqErr"));
            }
            return;
        }
        if (this.arg.equals("or")) {
            if (this.first) {
                andValue = this.getBinaryValue(etiq.getString("OR"), etiq.getString("BinValue") + " ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.or(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error(etiq.getString("BinValReqErr"));
            }
            return;
        }
        if (this.arg.equals("xor")) {
            if (this.first) {
                andValue = this.getBinaryValue(etiq.getString("XOR"), etiq.getString("BinValue") + " ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.xor(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error(etiq.getString("BinValReqErr"));
            }
            return;
        }
        if (this.arg.equals("min")) {
            if (this.first) {
                minValue = this.getValue(etiq.getString("Min"), etiq.getString("Value") + " ", minValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.min(minValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("max")) {
            if (this.first) {
                maxValue = this.getValue(etiq.getString("Max"), etiq.getString("Value") + " ", maxValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.max(maxValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("gamma")) {
            if (this.first) {
                gammaValue = this.getValue(etiq.getString("Gamma"), etiq.getString("Value01") + " ", gammaValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (gammaValue < 0.1 || gammaValue > 5.0) {
                IJ.error(etiq.getString("GammaValErr"));
                gammaValue = 0.5;
                return;
            }
            ip.gamma(gammaValue);
            return;
        }
        if (this.arg.equals("log")) {
            ip.log();
            return;
        }
        if (this.arg.equals("sqr")) {
            ip.sqr();
            float[] ct = ip.getCalibrationTable();
            Calibration ocal = this.imp.getCalibration();
            Calibration cal = ocal != null ? ocal.copy() : new Calibration(this.imp);
            if (ct != null && cal.getFunction() == 0) {
                dt = cal.getCoefficients();
                dt[0] = dt[0] * mulValue;
                dt[1] = dt[1] * mulValue;
                cal.setFunction(0, dt, cal.getUnit());
                this.imp.setCalibration(cal);
            }
            return;
        }
        if (this.arg.equals("sqrt")) {
            ip.sqrt();
            float[] ct = ip.getCalibrationTable();
            if (ct != null) {
                dt = new double[ct.length];
                for (int i = 0; i < ct.length; ++i) {
                    dt[i] = ct[i];
                }
            }
            ct = ip.getCalibrationTable();
            Calibration ocal = this.imp.getCalibration();
            Calibration cal = ocal != null ? ocal.copy() : new Calibration(this.imp);
            if (ct != null && cal.getFunction() == 0) {
                dt = cal.getCoefficients();
                dt[0] = dt[0] * mulValue;
                dt[1] = dt[1] * mulValue;
                cal.setFunction(0, dt, cal.getUnit());
                this.imp.setCalibration(cal);
            }
            return;
        }
        if (this.arg.equals("reciprocal")) {
            if (!(ip instanceof FloatProcessor)) {
                IJ.error(etiq.getString("32birReqErr"));
                this.canceled = true;
                return;
            }
            float[] pixels = (float[])ip.getPixels();
            for (int i = 0; i < ip.getWidth() * ip.getHeight(); ++i) {
                pixels[i] = pixels[i] == 0.0f ? Float.NaN : 1.0f / pixels[i];
            }
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
            return;
        }
    }

    double getValue(String title, String prompt, double defaultValue, int digits) {
        GenericDialog gd = new GenericDialog(title);
        gd.addNumericField(prompt, defaultValue, digits);
        gd.showDialog();
        if (this.first) {
            this.imp.startTiming();
        }
        this.first = false;
        this.canceled = gd.wasCanceled();
        if (this.canceled) {
            return defaultValue;
        }
        return gd.getNextNumber();
    }

    String getBinaryValue(String title, String prompt, String defaultValue) {
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField(prompt, defaultValue);
        gd.showDialog();
        if (this.first) {
            this.imp.startTiming();
        }
        this.first = false;
        this.canceled = gd.wasCanceled();
        if (this.canceled) {
            return defaultValue;
        }
        return gd.getNextString();
    }
}

