/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.ImageCanvas;
import ij.measure.Calibration;
import ij.plugin.filter.LutWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class LutViewer
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 399;
    }

    public void run(ImageProcessor ip) {
        ImagePlus LUTview = LutViewer.prepare(ip, this.imp.createLut(), this.imp.getCalibration());
        new LutWindow(LUTview, new ImageCanvas(LUTview));
    }

    static ImagePlus prepare(ImageProcessor ip, LookUpTable lut, Calibration cal) {
        int xMargin = 35;
        int yMargin = 20;
        int width = 128;
        int barHeight = 512;
        int mapSize = lut.getMapSize();
        if (mapSize == 0) {
            return null;
        }
        int imageWidth = width + 2 * xMargin;
        int imageHeight = 2 * yMargin + barHeight + 2;
        Image img = IJ.getInstance().createImage(imageWidth, imageHeight);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, imageWidth, imageHeight);
        g.setColor(Color.black);
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        double scale = 256.0 / (double)mapSize;
        double st = barHeight / mapSize;
        boolean isGray = lut.isGrayscale();
        if (isGray) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.red);
        }
        int x = xMargin + 2;
        int y = yMargin;
        double min = ip.getMin();
        double max = ip.getMax();
        if (cal != null) {
            min = cal.getCValue(min);
            max = cal.getCValue(max);
        }
        lut.drawVertColorBar(g, x, y, width, barHeight, min, max);
        return new ImagePlus(IJ.getPluginBundle().getString("LUTTitle"), img);
    }
}

