/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.filter.LutViewer;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.IndexColorModel;

class LutWindow
extends ImageWindow
implements ActionListener {
    private Button buttonList;
    private Button buttonUpdate;
    private ImagePlus oi;

    LutWindow(ImagePlus imp, ImageCanvas ic) {
        super(imp, ic, false);
        this.oi = imp;
        this.addPanel();
    }

    void addPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.buttonList = new Button(IJ.getPluginBundle().getString("List"));
        this.buttonUpdate = new Button(IJ.getPluginBundle().getString("Update"));
        this.buttonList.addActionListener(this);
        this.buttonUpdate.addActionListener(this);
        panel.add(this.buttonList);
        panel.add(this.buttonUpdate);
        this.add(panel);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.buttonList) {
            this.list(WindowManager.getCurrentImage().getProcessor());
        } else if (b == this.buttonUpdate) {
            ImagePlus imp = WindowManager.getCurrentImage();
            ImagePlus ipp = LutViewer.prepare(imp.getProcessor(), imp.createLut(), imp.getCalibration());
            this.oi.setImage(ipp.getImage());
            this.oi.updateAndDraw();
        }
    }

    void list(ImageProcessor ip) {
        IndexColorModel icm = (IndexColorModel)ip.getColorModel();
        int size = icm.getMapSize();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        icm.getReds(r);
        icm.getGreens(g);
        icm.getBlues(b);
        StringBuffer sb = new StringBuffer();
        String headings = IJ.getPluginBundle().getString("LUTHead");
        for (int i = 0; i < size; ++i) {
            sb.append(i + "\t" + (r[i] & 0xFF) + "\t" + (g[i] & 0xFF) + "\t" + (b[i] & 0xFF) + "\n");
        }
        TextWindow tw = new TextWindow(IJ.getPluginBundle().getString("LUTTextTitle"), headings, sb.toString(), 250, 400);
    }
}

