/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;

public class Resizer
implements PlugInFilter {
    ImagePlus imp;
    private boolean crop;
    private static int newWidth = 100;
    private static int newHeight = 100;
    private static boolean constrain = true;
    private static boolean interpolate = true;

    public int setup(String arg, ImagePlus imp) {
        this.crop = arg.equals("crop");
        this.imp = imp;
        IJ.register(Resizer.class);
        if (this.crop) {
            return 1183;
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() >= 5 && roi.getType() <= 7) {
            IJ.error(IJ.getPluginBundle().getString(""));
            return;
        }
        boolean sizeToHeight = false;
        if (this.crop) {
            Rectangle bounds = roi.getBoundingRect();
            newWidth = bounds.width;
            newHeight = bounds.height;
            interpolate = false;
        } else {
            GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("ResizeTitle"), IJ.getInstance());
            gd.addNumericField(IJ.getPluginBundle().getString("Width") + " (" + IJ.getPluginBundle().getString("Pixels") + "):", newWidth, 0);
            gd.addNumericField(IJ.getPluginBundle().getString("Height") + " (" + IJ.getPluginBundle().getString("Pixels") + "):", newHeight, 0);
            gd.addCheckbox(IJ.getPluginBundle().getString("ResizeConstrain"), constrain);
            gd.addCheckbox(IJ.getPluginBundle().getString("Interpolate"), interpolate);
            gd.addMessage(IJ.getPluginBundle().getString("ResizeWarn"));
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            newWidth = (int)gd.getNextNumber();
            newHeight = (int)gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error(IJ.getPluginBundle().getString("ResizeErr"));
                return;
            }
            constrain = gd.getNextBoolean();
            interpolate = gd.getNextBoolean();
            boolean bl = sizeToHeight = constrain && newWidth == 0;
            if ((double)newWidth <= 0.0 && !constrain) {
                newWidth = 50;
            }
            if ((double)newHeight <= 0.0) {
                newHeight = 50;
            }
        }
        Rectangle r = ip.getRoi();
        double oldWidth = r.width;
        double oldHeight = r.height;
        if (!this.crop && constrain) {
            if (sizeToHeight) {
                newWidth = (int)((double)newHeight * (oldWidth / oldHeight));
            } else {
                newHeight = (int)((double)newWidth * (oldHeight / oldWidth));
            }
        }
        ip.setInterpolate(interpolate);
        int nSlices = this.imp.getStackSize();
        try {
            StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
            ImageStack s2 = sp.resize(newWidth, newHeight);
            int newSize = s2.getSize();
            if (s2.getWidth() > 0 && newSize > 0) {
                boolean restoreRoi;
                boolean bl = restoreRoi = this.crop && roi != null && roi.getType() != 0;
                if (restoreRoi) {
                    this.imp.killRoi();
                }
                this.imp.hide();
                Calibration cal = this.imp.getCalibration();
                if (cal.scaled()) {
                    cal.pixelWidth *= oldWidth / (double)newWidth;
                    cal.pixelHeight *= oldHeight / (double)newHeight;
                    this.imp.setCalibration(cal);
                }
                this.imp.setStack(null, s2);
                this.imp.show();
                if (restoreRoi) {
                    this.imp.restoreRoi();
                }
            }
            if (nSlices > 1 && newSize < nSlices) {
                IJ.error(IJ.getPluginBundle().getString("ResizeLost1") + " " + (nSlices - newSize) + " " + IJ.getPluginBundle().getString("ResizeLost2"));
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory(IJ.getPluginBundle().getString("ResizeTitle"));
        }
    }
}

