/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Calibrator;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.SetScaleDialog;
import ij.process.ImageProcessor;

public class ScaleDialog
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(ScaleDialog.class);
        return 159;
    }

    public void run(ImageProcessor ip) {
        Roi roi;
        double measured = 0.0;
        double known = 1.0;
        double aspectRatio = 1.0;
        String unit = "cm";
        boolean oldGlobal = Calibrator.global;
        Calibration cal = this.imp.getCalibration();
        boolean isCalibrated = cal.scaled();
        String scale = IJ.getPluginBundle().getString("ScDiagNoScale");
        int digits = 2;
        if (isCalibrated) {
            measured = 1.0 / cal.pixelWidth;
            if ((double)((int)measured) == measured) {
                digits = 0;
            }
            if (measured < 0.01) {
                digits = 3;
            } else if (measured < 0.001) {
                digits = 4;
            }
            known = 1.0;
            aspectRatio = cal.pixelHeight / cal.pixelWidth;
            unit = cal.getUnit();
            scale = IJ.d2s(measured, digits) + " " + IJ.getPluginBundle().getString("Pixels") + "/" + unit;
        }
        if ((roi = this.imp.getRoi()) != null && roi instanceof Line) {
            measured = ((Line)roi).getRawLength();
            known = 0.0;
        }
        SetScaleDialog gd = new SetScaleDialog(IJ.getPluginBundle().getString("ScDiagTitle"), scale);
        gd.addNumericField(IJ.getPluginBundle().getString("ScDiagDistPix"), measured, digits);
        gd.addNumericField(IJ.getPluginBundle().getString("ScDiagDist"), known, 2);
        gd.addNumericField(IJ.getPluginBundle().getString("ScDiagRatio"), aspectRatio, 1);
        gd.addStringField(IJ.getPluginBundle().getString("ScDiagUnit"), unit);
        gd.addMessage(IJ.getPluginBundle().getString("ScDiagScale"));
        gd.addCheckbox(IJ.getPluginBundle().getString("ScDiagGlobal"), Calibrator.global);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        measured = gd.getNextNumber();
        known = gd.getNextNumber();
        aspectRatio = gd.getNextNumber();
        unit = gd.getNextString();
        if (unit.equals("um")) {
            unit = "\u00b5m";
        } else if (unit.equals("A")) {
            unit = "\u00c5";
        }
        Calibrator.global = gd.getNextBoolean();
        if (measured != 0.0 && known == 0.0) {
            this.imp.setGlobalCalibration(Calibrator.global ? cal : null);
            return;
        }
        String u2 = new String(unit).toLowerCase();
        if (measured <= 0.0 || u2.startsWith(IJ.getPluginBundle().getString("Pixel")) || unit.equals("")) {
            cal.pixelWidth = 1.0;
            cal.pixelHeight = 1.0;
            cal.setUnit(IJ.getPluginBundle().getString("Pixel"));
        } else {
            cal.pixelWidth = known / measured;
            cal.pixelHeight = aspectRatio != 0.0 ? cal.pixelWidth * aspectRatio : cal.pixelWidth;
            cal.setUnit(unit);
        }
        if (oldGlobal && !Calibrator.global) {
            this.imp.setGlobalCalibration(null);
        } else {
            this.imp.setCalibration(cal);
            this.imp.setGlobalCalibration(Calibrator.global ? cal : null);
        }
        if (Calibrator.global || Calibrator.global != oldGlobal) {
            int[] list = WindowManager.getIDList();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                ImagePlus imp2 = WindowManager.getImage(list[i]);
                if (imp2 == null) continue;
                imp2.getWindow().repaint();
            }
        } else {
            this.imp.getWindow().repaint();
        }
    }
}

