/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;

public class Scaler
implements PlugInFilter {
    private ImagePlus imp;
    private static double xscale = 0.5;
    private static double yscale = 0.5;
    private static boolean newWindow = true;
    private static boolean interpolate = true;

    public int setup(String arg, ImagePlus imp) {
        Roi roi;
        this.imp = imp;
        IJ.register(Scaler.class);
        if (imp != null && (roi = imp.getRoi()) != null && roi.getType() > 4) {
            imp.killRoi();
        }
        return 31;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("ScalerTitle"), IJ.getInstance());
        gd.addNumericField(IJ.getPluginBundle().getString("ScalerX") + "(0.05-25)", xscale, 2);
        gd.addNumericField(IJ.getPluginBundle().getString("ScalerY") + "(0.05-25)", yscale, 2);
        gd.addCheckbox(IJ.getPluginBundle().getString("NewWin"), newWindow);
        gd.addCheckbox(IJ.getPluginBundle().getString("Interpolate"), interpolate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        xscale = gd.getNextNumber();
        yscale = gd.getNextNumber();
        if (gd.invalidNumber()) {
            IJ.error(IJ.getPluginBundle().getString("ScalerErr"));
            return;
        }
        if (xscale > 25.0) {
            xscale = 25.0;
        }
        if (xscale < 0.05) {
            xscale = 0.05;
        }
        if (yscale > 25.0) {
            yscale = 25.0;
        }
        if (yscale < 0.05) {
            yscale = 0.05;
        }
        newWindow = gd.getNextBoolean();
        interpolate = gd.getNextBoolean();
        ip.setInterpolate(interpolate);
        this.imp.startTiming();
        try {
            if (newWindow) {
                Rectangle r = ip.getRoi();
                int newWidth = (int)(xscale * (double)r.width);
                int newHeight = (int)(yscale * (double)r.height);
                ImagePlus imp2 = this.imp.createImagePlus();
                imp2.setProcessor(this.imp.getTitle() + IJ.getPluginBundle().getString("ScalerSuffix"), ip.resize(newWidth, newHeight));
                Calibration cal = imp2.getCalibration();
                if (cal.scaled()) {
                    cal.pixelWidth *= 1.0 / xscale;
                    cal.pixelHeight *= 1.0 / yscale;
                }
                imp2.show();
                this.imp.trimProcessor();
                imp2.trimProcessor();
            } else {
                int flags = IJ.setupDialog(this.imp, 0);
                if (flags == 4096) {
                    return;
                }
                if ((flags & 0x20) != 0 && this.imp.getStackSize() > 1) {
                    Undo.reset();
                    StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
                    sp.scale(xscale, yscale);
                } else {
                    ip.scale(xscale, yscale);
                }
                this.imp.killRoi();
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory(IJ.getPluginBundle().getString("ScalerTitle"));
        }
    }
}

