/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Translator
implements PlugInFilter {
    private static double tx = 0.0;
    private static double ty = 0.0;
    private static boolean interpolate = true;
    private static boolean firstTime;
    private static boolean canceled;
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(Translator.class);
        firstTime = true;
        canceled = false;
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (canceled) {
            return;
        }
        if (firstTime) {
            GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("Translate"), IJ.getInstance());
            gd.addNumericField(IJ.getPluginBundle().getString("TX") + ":", tx, 1);
            gd.addNumericField(IJ.getPluginBundle().getString("TY") + ":", ty, 1);
            gd.addCheckbox(IJ.getPluginBundle().getString("Interpolate"), interpolate);
            gd.showDialog();
            canceled = gd.wasCanceled();
            if (canceled) {
                return;
            }
            tx = gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error(IJ.getPluginBundle().getString("TxErr"));
                return;
            }
            ty = gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error(IJ.getPluginBundle().getString("TyErr"));
                return;
            }
            interpolate = gd.getNextBoolean();
            this.imp.startTiming();
            firstTime = false;
        }
        ip.setInterpolate(interpolate);
        ip.translate(tx, ty);
    }
}

