/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Font;
import java.awt.Graphics;

public class Waves
implements PlugInFilter {
    String arg;
    double amplitude = 5.0;
    double frequency = 25.0;
    int[] waveTable;
    ImagePlus imp;
    ImageWindow win;
    ImageCanvas ic;
    byte[] pixels;
    byte[] pixels2;
    int[] rgbPixels;
    int[] rgbPixels2;
    int width;
    int height;
    int index;
    int increment;
    long fps;
    long startTime;
    long elapsedTime;
    Graphics g;
    int frames;
    Roi roi;

    void showAbout() {
        IJ.showMessage("About Waves...", "\"Waves.java\" is a sample plugin filter that illustrates\nhow to continuously animate both 8-bit and RGB images until\nthe user clicks on the image or presses escape.");
    }

    void showRates() {
        TextWindow tw = new TextWindow("waves Benchmark", "", 450, 500);
        tw.setFont(new Font("Monospaced", 0, 12));
        tw.append("\"Waves\" frame rates using the 512x512 Mandrill image");
        tw.append("on a P2/400 running Windows 95 with 16-bit graphics.");
        tw.append("");
        tw.append("              JDK 1.1.7  JDK 1.2   JDK 1.3");
        tw.append("              ---------  -------   -----");
        tw.append("RGB              19.4     11.7      8.0");
        tw.append("RGB(1)           20.1      5.1");
        tw.append("RGB(2)           18.8      9.1");
        tw.append("RGB-D            14.4      2.9");
        tw.append("RGB-D(1)         15.4      2.9");
        tw.append("RGB-D(2)         14.6      2.8");
        tw.append("");
        tw.append("8-bit color      25.7      25.5    15.9");
        tw.append("8-bit color(1)   27.0       6.2");
        tw.append("8-bit color(2)   24.6      18.3");
        tw.append("");
        tw.append("8-bit grays      25.6      17.2    15.1");
        tw.append("8-bit grays(1)   26.3      8.4");
        tw.append("8-bit grays(2)   24.4      13.8");
        tw.append("");
        tw.append("(1) Image partially covered by ImageJ window");
        tw.append("(2) Image zoomed 2:1 and displayed in 512x512 window");
        tw.append("RGB-D = RGB image using the default direct color model");
    }

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        if (arg.equals("show")) {
            this.showRates();
            return 4096;
        }
        this.imp = imp;
        return 147;
    }

    public void run(ImageProcessor ip) {
        this.width = ip.getWidth();
        this.increment = 3;
        if (this.width % this.increment == 0) {
            this.increment = 5;
            if (this.width % this.increment == 0) {
                this.increment = 7;
                if (this.width % this.increment == 0) {
                    IJ.error("Width cannot be a multiple of 3, 5 or 7");
                    return;
                }
            }
        }
        this.height = ip.getHeight();
        if (ip.getPixels() instanceof byte[]) {
            this.pixels = (byte[])ip.getPixels();
            this.pixels2 = (byte[])ip.getPixelsCopy();
        } else {
            this.rgbPixels = (int[])ip.getPixels();
            this.rgbPixels2 = (int[])ip.getPixelsCopy();
        }
        this.waveTable = new int[this.width];
        for (int i = 0; i < this.width; ++i) {
            this.waveTable[i] = (int)((Math.sin((double)i / this.frequency) + 1.0) * this.amplitude);
        }
        this.win = this.imp.getWindow();
        this.ic = this.win.getCanvas();
        this.imp.killRoi();
        this.g = this.ic.getGraphics();
        Thread.currentThread().setPriority(1);
        this.startTime = System.currentTimeMillis();
        this.win.running = true;
        while (this.win.running) {
            if (this.pixels != null) {
                this.updateByteImage();
            } else {
                this.updateRGBImage();
            }
            this.imp.updateAndDraw();
            this.showFrameRate();
            Thread.yield();
        }
        ip.reset();
        this.imp.updateAndDraw();
    }

    void showFrameRate() {
        ++this.frames;
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        if (this.elapsedTime > 0L) {
            int cheight = this.ic.getSize().height;
            this.fps = (long)(this.frames * 10000) / this.elapsedTime;
            this.g.clearRect(0, cheight - 15, 50, 15);
            this.g.drawString(this.fps / 10L + "." + this.fps % 10L + " fps", 2, cheight - 2);
        }
    }

    void updateByteImage() {
        int i = this.index;
        int inc = this.increment;
        int y = this.height;
        while (--y >= 0) {
            int offset = y * this.width;
            int x = this.width;
            while (--x >= 0) {
                int x2;
                if ((i += inc) >= this.width) {
                    i = 0;
                }
                if ((x2 = x + this.waveTable[i]) >= this.width) {
                    x2 = this.width - 1;
                }
                this.pixels[offset + x] = this.pixels2[offset + x2];
            }
        }
        this.index = i;
    }

    void updateRGBImage() {
        int i = this.index;
        int inc = this.increment;
        for (int y = 0; y < this.height; ++y) {
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                int x2;
                if ((i += inc) >= this.width) {
                    i = 0;
                }
                if ((x2 = x + this.waveTable[i]) >= this.width) {
                    x2 = this.width - 1;
                }
                this.rgbPixels[offset + x] = this.rgbPixels2[offset + x2];
            }
        }
        this.index = i;
    }
}

