/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 31;
    }

    public void run(ImageProcessor ip) {
        String bg;
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        double background = ip.getPixelValue(0, 0);
        if (ip instanceof ColorProcessor) {
            int c = ip.getPixel(0, 0);
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            bg = r + "," + g + "," + b;
        } else {
            bg = (double)((int)background) == background ? IJ.d2s(background, 0) : "" + background;
        }
        this.imp.killRoi();
        boolean okay = IJ.showMessageWithCancel("XY_Coordinates", "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\nis assumed to be the value of the pixel in the\nupper left corner of the image.\n \n    Width: " + width + "\n" + "    Height: " + height + "\n" + "    Background value: " + bg + "\n");
        if (!okay) {
            return;
        }
        SaveDialog sd = new SaveDialog("Save Coordinates as Text...", this.imp.getTitle(), ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.write("" + e);
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int count = 0;
        String ls = System.getProperty("line.separator");
        int type = this.imp.getType();
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                float v = ip.getPixelValue(x, y);
                if ((double)v == background) continue;
                if (type == 2) {
                    pw.print(x + "\t" + (height - 1 - y) + "\t" + v + ls);
                } else if (type == 4) {
                    int c = ip.getPixel(x, y);
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    pw.print(x + "\t" + (height - 1 - y) + "\t" + r + "\t" + g + "\t" + b + ls);
                } else {
                    pw.print(x + "\t" + (height - 1 - y) + "\t" + (int)v + ls);
                }
                ++count;
            }
            if (y % 10 != 0) continue;
            IJ.showProgress((double)(height - y) / (double)height);
        }
        IJ.showProgress(1.0);
        pw.close();
        IJ.write(this.imp.getTitle() + ": " + count + " pixels (" + IJ.d2s((double)count * 100.0 / (double)(width * height)) + "%)\n");
    }
}

