/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class ColorSelector
extends PlugInFrame
implements ItemListener {
    private static ResourceBundle bun = IJ.getColorBundle();
    private static final int ROI = 0;
    private static final int FOREGROUND = 1;
    private static final int BACKGROUND = 2;
    private Choice color;
    private String[] colors = new String[]{bun.getString("RedColor"), bun.getString("GreenColor"), bun.getString("BlueColor"), bun.getString("MagentaColor"), bun.getString("CyanColor"), bun.getString("YellowColor"), bun.getString("OrangeColor"), bun.getString("BlackColor"), bun.getString("WhiteColor")};
    private int mode = 0;

    public ColorSelector() {
        super(bun.getString("SelectionColor"));
    }

    public void run(String arg) {
        String name;
        Color c;
        if (arg.equals("roi")) {
            this.setTitle(bun.getString("SelectionColor"));
            this.mode = 0;
        } else if (arg.equals("back")) {
            this.setTitle(bun.getString("BackGColor"));
            this.mode = 2;
        } else {
            this.setTitle(bun.getString("ForGColor"));
            this.mode = 1;
        }
        this.setLayout(new FlowLayout(1, 35, 5));
        this.color = new Choice();
        for (int i = 0; i < this.colors.length; ++i) {
            this.color.addItem(this.colors[i]);
        }
        switch (this.mode) {
            case 0: {
                c = Roi.getColor();
                name = bun.getString("YellowColor");
                break;
            }
            case 2: {
                c = Toolbar.getBackgroundColor();
                name = bun.getString("WhiteColor");
                break;
            }
            default: {
                c = Toolbar.getForegroundColor();
                name = bun.getString("BlackColor");
            }
        }
        if (c.equals(Color.red)) {
            name = this.colors[0];
        } else if (c.equals(Color.green)) {
            name = this.colors[1];
        } else if (c.equals(Color.blue)) {
            name = this.colors[2];
        } else if (c.equals(Color.magenta)) {
            name = this.colors[3];
        } else if (c.equals(Color.cyan)) {
            name = this.colors[4];
        } else if (c.equals(Color.yellow)) {
            name = this.colors[5];
        } else if (c.equals(Color.orange)) {
            name = this.colors[6];
        } else if (c.equals(Color.black)) {
            name = this.colors[7];
        } else if (c.equals(Color.white)) {
            name = this.colors[8];
        }
        this.color.select(name);
        this.color.addItemListener(this);
        this.add(this.color);
        this.pack();
        Dimension size = this.getSize();
        if (size.width < 180) {
            this.setSize(180, size.height);
        }
        GUI.center(this);
        this.show();
    }

    public void itemStateChanged(ItemEvent e) {
        String name = this.color.getSelectedItem();
        Color c = Color.yellow;
        if (name.equals(this.colors[0])) {
            c = Color.red;
        } else if (name.equals(this.colors[1])) {
            c = Color.green;
        } else if (name.equals(this.colors[2])) {
            c = Color.blue;
        } else if (name.equals(this.colors[3])) {
            c = Color.magenta;
        } else if (name.equals(this.colors[4])) {
            c = Color.cyan;
        } else if (name.equals(this.colors[5])) {
            c = Color.yellow;
        } else if (name.equals(this.colors[6])) {
            c = Color.orange;
        } else if (name.equals(this.colors[7])) {
            c = Color.black;
        } else if (name.equals(this.colors[8])) {
            c = Color.white;
        }
        switch (this.mode) {
            case 0: {
                Roi.setColor(c);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp == null) break;
                imp.draw();
                break;
            }
            case 1: {
                Toolbar.setForegroundColor(c);
                if (!Recorder.record) break;
                Recorder.record("setForegroundColor", c.getRed(), c.getGreen(), c.getBlue());
                break;
            }
            case 2: {
                Toolbar.setBackgroundColor(c);
                if (!Recorder.record) break;
                Recorder.record("setBackgroundColor", c.getRed(), c.getGreen(), c.getBlue());
            }
        }
    }
}

