/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ContrastPlot
extends Canvas
implements MouseListener {
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram = null;
    int hmax;
    Image os;
    Graphics osg;
    final int WIDTH = 256;
    final int HEIGHT = 64;

    public ContrastPlot() {
        this.addMouseListener(this);
        this.setSize(257, 65);
    }

    void setHistogram(ImageStatistics stats) {
        if (this.histogram != null) {
            return;
        }
        this.histogram = stats.histogram;
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        for (int i = 0; i < 128; ++i) {
            this.histogram[i] = (this.histogram[2 * i] + this.histogram[2 * i + 1]) / 2;
        }
        int maxCount = 0;
        int mode = 0;
        for (int i = 0; i < 128; ++i) {
            if (this.histogram[i] <= maxCount) continue;
            maxCount = this.histogram[i];
            mode = i;
        }
        int maxCount2 = 0;
        for (int i = 0; i < 128; ++i) {
            if (this.histogram[i] <= maxCount2 || i == mode) continue;
            maxCount2 = this.histogram[i];
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        double scale = 256.0 / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        if (this.max != this.min) {
            slope = 64.0 / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = 64;
        } else {
            x1 = 0;
            y1 = this.max > this.min ? 64 - (int)((this.defaultMin - this.min) * slope) : 64;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = 256;
            y2 = this.max > this.min ? 64 - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null) {
                this.os = this.createImage(256, 64);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 256, 64);
                this.osg.setColor(Color.gray);
                for (int i = 0; i < 256; ++i) {
                    this.osg.drawLine(i, 64, i, 64 - 64 * this.histogram[i] / this.hmax);
                }
                this.osg.dispose();
            }
            g.drawImage(this.os, 0, 0, this);
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, 256, 64);
        }
        g.setColor(Color.red);
        g.drawRect(x1, 0, x2 - x1, 64);
        g.setColor(Color.black);
        g.drawLine(x2, 59, x2, 64);
        g.drawRect(0, 0, 256, 64);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

