/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.MessageDialog;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.plugin.frame.PlugInFrame;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener {
    Panel panel;
    static Frame instance;
    List list;
    Hashtable rois = new Hashtable();

    public RoiManager() {
        super(IJ.getPluginBundle().getString("RoiTitle"));
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        WindowManager.addWindow(this);
        this.setLayout(new FlowLayout(1, 5, 5));
        int rows = 18;
        this.list = new List(rows, true);
        this.list.add("012345678901234567");
        this.list.addItemListener(this);
        this.add(this.list);
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(10, 1, 5, 5));
        this.addButton(IJ.getPluginBundle().getString("RoiAdd"));
        this.addButton(IJ.getPluginBundle().getString("RoiAdd&Draw"));
        this.addButton(IJ.getPluginBundle().getString("RoiDel"));
        this.addButton(IJ.getPluginBundle().getString("RoiOpen"));
        this.addButton(IJ.getPluginBundle().getString("RoiOpenAll"));
        this.addButton(IJ.getPluginBundle().getString("RoiSave"));
        this.addButton(IJ.getPluginBundle().getString("RoiSel"));
        this.addButton(IJ.getPluginBundle().getString("RoiMeasure"));
        this.addButton(IJ.getPluginBundle().getString("RoiDraw"));
        this.addButton(IJ.getPluginBundle().getString("RoiFill"));
        this.add(this.panel);
        this.pack();
        this.list.remove(0);
        GUI.center(this);
        this.show();
    }

    void addButton(String label) {
        Button b = new Button(label);
        b.addActionListener(this);
        this.panel.add(b);
    }

    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        String command = label;
        if (command.equals(IJ.getPluginBundle().getString("RoiAdd"))) {
            this.add();
        }
        if (command.equals(IJ.getPluginBundle().getString("RoiAdd&Draw"))) {
            this.addAndDraw();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiDel"))) {
            this.delete();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiOpen"))) {
            this.open();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiOpenAll"))) {
            this.openAll();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiSave"))) {
            this.save();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiSel"))) {
            this.selectAll();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiMeasure"))) {
            this.measure();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiDraw"))) {
            this.draw();
        } else if (command.equals(IJ.getPluginBundle().getString("RoiFill"))) {
            this.fill();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && WindowManager.getCurrentImage() != null) {
            int index = 0;
            try {
                index = Integer.parseInt(e.getItem().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (index < 0) {
                index = 0;
            }
            this.restore(index);
        }
    }

    boolean add() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error(IJ.getPluginBundle().getString("RoiErr1"));
            return false;
        }
        String type = null;
        switch (roi.getType()) {
            case 0: {
                type = "Rectangle";
                break;
            }
            case 1: {
                type = "Oval";
                break;
            }
            case 2: {
                type = "Polygon";
                break;
            }
            case 3: {
                type = "Freehand";
                break;
            }
            case 4: {
                type = "Traced";
                break;
            }
            case 5: {
                type = "Line";
                break;
            }
            case 6: {
                type = "Polyline";
                break;
            }
            case 7: {
                type = "Freeline";
            }
        }
        if (type == null) {
            return false;
        }
        Rectangle r = roi.getBoundingRect();
        String label = type + (r.x + r.width / 2) + "-" + (r.y + r.height / 2);
        this.list.add(label);
        this.rois.put(label, roi.clone());
        return true;
    }

    void addAndDraw() {
        if (this.add()) {
            this.list.select(this.list.getItemCount() - 1);
            this.draw();
        }
    }

    boolean delete() {
        int count = this.list.getItemCount();
        if (count == 0) {
            return this.error(IJ.getPluginBundle().getString("RoiErr2"));
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error(IJ.getPluginBundle().getString("RoiErr3"));
        }
        for (int i = count - 1; i >= 0; --i) {
            boolean delete = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                delete = true;
            }
            if (!delete) continue;
            this.rois.remove(this.list.getItem(i));
            this.list.remove(i);
        }
        return true;
    }

    boolean restore(int index) {
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Rectangle r = roi.getBoundingRect();
        if (r.x + r.width > imp.getWidth() || r.y + r.height > imp.getHeight()) {
            return this.error(IJ.getPluginBundle().getString("RoiErr4"));
        }
        imp.setRoi(roi);
        return true;
    }

    void open() {
        Macro.setOptions(null);
        OpenDialog od = new OpenDialog(IJ.getPluginBundle().getString("RoiOpenTitle"), "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        Opener o = new Opener();
        String path = directory + name;
        Roi roi = o.openRoi(path);
        if (roi != null) {
            this.list.add(name);
            this.rois.put(name, roi);
        }
    }

    void openAll() {
        Macro.setOptions(null);
        Macro.setOptions(null);
        OpenDialog od = new OpenDialog(IJ.getPluginBundle().getString("RoiOpenFolder"), "");
        if (od.getFileName() == null) {
            return;
        }
        String dir = od.getDirectory();
        String[] files = new File(dir).list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            Roi roi;
            File f = new File(dir + files[i]);
            if (f.isDirectory() || !files[i].endsWith(".roi") || (roi = new Opener().openRoi(dir + files[i])) == null) continue;
            this.list.add(files[i]);
            this.rois.put(files[i], roi);
        }
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error(IJ.getPluginBundle().getString("RoiErr2"));
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error(IJ.getPluginBundle().getString("RoiErr3"));
        }
        String name = this.list.getItem(index[0]);
        Macro.setOptions(null);
        SaveDialog sd = new SaveDialog(IJ.getPluginBundle().getString("RoiSaveTitle"), name, ".roi");
        name = sd.getFileName();
        if (name == null) {
            return false;
        }
        String dir = sd.getDirectory();
        for (int i = 0; i < index.length && this.restore(index[i]); ++i) {
            if (index.length > 1) {
                name = this.list.getItem(index[i]) + ".roi";
            }
            IJ.run(Prefs.getCommand("saveas12"), "path='" + dir + name + "'");
        }
        return true;
    }

    void selectAll() {
        int i;
        boolean allSelected = true;
        int count = this.list.getItemCount();
        for (i = 0; i < count; ++i) {
            if (this.list.isIndexSelected(i)) continue;
            allSelected = false;
        }
        for (i = 0; i < count; ++i) {
            if (allSelected) {
                this.list.deselect(i);
                continue;
            }
            this.list.select(i);
        }
    }

    boolean measure() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error(IJ.getPluginBundle().getString("RoiErr3"));
        }
        int setup = IJ.setupDialog(imp, 0);
        if (setup == 4096) {
            return false;
        }
        int nSlices = setup == 32 ? imp.getStackSize() : 1;
        int currentSlice = imp.getCurrentSlice();
        for (int slice = 1; slice <= nSlices; ++slice) {
            if (nSlices > 1) {
                imp.setSlice(slice);
            }
            for (int i = 0; i < index.length && this.restore(index[i]); ++i) {
                IJ.run(IJ.getBundle().getString("Measure"));
            }
        }
        imp.setSlice(currentSlice);
        if (index.length > 1) {
            IJ.run(Prefs.getShortCommand("selection02"));
        }
        return true;
    }

    boolean fill() {
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error(IJ.getPluginBundle().getString("RoiErr3"));
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        for (int i = 0; i < index.length && this.restore(index[i]); ++i) {
            IJ.run(IJ.getBundle().getString("Fill"));
            IJ.run(Prefs.getShortCommand("selection02"));
        }
        Undo.setup(5, imp);
        return true;
    }

    boolean draw() {
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0) {
            return this.error(IJ.getPluginBundle().getString("RoiErr3"));
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        for (int i = 0; i < index.length && this.restore(index[i]); ++i) {
            IJ.run(IJ.getBundle().getString("Draw"));
            IJ.run(Prefs.getShortCommand("selection02"));
        }
        Undo.setup(5, imp);
        return true;
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error(IJ.getPluginBundle().getString("NoImgErr"));
            return null;
        }
        return imp;
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, IJ.getPluginBundle().getString("RoiTitle"), msg);
        return false;
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }
}

