/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

class EllipseFitter {
    static final double HALFPI = 1.5707963267949;
    public double xCenter;
    public double yCenter;
    public double major;
    public double minor;
    public double angle;
    public double theta;
    private int bitCount;
    private double xsum;
    private double ysum;
    private double x2sum;
    private double y2sum;
    private double xysum;
    private int[] mask;
    private int left;
    private int top;
    private int width;
    private int height;
    private double n;
    private double xm;
    private double ym;
    private double u20;
    private double u02;
    private double u11;
    private ImageProcessor ip;
    private double pw;
    private double ph;

    EllipseFitter() {
    }

    public void fit(ImageProcessor ip, ImageStatistics stats) {
        this.ip = ip;
        this.mask = ip.getMask();
        Rectangle r = ip.getRoi();
        this.pw = stats.pw;
        this.ph = stats.ph;
        this.left = r.x;
        this.top = r.y;
        this.width = r.width;
        this.height = r.height;
        this.getEllipseParam();
    }

    void getEllipseParam() {
        double sqrtPi = 1.772453851;
        if (this.mask == null) {
            this.major = (double)(this.width * 2) / sqrtPi;
            this.minor = (double)(this.height * 2) / sqrtPi;
            this.angle = 0.0;
            this.theta = 0.0;
            if (this.major < this.minor) {
                double tmp = this.major;
                this.major = this.minor;
                this.minor = tmp;
                this.angle = 90.0;
                this.theta = 1.5707963267948966;
            }
            this.xCenter = (double)this.left + (double)this.width / 2.0;
            this.yCenter = (double)this.top + (double)this.height / 2.0;
            return;
        }
        this.computeSums();
        this.getMoments();
        double m4 = 4.0 * Math.abs(this.u02 * this.u20 - this.u11 * this.u11);
        if (m4 < 1.0E-6) {
            m4 = 1.0E-6;
        }
        double a11 = this.u02 / m4;
        double a12 = this.u11 / m4;
        double a22 = this.u20 / m4;
        double xoffset = this.xm;
        double yoffset = this.ym;
        double tmp = a11 - a22;
        if (tmp == 0.0) {
            tmp = 1.0E-6;
        }
        this.theta = 0.5 * Math.atan(2.0 * a12 / tmp);
        if (this.theta < 0.0) {
            this.theta += 1.5707963267949;
        }
        if (a12 > 0.0) {
            this.theta += 1.5707963267949;
        } else if (a12 == 0.0) {
            if (a22 > a11) {
                this.theta = 0.0;
                tmp = a22;
                a22 = a11;
                a11 = tmp;
            } else if (a11 != a22) {
                this.theta = 1.5707963267949;
            }
        }
        tmp = Math.sin(this.theta);
        if (tmp == 0.0) {
            tmp = 1.0E-6;
        }
        double z = a12 * Math.cos(this.theta) / tmp;
        this.major = Math.sqrt(1.0 / Math.abs(a22 + z));
        this.minor = Math.sqrt(1.0 / Math.abs(a11 - z));
        double scale = Math.sqrt((double)this.bitCount / (Math.PI * this.major * this.minor));
        this.major = this.major * scale * 2.0;
        this.minor = this.minor * scale * 2.0;
        this.angle = 180.0 * this.theta / Math.PI;
        if (this.angle == 180.0) {
            this.angle = 0.0;
        }
        if (this.major < this.minor) {
            tmp = this.major;
            this.major = this.minor;
            this.minor = tmp;
        }
        this.xCenter = (double)this.left + xoffset + 0.5;
        this.yCenter = (double)this.top + yoffset + 0.5;
    }

    void computeSums() {
        this.xsum = 0.0;
        this.ysum = 0.0;
        this.x2sum = 0.0;
        this.y2sum = 0.0;
        this.xysum = 0.0;
        for (int y = 0; y < this.height; ++y) {
            int bitcountOfLine = 0;
            int xSumOfLine = 0;
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                if (this.mask[offset + x] != -16777216) continue;
                ++bitcountOfLine;
                xSumOfLine += x;
                this.x2sum += (double)(x * x);
            }
            this.xsum += (double)xSumOfLine;
            this.ysum += (double)(bitcountOfLine * y);
            double ye = y;
            double xe = xSumOfLine;
            this.xysum += xe * ye;
            this.y2sum += ye * ye * (double)bitcountOfLine;
            this.bitCount += bitcountOfLine;
        }
    }

    void getMoments() {
        if (this.bitCount == 0) {
            return;
        }
        this.x2sum += 0.08333333 * (double)this.bitCount;
        this.y2sum += 0.08333333 * (double)this.bitCount;
        this.n = this.bitCount;
        double x1 = this.xsum / this.n;
        double y1 = this.ysum / this.n;
        double x2 = this.x2sum / this.n;
        double y2 = this.y2sum / this.n;
        double xy = this.xysum / this.n;
        this.xm = x1;
        this.ym = y1;
        this.u20 = x2 - x1 * x1;
        this.u02 = y2 - y1 * y1;
        this.u11 = xy - x1 * y1;
    }

    public void drawEllipse(ImageProcessor ip) {
        int x;
        int y;
        if (this.major == 0.0 && this.minor == 0.0) {
            return;
        }
        int xc = (int)Math.round(this.xCenter);
        int yc = (int)Math.round(this.yCenter);
        int maxY = ip.getHeight();
        int[] txmin = new int[maxY];
        int[] txmax = new int[maxY];
        double sint = Math.sin(this.theta);
        double cost = Math.cos(this.theta);
        double rmajor2 = 1.0 / this.sqr(this.major / 2.0);
        double rminor2 = 1.0 / this.sqr(this.minor / 2.0);
        double g11 = rmajor2 * this.sqr(cost) + rminor2 * this.sqr(sint);
        double g12 = (rmajor2 - rminor2) * sint * cost;
        double g22 = rmajor2 * this.sqr(sint) + rminor2 * this.sqr(cost);
        double k1 = -g12 / g11;
        double k3 = 1.0 / g11;
        double k2 = (this.sqr(g12) - g11 * g22) / this.sqr(g11);
        int ymax = (int)Math.floor(Math.sqrt(Math.abs(k3 / k2)));
        if (ymax > maxY) {
            ymax = maxY;
        }
        if (ymax < 1) {
            ymax = 1;
        }
        int ymin = -ymax;
        for (y = 0; y <= ymax; ++y) {
            double j2 = Math.sqrt(k2 * this.sqr(y) + k3);
            double j1 = k1 * (double)y;
            txmin[y] = (int)Math.round(j1 - j2);
            txmax[y] = (int)Math.round(j1 + j2);
        }
        int xsave = txmin[ymax - 1];
        for (y = ymin; y < ymax; ++y) {
            x = y < 0 ? txmax[-y] : -txmin[y];
            ip.moveTo(xc + xsave, yc + y);
            ip.lineTo(xc + x, yc + y);
            xsave = x;
        }
        for (y = ymax; y > ymin; --y) {
            x = y < 0 ? txmin[-y] : -txmax[y];
            ip.moveTo(xc + xsave, yc + y);
            ip.lineTo(xc + x, yc + y);
            xsave = x;
        }
    }

    private double sqr(double x) {
        return x * x;
    }
}

