/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.io.SaveDialog;
import ij.plugin.filter.Analyzer;
import ij.process.Photometer;
import ij.text.TextCanvas;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextPanel
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ClipboardOwner,
ActionListener {
    int iGridWidth;
    int iGridHeight;
    int iX;
    int iY;
    String[] sColHead;
    Vector vData;
    int[] iColWidth;
    int iColCount;
    int iRowCount;
    int iRowHeight;
    int iFirstRow;
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    int iSbWidth;
    int iSbHeight;
    boolean bDrag;
    int iXDrag;
    int iColDrag;
    boolean headings = true;
    String title = "";
    String labels;
    KeyListener keyListener;
    Cursor resizeCursor = new Cursor(11);
    Cursor defaultCursor = new Cursor(0);
    int selStart = -1;
    int selEnd = -1;
    int selOrigin = -1;
    int selLine = -1;
    TextCanvas tc = new TextCanvas(this);
    PopupMenu pm;
    boolean columnsManuallyAdjusted;
    boolean modifListener = false;
    static ResourceBundle etiq = IJ.getBundle();

    public TextPanel() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tc);
        this.sbHoriz = new Scrollbar(0);
        this.sbHoriz.addAdjustmentListener(this);
        this.add("South", this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.sbVert.addAdjustmentListener(this);
        this.add("East", this.sbVert);
        this.addPopupMenu();
    }

    public TextPanel(String title) {
        this();
        if (title.equals(etiq.getString("Results"))) {
            this.pm.addSeparator();
            this.addPopupItem(etiq.getString("ClearResults"));
            this.addPopupItem(etiq.getString("Summarize"));
            this.addPopupItem(etiq.getString("SetMeasurements"));
        }
    }

    public TextPanel(String title, boolean hint) {
        this(title);
        this.modifListener = true;
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem(etiq.getString("SaveAs"));
        this.pm.addSeparator();
        this.addPopupItem(etiq.getString("Cut"));
        this.addPopupItem(etiq.getString("Copy"));
        this.addPopupItem(etiq.getString("Clear"));
        this.addPopupItem(etiq.getString("SelectAll"));
        this.addPopupItem(etiq.getString("CopyAll"));
        this.add(this.pm);
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    public synchronized void setColumnHeadings(String labels) {
        boolean sameLabels = labels.equals(this.labels);
        this.labels = labels;
        if (labels.equals("")) {
            this.iColCount = 1;
            this.sColHead = new String[1];
            this.sColHead[0] = "";
        } else {
            StringTokenizer t = new StringTokenizer(labels, "\t");
            this.iColCount = t.countTokens();
            this.sColHead = new String[this.iColCount];
            for (int i = 0; i < this.iColCount; ++i) {
                this.sColHead[i] = t.nextToken();
            }
        }
        this.flush();
        this.vData = new Vector();
        if (this.iColWidth == null || this.iColWidth.length != this.iColCount || !sameLabels || this.iColCount == 1) {
            this.iColWidth = new int[this.iColCount];
            this.columnsManuallyAdjusted = false;
        }
        this.iRowCount = 0;
        this.resetSelection();
        this.adjustHScroll();
        this.tc.repaint();
    }

    public String getColumnHeadings() {
        return this.labels == null ? "" : this.labels;
    }

    public void setFont(Font font) {
        this.tc.fFont = font;
        this.tc.iImage = null;
        this.tc.fMetrics = this.getFontMetrics(font);
        this.iRowHeight = this.tc.fMetrics.getAscent() + this.tc.fMetrics.getDescent();
        if (this.iColWidth != null) {
            this.iColWidth[0] = 0;
        }
    }

    public void appendLine(String data) {
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        char[] chars = data.toCharArray();
        this.vData.addElement(chars);
        ++this.iRowCount;
        if (this.isShowing()) {
            if (this.iColCount == 1 && this.tc.fMetrics != null) {
                this.iColWidth[0] = Math.max(this.iColWidth[0], this.tc.fMetrics.charsWidth(chars, 0, chars.length));
                this.adjustHScroll();
            }
            this.iY = this.iRowHeight * (this.iRowCount + 1);
            this.adjustVScroll();
            if (this.iColCount > 1 && this.iRowCount <= 10 && !this.columnsManuallyAdjusted) {
                this.iColWidth[0] = 0;
            }
            this.tc.repaint();
            Thread.yield();
        }
    }

    public void append(String data) {
        int p;
        if (data == null) {
            data = "null";
        }
        do {
            if ((p = data.indexOf(10)) < 0) {
                this.appendLine(data);
                break;
            }
            this.appendLine(data.substring(0, p));
        } while (!(data = data.substring(p + 1)).equals(""));
    }

    String getCell(int column, int row) {
        if (column < 0 || column >= this.iColCount || row < 0 || row >= this.iRowCount) {
            return null;
        }
        return new String(this.tc.getChars(column, row));
    }

    synchronized void adjustVScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension d = this.tc.getSize();
        int value = this.iY / this.iRowHeight;
        int visible = d.height / this.iRowHeight;
        int maximum = this.iRowCount + 1;
        if (visible < 0) {
            visible = 0;
        }
        if (visible > maximum) {
            visible = maximum;
        }
        if (value > maximum - visible) {
            value = maximum - visible;
        }
        this.sbVert.setValues(value, visible, 0, maximum);
        this.iY = this.iRowHeight * value;
    }

    synchronized void adjustHScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension d = this.tc.getSize();
        int w = 0;
        for (int i = 0; i < this.iColCount; ++i) {
            w += this.iColWidth[i];
        }
        this.iGridWidth = w;
        this.sbHoriz.setValues(this.iX, d.width, 0, this.iGridWidth);
        this.iX = this.sbHoriz.getValue();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
        this.tc.repaint();
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || e.isMetaDown()) {
            this.pm.show(e.getComponent(), x, y);
        } else if (e.isShiftDown()) {
            this.extendSelection(x, y);
        } else {
            this.select(x, y);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (y <= this.iRowHeight) {
            int i;
            int xb = x;
            x = x + this.iX - this.iGridWidth;
            for (i = this.iColCount - 1; i >= 0 && (x <= -7 || x >= 7); x += this.iColWidth[i], --i) {
            }
            if (i >= 0) {
                if (!this.bDrag) {
                    this.setCursor(this.resizeCursor);
                    this.bDrag = true;
                    this.iXDrag = xb - this.iColWidth[i];
                    this.iColDrag = i;
                }
                return;
            }
        }
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.isPopupTrigger() || e.isMetaDown()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.bDrag && x < this.tc.getSize().width) {
            int w = x - this.iXDrag;
            if (w < 0) {
                w = 0;
            }
            this.iColWidth[this.iColDrag] = w;
            this.columnsManuallyAdjusted = true;
            this.adjustHScroll();
            this.tc.repaint();
        } else {
            this.extendSelection(x, y);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.modifListener) {
            String s = this.getLine();
            if (s == null) {
                return;
            }
            Photometer.getInstance().set(s);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void addKeyListener(KeyListener listener) {
        this.keyListener = listener;
    }

    public void keyPressed(KeyEvent e) {
        boolean cutCopyOK;
        boolean bl = cutCopyOK = (e.isControlDown() || e.isMetaDown()) && this.selStart != -1 && this.selEnd != -1;
        if (cutCopyOK && e.getKeyCode() == 67) {
            this.copySelection();
        } else if (cutCopyOK && e.getKeyCode() == 88) {
            if (this.copySelection() > 0) {
                this.clearSelection();
            }
        } else if (this.keyListener != null) {
            this.keyListener.keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.modifListener && e.getKeyCode() == 8) {
            Photometer.getInstance();
            Photometer.clear(this.getSelection(true));
            this.clearSelection();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        this.doCommand(cmd);
    }

    void doCommand(String cmd) {
        if (cmd == null) {
            return;
        }
        if (cmd.equals(etiq.getString("SaveAs"))) {
            this.saveAs("");
        } else if (cmd.equals(etiq.getString("Cut"))) {
            this.copySelection();
            if (this.modifListener) {
                Photometer.clear(this.getSelection(true));
            }
            this.clearSelection();
        } else if (cmd.equals(etiq.getString("Copy"))) {
            this.copySelection();
        } else if (cmd.equals(etiq.getString("Clear"))) {
            if (this.modifListener) {
                Photometer.clear(this.getSelection(true));
            }
            this.clearSelection();
        } else if (cmd.equals(etiq.getString("SelectAll"))) {
            this.selectAll();
        } else if (cmd.equals(etiq.getString("CopyAll"))) {
            this.selectAll();
            this.copySelection();
        } else if (cmd.equals(etiq.getString("Summarize"))) {
            IJ.doCommand(etiq.getString("Summarize"));
        } else if (cmd.equals(etiq.getString("ClearResults"))) {
            IJ.doCommand(etiq.getString("ClearResults"));
        } else if (cmd.equals(etiq.getString("SetMeasurements"))) {
            IJ.doCommand(etiq.getString("SetMeasurements"));
        }
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    void select(int x, int y) {
        Dimension d = this.tc.getSize();
        if (this.iRowHeight == 0 || x > d.width || y > d.height) {
            return;
        }
        int r = y / this.iRowHeight - 1 + this.iFirstRow;
        if (r >= 0 && r < this.iRowCount) {
            this.selOrigin = r;
            this.selStart = r;
            this.selEnd = r;
        }
        this.tc.repaint();
        this.selLine = r;
    }

    void extendSelection(int x, int y) {
        Dimension d = this.tc.getSize();
        if (this.iRowHeight == 0 || x > d.width || y > d.height) {
            return;
        }
        int r = y / this.iRowHeight - 1 + this.iFirstRow;
        if (r >= 0 && r < this.iRowCount) {
            if (r < this.selOrigin) {
                this.selStart = r;
                this.selEnd = this.selOrigin;
            } else {
                this.selStart = this.selOrigin;
                this.selEnd = r;
            }
        }
        this.tc.repaint();
        this.selLine = r;
    }

    public String getSelection(boolean addNewline) {
        if (this.selStart == -1 || this.selEnd == -1) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = this.selStart; i <= this.selEnd; ++i) {
            char[] chars = (char[])this.vData.elementAt(i);
            sb.append(chars);
            if (!addNewline) continue;
            sb.append('\n');
        }
        return new String(sb);
    }

    public int copySelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            return 0;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = this.selStart; i <= this.selEnd; ++i) {
            char[] chars = (char[])this.vData.elementAt(i);
            sb.append(chars);
            sb.append('\n');
        }
        String s = new String(sb);
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip == null) {
            return 0;
        }
        StringSelection cont = new StringSelection(s);
        clip.setContents(cont, this);
        if (s.length() > 0) {
            IJ.showStatus(this.selEnd - this.selStart + 1 + " " + etiq.getString("LinesCopied"));
            if (this.getParent() instanceof ImageJ) {
                Analyzer.setSaved();
            }
        }
        return s.length();
    }

    public void clearSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            return;
        }
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.vData.removeAllElements();
            this.iRowCount = 0;
            if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
                Analyzer.setSaved();
                Analyzer.resetCounter();
            }
        } else {
            int count = this.selEnd - this.selStart + 1;
            for (int i = 0; i < count; ++i) {
                this.vData.removeElementAt(this.selStart);
                --this.iRowCount;
            }
        }
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    public void selectAll() {
        this.selStart = 0;
        this.selEnd = this.iRowCount - 1;
        this.selOrigin = 0;
        this.tc.repaint();
        this.selLine = -1;
    }

    public void resetSelection() {
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        if (this.iRowCount > 0) {
            this.tc.repaint();
        }
    }

    public void save(PrintWriter pw) {
        this.resetSelection();
        if (this.labels != null && !this.labels.equals("")) {
            pw.println(this.labels);
        }
        for (int i = 0; i < this.iRowCount; ++i) {
            char[] chars = (char[])this.vData.elementAt(i);
            pw.println(new String(chars));
        }
    }

    public void saveAs(String path) {
        if (path.equals("")) {
            SaveDialog sd = new SaveDialog(etiq.getString("SaveAsText"), this.title, ".txt");
            String file = sd.getFileName();
            if (file == null) {
                return;
            }
            path = sd.getDirectory() + file;
        }
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            return;
        }
        this.save(pw);
        pw.close();
        if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
            Analyzer.setSaved();
        }
        IJ.showStatus("");
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        if (this.labels != null && !this.labels.equals("")) {
            sb.append(this.labels);
            sb.append('\n');
        }
        for (int i = 0; i < this.iRowCount; ++i) {
            char[] chars = (char[])this.vData.elementAt(i);
            sb.append(chars);
            sb.append('\n');
        }
        return new String(sb);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getLineCount() {
        return this.iRowCount;
    }

    public String getLine(int index) {
        if (index < 0 || index >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + index);
        }
        return new String((char[])this.vData.elementAt(index));
    }

    public String getLine() {
        if (this.selLine == -1 || this.selLine >= this.getLineCount()) {
            return null;
        }
        return this.getLine(this.selLine);
    }

    void flush() {
        if (this.vData != null) {
            this.vData.removeAllElements();
        }
        this.vData = null;
    }
}

