/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import ij.IJ;
import ij.Prefs;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;

public class Java2 {
    private static boolean lookAndFeelSet;

    public static void setAntialiased(Graphics g, boolean antialiased) {
        Graphics2D g2d = (Graphics2D)g;
        if (antialiased) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public static void setAntialiasedText(Graphics g, boolean antialiasedText) {
        Graphics2D g2d = (Graphics2D)g;
        if (antialiasedText && Prefs.antialiasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public static int getStringWidth(String s, FontMetrics fontMetrics, Graphics g) {
        Rectangle2D r = fontMetrics.getStringBounds(s, g);
        return (int)r.getWidth();
    }

    public static void setBilinearInterpolation(Graphics g, boolean bilinearInterpolation) {
        Graphics2D g2d = (Graphics2D)g;
        if (bilinearInterpolation && Prefs.interpolateScaledImages) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
    }

    public static void setSystemLookAndFeel() {
        if (lookAndFeelSet) {
            return;
        }
        try {
            if (IJ.isWindows()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (!IJ.isMacintosh()) {
                String s = System.getProperty("java.version");
                int dot_ver = Integer.parseInt(s.substring(s.lastIndexOf(46) + 1, s.length()));
                if (dot_ver >= 2) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                } else {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lookAndFeelSet = true;
        IJ.register(Java2.class);
    }
}

