/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class spjExecState {
    boolean spjDEBUG = false;
    String exeErr00 = "FATAL: can not create execution directory\n";
    String exeErr01 = "FATAL: can not create execution state file\n";
    String exeErr02 = "FATAL: can not read the execution state file\n";
    String exeMess = "Status file not found!\nInitialize it?\n";
    String staMess = " execution state in file ";
    String exeState = "";
    String exeSname = "SPJstat.dat";
    File exeDir;
    File exeFile;
    String exeFsep;
    String exePath;
    char lineSep;
    int[][] taskStat = new int[][]{{0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0}, {0, 0, 0}, {0}};

    public spjExecState(String spjTitle, String wrkCode) {
        this.lineSep = System.getProperty("line.separator").charAt(0);
        this.exeFsep = System.getProperty("file.separator");
        this.exePath = System.getProperty("user.home") + this.exeFsep + wrkCode;
        this.exeDir = new File(this.exePath);
        this.exeSname = this.exePath + this.exeFsep + this.exeSname;
        this.exeFile = new File(this.exeSname);
        if (this.exeDir.exists()) {
            if (this.spjDEBUG) {
                IJ.showMessage(spjTitle, "DEBUG: Directory exists!\n" + this.exePath);
            }
            if (this.exeFile.exists()) {
                this.exeState = this.readStateFile(spjTitle);
            } else if (IJ.showMessageWithCancel(spjTitle, this.exeMess + this.exeSname)) {
                this.exeState = this.initStateFile(spjTitle, wrkCode);
            }
        } else {
            if (this.spjDEBUG) {
                IJ.showMessage(spjTitle, "DEBUG: Directory not found!\n" + this.exePath);
            }
            if (!this.exeDir.mkdir()) {
                IJ.showMessage(spjTitle, this.exeErr00 + this.exePath);
                return;
            }
            if (this.spjDEBUG) {
                IJ.showMessage(spjTitle, "DEBUG: Directory created!\n" + this.exePath);
            }
            this.exeState = this.initStateFile(spjTitle, wrkCode);
        }
        IJ.showStatus(spjTitle + this.staMess + this.exePath);
        IJ.beep();
        IJ.wait(1000);
        IJ.showStatus("");
    }

    private String initStateFile(String spjTitle, String wrkCode) {
        try {
            DataOutputStream exeWrite = new DataOutputStream(new FileOutputStream(this.exeSname));
            exeWrite.writeChars(spjTitle);
            exeWrite.writeChar(this.lineSep);
            exeWrite.writeChars(wrkCode);
            exeWrite.writeChar(this.lineSep);
            exeWrite.writeChar(65);
            exeWrite.writeChar(83);
            exeWrite.writeInt(100);
            exeWrite.writeChar(68);
            exeWrite.writeInt(0);
            exeWrite.writeChar(69);
            exeWrite.writeInt(0);
            exeWrite.writeChar(67);
            exeWrite.writeInt(0);
            exeWrite.writeChar(this.lineSep);
            exeWrite.close();
        }
        catch (IOException e) {
            IJ.showMessage(spjTitle, this.exeErr01 + this.exeSname);
            return "";
        }
        if (this.spjDEBUG) {
            IJ.showMessage(spjTitle, "DEBUG: State file initialized!\n" + this.exeSname);
        }
        return "OK";
    }

    private String readStateFile(String spjTitle) {
        StringBuffer wCode;
        StringBuffer sTitle;
        if (this.spjDEBUG) {
            IJ.showMessage(spjTitle, "DEBUG: Status file exists!\n" + this.exeSname);
        }
        try {
            char chr;
            DataInputStream exeRead = new DataInputStream(new FileInputStream(this.exeSname));
            sTitle = new StringBuffer(20);
            while ((chr = exeRead.readChar()) != this.lineSep) {
                sTitle.append(chr);
            }
            wCode = new StringBuffer(20);
            while ((chr = exeRead.readChar()) != this.lineSep) {
                wCode.append(chr);
            }
            exeRead.close();
        }
        catch (IOException e) {
            IJ.showMessage(spjTitle, this.exeErr02 + this.exeSname);
            return "";
        }
        if (this.spjDEBUG) {
            IJ.showMessage(spjTitle, "DEBUG: Status read!\n" + sTitle.toString() + "\n" + wCode.toString());
        }
        return "OK";
    }

    int[][] getState() {
        return this.taskStat;
    }
}

