/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;

class MergingDataSource
extends DataSource {
    DataSource[] sources;
    SourceStream[] streams = null;
    Object[] controls = null;

    MergingDataSource(DataSource[] sources) {
        this.sources = sources;
    }

    public String getContentType() {
        if (this.sources.length == 1) {
            return this.sources[0].getContentType();
        }
        boolean isRaw = true;
        for (int index = 0; index < this.sources.length; ++index) {
            if (this.sources[index].getContentType().equals("raw")) continue;
            isRaw = false;
            break;
        }
        if (isRaw) {
            return "raw";
        }
        if (this.sources.length == 1) {
            return this.sources[0].getContentType();
        }
        return "application.mixed-data";
    }

    public void connect() throws IOException {
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            this.sources[i2].connect();
        }
    }

    public void disconnect() {
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            this.sources[i2].disconnect();
        }
    }

    public void start() throws IOException {
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            this.sources[i2].start();
        }
    }

    public void stop() throws IOException {
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            this.sources[i2].stop();
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            Vector<Object> vcontrols = new Vector<Object>(1);
            for (int i2 = 0; i2 < this.sources.length; ++i2) {
                Object[] cs = this.sources[i2].getControls();
                if (cs.length <= 0) continue;
                for (int j2 = 0; j2 < cs.length; ++j2) {
                    vcontrols.addElement(cs[j2]);
                }
            }
            this.controls = new Object[vcontrols.size()];
            for (int c2 = 0; c2 < vcontrols.size(); ++c2) {
                this.controls[c2] = vcontrols.elementAt(c2);
            }
        }
        return this.controls;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i2 = 0; i2 < cs.length; ++i2) {
                if (!cls.isInstance(cs[i2])) continue;
                return cs[i2];
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Time getDuration() {
        Time longest = new Time(0L);
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            Time sourceDuration = this.sources[i2].getDuration();
            if (!(sourceDuration.getSeconds() > longest.getSeconds())) continue;
            longest = sourceDuration;
        }
        return longest;
    }
}

