/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicConnector;
import com.sun.media.CircularBuffer;
import com.sun.media.InputConnector;
import com.sun.media.OutputConnector;
import javax.media.Buffer;
import javax.media.Format;

public class BasicOutputConnector
extends BasicConnector
implements OutputConnector {
    protected InputConnector inputConnector = null;
    private boolean reset = false;

    public Format connectTo(InputConnector inputConnector, Format useThisFormat) {
        Format format = this.canConnectTo(inputConnector, useThisFormat);
        this.inputConnector = inputConnector;
        inputConnector.setOutputConnector(this);
        int bufferSize = Math.max(this.getSize(), inputConnector.getSize());
        this.circularBuffer = new CircularBuffer(bufferSize);
        inputConnector.setCircularBuffer(this.circularBuffer);
        return null;
    }

    public Format canConnectTo(InputConnector inputConnector, Format useThisFormat) {
        if (this.getProtocol() != inputConnector.getProtocol()) {
            throw new RuntimeException("protocols do not match:: ");
        }
        return null;
    }

    public InputConnector getInputConnector() {
        return this.inputConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        CircularBuffer circularBuffer = this.circularBuffer;
        synchronized (circularBuffer) {
            this.reset = true;
            super.reset();
            if (this.inputConnector != null) {
                this.inputConnector.reset();
            }
            this.circularBuffer.notifyAll();
        }
    }

    public boolean isEmptyBufferAvailable() {
        return this.circularBuffer.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getEmptyBuffer() {
        switch (this.protocol) {
            case 0: {
                if (!this.isEmptyBufferAvailable() && this.reset) {
                    return null;
                }
                this.reset = false;
                return this.circularBuffer.getEmptyBuffer();
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    this.reset = false;
                    while (!this.reset && !this.isEmptyBufferAvailable()) {
                        try {
                            this.circularBuffer.wait();
                        }
                        catch (Exception e2) {}
                    }
                    if (this.reset) {
                        return null;
                    }
                    Buffer buffer = this.circularBuffer.getEmptyBuffer();
                    this.circularBuffer.notifyAll();
                    return buffer;
                }
            }
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReport() {
        switch (this.protocol) {
            case 0: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        return;
                    }
                    this.circularBuffer.writeReport();
                }
                this.getInputConnector().getModule().connectorPushed(this.getInputConnector());
                return;
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        return;
                    }
                    this.circularBuffer.writeReport();
                    this.circularBuffer.notifyAll();
                    return;
                }
            }
        }
        throw new RuntimeException();
    }
}

