/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.ExtBuffer;
import com.sun.media.NBA;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.format.VideoFormat;

public abstract class BasicPlugIn
implements PlugIn {
    private static final boolean DEBUG = false;
    protected Object[] controls = new Control[0];
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;

    protected void error() {
        throw new RuntimeException(this.getClass().getName() + " PlugIn error");
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i2 = 0; i2 < cs.length; ++i2) {
                if (!cls.isInstance(cs[i2])) continue;
                return cs[i2];
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Format matches(Format in, Format[] outs) {
        for (int i2 = 0; i2 < outs.length; ++i2) {
            if (!in.matches(outs[i2])) continue;
            return outs[i2];
        }
        return null;
    }

    protected byte[] validateByteArraySize(Buffer buffer, int newSize) {
        byte[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof byte[]) {
            typedArray = (byte[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            byte[] tempArray = new byte[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new byte[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected short[] validateShortArraySize(Buffer buffer, int newSize) {
        short[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof short[]) {
            typedArray = (short[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            short[] tempArray = new short[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new short[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected int[] validateIntArraySize(Buffer buffer, int newSize) {
        int[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof int[]) {
            typedArray = (int[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            int[] tempArray = new int[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new int[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected final long getNativeData(Object data) {
        if (data instanceof NBA) {
            return ((NBA)data).getNativeData();
        }
        return 0L;
    }

    protected Object getInputData(Buffer inBuffer) {
        Object inData = null;
        if (inBuffer instanceof ExtBuffer) {
            ((ExtBuffer)inBuffer).setNativePreferred(true);
            inData = ((ExtBuffer)inBuffer).getNativeData();
        }
        if (inData == null) {
            inData = inBuffer.getData();
        }
        return inData;
    }

    protected Object getOutputData(Buffer buffer) {
        Object data = null;
        if (buffer instanceof ExtBuffer) {
            data = ((ExtBuffer)buffer).getNativeData();
        }
        if (data == null) {
            data = buffer.getData();
        }
        return data;
    }

    protected Object validateData(Buffer buffer, int length, boolean allowNative) {
        Format format = buffer.getFormat();
        Class dataType = format.getDataType();
        if (length < 1 && format != null && format instanceof VideoFormat) {
            length = ((VideoFormat)format).getMaxDataLength();
        }
        if (allowNative && buffer instanceof ExtBuffer && ((ExtBuffer)buffer).isNativePreferred()) {
            ExtBuffer extb = (ExtBuffer)buffer;
            if (extb.getNativeData() == null || extb.getNativeData().getSize() < length) {
                extb.setNativeData(new NBA(format.getDataType(), length));
            }
            return extb.getNativeData();
        }
        if (dataType == Format.byteArray) {
            return this.validateByteArraySize(buffer, length);
        }
        if (dataType == Format.shortArray) {
            return this.validateShortArraySize(buffer, length);
        }
        if (dataType == Format.intArray) {
            return this.validateIntArraySize(buffer, length);
        }
        System.err.println("Error in validateData");
        return null;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = Class.class.getMethod("forName", String.class, Boolean.TYPE, ClassLoader.class);
            getSystemClassLoaderM = ClassLoader.class.getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)ClassLoader.class, null);
            getContextClassLoaderM = Thread.class.getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable t) {
            forName3ArgsM = null;
            return false;
        }
    }

    public static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e2) {
                if (!BasicPlugIn.checkIfJDK12()) {
                    throw new ClassNotFoundException(e2.getMessage());
                }
            }
            catch (Error e3) {
                if (BasicPlugIn.checkIfJDK12()) break block9;
                throw e3;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)Class.class, className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable e4) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)Class.class, className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e5) {
                throw new ClassNotFoundException(e5.getMessage());
            }
            catch (Error e6) {
                throw e6;
            }
        }
    }

    public static boolean plugInExists(String name, int type) {
        Vector cnames = PlugInManager.getPlugInList(null, null, type);
        for (int i2 = 0; i2 < cnames.size(); ++i2) {
            if (!name.equals((String)cnames.elementAt(i2))) continue;
            return true;
        }
        return false;
    }
}

