/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicModule;
import com.sun.media.BasicPlugIn;
import com.sun.media.Connector;
import com.sun.media.CreateSourceThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MyOutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.SourceThread;
import com.sun.media.rtp.util.RTPTimeBase;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PriorityAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceStream;

public class BasicSourceModule
extends BasicModule
implements Duration,
Positionable {
    PlaybackEngine engine;
    protected DataSource source;
    protected Demultiplexer parser;
    protected Track[] tracks = new Track[0];
    protected SourceThread[] loops;
    protected String[] connectorNames;
    protected long bitsRead = 0L;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    Object resetSync = new Object();
    protected boolean started = false;
    protected SystemTimeBase systemTimeBase = new SystemTimeBase();
    protected long lastSystemTime = 0L;
    protected long originSystemTime = 0L;
    protected long currentSystemTime = 0L;
    protected Time lastPositionSet = new Time(0L);
    RTPTimeBase rtpMapperUpdatable = null;
    RTPTimeBase rtpMapper = null;
    long currentRTPTime = 0L;
    long oldOffset = 0L;
    boolean rtpOffsetInvalid = true;
    String cname = null;
    public String errMsg = null;
    int latencyTrack = -1;

    public static BasicSourceModule createModule(DataSource ds) throws IOException, IncompatibleSourceException {
        Demultiplexer parser = BasicSourceModule.createDemultiplexer(ds);
        if (parser == null) {
            return null;
        }
        return new BasicSourceModule(ds, parser);
    }

    protected BasicSourceModule(DataSource ds, Demultiplexer demux) {
        this.source = ds;
        this.parser = demux;
        SourceStream stream = null;
        if (this.source instanceof PullDataSource) {
            stream = ((PullDataSource)this.source).getStreams()[0];
        } else if (this.source instanceof PushDataSource) {
            stream = ((PushDataSource)this.source).getStreams()[0];
        }
    }

    protected static Demultiplexer createDemultiplexer(DataSource ds) throws IOException, IncompatibleSourceException {
        ContentDescriptor cd = new ContentDescriptor(ds.getContentType());
        Vector cnames = PlugInManager.getPlugInList(cd, null, 1);
        Demultiplexer parser = null;
        IOException ioe = null;
        IncompatibleSourceException ise = null;
        for (int i2 = 0; i2 < cnames.size(); ++i2) {
            try {
                Class cls = BasicPlugIn.getClassForName((String)cnames.elementAt(i2));
                Object p = cls.newInstance();
                if (!(p instanceof Demultiplexer)) continue;
                parser = (Demultiplexer)p;
                try {
                    parser.setSource(ds);
                    break;
                }
                catch (IOException e2) {
                    parser = null;
                    ioe = e2;
                    continue;
                }
                catch (IncompatibleSourceException e3) {
                    parser = null;
                    ise = e3;
                    continue;
                }
            }
            catch (ClassNotFoundException e4) {
                continue;
            }
            catch (InstantiationException e5) {
                continue;
            }
            catch (IllegalAccessException e6) {
                // empty catch block
            }
        }
        if (parser == null) {
            if (ioe != null) {
                throw ioe;
            }
            if (ise != null) {
                throw ise;
            }
        }
        return parser;
    }

    public boolean doRealize() {
        try {
            this.parser.open();
        }
        catch (ResourceUnavailableException e2) {
            this.errMsg = "Resource unavailable: " + e2.getMessage();
            return false;
        }
        try {
            this.parser.start();
            this.tracks = this.parser.getTracks();
        }
        catch (BadHeaderException e3) {
            this.errMsg = "Bad header in the media: " + e3.getMessage();
            this.parser.close();
            return false;
        }
        catch (IOException e4) {
            this.errMsg = "IO exception: " + e4.getMessage();
            this.parser.close();
            return false;
        }
        if (this.tracks == null || this.tracks.length == 0) {
            this.errMsg = "The media has 0 track";
            this.parser.close();
            return false;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Exception e5) {
                securityPrivelege = false;
            }
        }
        this.loops = new SourceThread[this.tracks.length];
        this.connectorNames = new String[this.tracks.length];
        for (int i2 = 0; i2 < this.tracks.length; ++i2) {
            MyOutputConnector oc = new MyOutputConnector(this.tracks[i2]);
            oc.setProtocol(0);
            oc.setSize(1);
            this.connectorNames[i2] = this.tracks[i2].toString();
            this.registerOutputConnector(this.tracks[i2].toString(), oc);
            this.loops[i2] = null;
        }
        this.engine = (PlaybackEngine)this.getController();
        if (this.engine == null || !this.engine.isRTP()) {
            this.parser.stop();
        }
        return true;
    }

    SourceThread createSourceThread(int idx) {
        SourceThread thread = null;
        MyOutputConnector oc = (MyOutputConnector)this.getOutputConnector(this.connectorNames[idx]);
        if (oc == null || oc.getInputConnector() == null) {
            this.tracks[idx].setEnabled(false);
            return null;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = CreateSourceThreadAction.cons;
                Constructor pcons = jdk12PriorityAction.cons;
                thread = (SourceThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(SourceThread.class, this, oc, new Integer(idx)));
                int priority = this.tracks[idx].getFormat() instanceof AudioFormat ? MediaThread.getAudioPriority() : MediaThread.getVideoPriority();
                thread.useVideoPriority();
                jdk12.doPrivM.invoke((Object)jdk12.ac, pcons.newInstance(thread, new Integer(priority)));
            }
            catch (Exception e3) {
                thread = null;
            }
        } else {
            thread = new SourceThread(this, oc, idx);
            if (this.tracks[idx].getFormat() instanceof AudioFormat) {
                thread.useAudioPriority();
            } else {
                thread.useVideoPriority();
            }
        }
        if (thread == null) {
            this.tracks[idx].setEnabled(false);
        }
        return thread;
    }

    public void doFailedRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public void abortRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        return true;
    }

    public void doFailedPrefetch() {
    }

    public void abortPrefetch() {
        this.doStop();
    }

    public void doStart() {
        this.lastSystemTime = this.systemTimeBase.getNanoseconds();
        this.originSystemTime = this.currentSystemTime;
        this.rtpOffsetInvalid = true;
        super.doStart();
        try {
            this.parser.start();
        }
        catch (IOException e2) {
            // empty catch block
        }
        for (int i2 = 0; i2 < this.loops.length; ++i2) {
            if (!this.tracks[i2].isEnabled() || this.loops[i2] == null && (this.loops[i2] = this.createSourceThread(i2)) == null) continue;
            this.loops[i2].start();
        }
        this.started = true;
    }

    public void doStop() {
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.resetSync;
        synchronized (object) {
            for (int i2 = 0; i2 < this.loops.length; ++i2) {
                if (!this.tracks[i2].isEnabled() || this.loops[i2] == null || this.loops[i2].resetted) continue;
                this.loops[i2].pause();
            }
            this.parser.stop();
        }
    }

    public void doDealloc() {
    }

    public void doClose() {
        this.parser.close();
        if (this.tracks == null) {
            return;
        }
        for (int i2 = 0; i2 < this.tracks.length; ++i2) {
            if (this.loops[i2] == null) continue;
            this.loops[i2].kill();
        }
        if (this.rtpMapperUpdatable != null) {
            RTPTimeBase.returnMapperUpdatable(this.rtpMapperUpdatable);
            this.rtpMapperUpdatable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.resetSync;
        synchronized (object) {
            super.reset();
            for (int i2 = 0; i2 < this.loops.length; ++i2) {
                if (!this.tracks[i2].isEnabled() || this.loops[i2] == null && (this.loops[i2] = this.createSourceThread(i2)) == null) continue;
                this.loops[i2].resetted = true;
                this.loops[i2].start();
            }
        }
    }

    public String[] getOutputConnectorNames() {
        return this.connectorNames;
    }

    public Time getDuration() {
        return this.parser.getDuration();
    }

    public Time setPosition(Time when, int rounding) {
        Time t = this.parser.setPosition(when, rounding);
        this.lastPositionSet = this.lastPositionSet.getNanoseconds() == t.getNanoseconds() ? new Time(t.getNanoseconds() + 1L) : t;
        return t;
    }

    public boolean isPositionable() {
        return this.parser.isPositionable();
    }

    public boolean isRandomAccess() {
        return this.parser.isRandomAccess();
    }

    public Object[] getControls() {
        return this.parser.getControls();
    }

    public Object getControl(String s) {
        return this.parser.getControl(s);
    }

    public Demultiplexer getDemultiplexer() {
        return this.parser;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public void process() {
    }

    public long getBitsRead() {
        return this.bitsRead;
    }

    public void resetBitsRead() {
        this.bitsRead = 0L;
    }

    boolean readHasBlocked() {
        if (this.loops == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.loops.length; ++i2) {
            if (this.loops[i2] == null || !this.loops[i2].readBlocked) continue;
            return true;
        }
        return false;
    }

    public void checkLatency() {
        if (this.latencyTrack > -1) {
            if (this.tracks[this.latencyTrack].isEnabled() && this.loops[this.latencyTrack] != null) {
                this.loops[this.latencyTrack].checkLatency = true;
                return;
            }
            this.latencyTrack = -1;
        }
        for (int i2 = 0; i2 < this.tracks.length; ++i2) {
            if (!this.tracks[i2].isEnabled()) continue;
            this.latencyTrack = i2;
            if (this.tracks[i2].getFormat() instanceof VideoFormat) break;
        }
        if (this.latencyTrack > -1 && this.loops[this.latencyTrack] != null) {
            this.loops[this.latencyTrack].checkLatency = true;
        }
    }

    protected boolean checkAllPaused() {
        for (int i2 = 0; i2 < this.loops.length; ++i2) {
            if (!this.tracks[i2].isEnabled() || this.loops[i2] == null || this.loops[i2].isPaused()) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

