/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.JMFSecurityManager;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.util.Arch;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeEncoder
extends AudioCodec {
    private int nativeData = 0;
    protected int INSIZE = 0;
    protected int OUTSIZE = 0;
    byte[] encData;
    int encDataLen = 0;
    BitRateControl bra;
    Control[] controls;
    boolean settingsChanged = false;
    private int numFramesPerOutputBuffer = 2;
    private int numFramesInBuffer = 0;
    private int outOffset = 0;
    static Hashtable bitRateTable = new Hashtable();

    public native int nOpen(AudioFormat var1);

    public native boolean nClose(int var1);

    public native int nConvert(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    public native int nFlush(int var1, byte[] var2);

    public NativeEncoder() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", 22050.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1), new AudioFormat("LINEAR", 24000.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1), new AudioFormat("LINEAR", 44100.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1), new AudioFormat("LINEAR", 48000.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1)};
        this.outputFormats = new Format[]{new AudioFormat("mpegaudio", -1.0, -1, -1, 1, -1)};
        this.bra = new BitRateControl(this, 64000, 24000, 128000);
    }

    public String getName() {
        return "MPEG Layer 2 Encoder";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (input instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)input;
            Format[] outputs = new Format[]{new AudioFormat("mpegaudio", af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), 1, 1)};
            return outputs;
        }
        return new Format[0];
    }

    public int getBitRate() {
        return this.bra.getBitRate();
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = this.bra;
        }
        return this.controls;
    }

    public int isLayer3() {
        return 0;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.nativeData != 0) {
            this.close();
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpa");
            this.nativeData = this.nOpen((AudioFormat)this.outputFormat);
            if (this.nativeData == 0) {
                throw new ResourceUnavailableException("could not open " + this.getName());
            }
            this.encData = new byte[this.INSIZE * this.numFramesPerOutputBuffer];
            return;
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("could not open " + this.getName());
        }
    }

    public synchronized void close() {
        if (this.nativeData != 0) {
            this.nClose(this.nativeData);
            this.nativeData = 0;
        }
    }

    public synchronized void reset() {
        if (this.nativeData != 0) {
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException rue) {
                System.err.println("MP2 Encoder: " + rue);
            }
        }
    }

    public Format setOutputFormat(Format format) {
        if (NativeEncoder.matches(format, this.getSupportedOutputFormats(this.inputFormat)) == null) {
            return null;
        }
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat in = (AudioFormat)format;
        double sampleRate = in.getSampleRate();
        int channels = in.getChannels();
        int bitRate = this.computeBitRate((int)sampleRate, channels);
        this.bra.setBitRate(bitRate);
        this.outputFormat = new AudioFormat(in.getEncoding(), sampleRate, in.getSampleSizeInBits(), channels, in.getEndian(), in.getSigned(), 8, this.getBitRate() / 8, in.getDataType());
        return this.outputFormat;
    }

    public synchronized int process(Buffer in, Buffer out) {
        if (this.isEOM(in)) {
            int len = this.nFlush(this.nativeData, (byte[])out.getData());
            if (len > 0) {
                out.setOffset(0);
                out.setLength(len);
            } else {
                out.setLength(0);
            }
            out.setFormat(this.outputFormat);
            out.setEOM(true);
            if (this.settingsChanged) {
                this.reset();
                this.settingsChanged = false;
            }
            return 0;
        }
        if (!(in.getData() instanceof byte[])) {
            return 1;
        }
        int inOffset = in.getOffset();
        int inLength = in.getLength();
        byte[] inData = (byte[])in.getData();
        byte[] outData = (byte[])out.getData();
        if (outData == null || outData.length < this.OUTSIZE * this.numFramesPerOutputBuffer) {
            outData = new byte[this.OUTSIZE * this.numFramesPerOutputBuffer];
            out.setData(outData);
        }
        int rtn = 0;
        if (this.nativeData != 0) {
            while (this.encDataLen < this.INSIZE * this.numFramesPerOutputBuffer && inOffset < inLength) {
                this.encData[this.encDataLen] = inData[inOffset];
                ++inOffset;
                ++this.encDataLen;
            }
            if (this.encDataLen >= this.INSIZE * this.numFramesPerOutputBuffer) {
                for (int i2 = 0; i2 < this.numFramesPerOutputBuffer; ++i2) {
                    int returnVal = this.nConvert(this.nativeData, this.encData, this.INSIZE * i2, this.INSIZE, (byte[])out.getData(), this.outOffset);
                    if (returnVal < 0) {
                        return 1;
                    }
                    ++this.numFramesInBuffer;
                    this.outOffset += returnVal;
                }
                this.encDataLen = 0;
                this.numFramesInBuffer = 0;
                if (this.outOffset == 0) {
                    rtn |= 4;
                } else {
                    out.setOffset(0);
                    out.setLength(this.outOffset);
                    out.setFormat(this.outputFormat);
                    this.outOffset = 0;
                }
            } else {
                rtn |= 4;
            }
        }
        if (inOffset < inLength) {
            in.setOffset(inOffset);
            rtn |= 2;
        }
        if (rtn == 0 && this.settingsChanged) {
            this.reset();
            this.settingsChanged = false;
        }
        return rtn;
    }

    private int computeBitRate(int sampleRate, int channels) {
        int bitRate;
        Object o2 = bitRateTable.get(new Integer(sampleRate));
        if (o2 != null) {
            bitRate = (Integer)o2;
            bitRate *= channels;
        } else {
            bitRate = 64000;
        }
        return bitRate;
    }

    static {
        bitRateTable.put(new Integer(32000), new Integer(48000));
        bitRateTable.put(new Integer(44100), new Integer(64000));
        bitRateTable.put(new Integer(48000), new Integer(64000));
        bitRateTable.put(new Integer(16000), new Integer(24000));
        bitRateTable.put(new Integer(22050), new Integer(32000));
        bitRateTable.put(new Integer(24000), new Integer(32000));
    }

    class BitRateControl
    extends BitRateAdapter
    implements Owned {
        NativeEncoder encoder;

        public BitRateControl(NativeEncoder enc, int init, int min, int max) {
            super(init, min, max, true);
            this.encoder = enc;
        }

        public int setBitRate(int val) {
            int rtn = super.setBitRate(val);
            this.encoder.settingsChanged = true;
            return rtn;
        }

        public Object getOwner() {
            return this.encoder;
        }
    }
}

