/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.mpa.MPAHeader;
import com.sun.media.codec.audio.mpa.MPAParse;
import com.sun.media.codec.audio.mpa.PacketSizeAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class Packetizer
extends AudioCodec {
    private static final int NEW_FRAME = 0;
    private static final int CONT_FRAME = 1;
    private static final int CONT_BUFFER = 2;
    private static final int FILL_BUFFER = 3;
    private int state = 0;
    public static final int MAX_MPA_FRAMESIZE = 1729;
    public static final int MAX_FRAMESIZE = 1456;
    public static final int MIN_FRAMESIZE = 110;
    public static final int DEFAULT_FRAMESIZE = 1456;
    private static final boolean debug = false;
    private byte[] pendingData = new byte[131072];
    private int pendingDataSize = 0;
    private int pendingDataOffset = 0;
    private boolean expectingSameInputBuffer = false;
    private boolean inputEOM = false;
    private boolean setMark = true;
    private boolean resetTime = true;
    private int frameSize = 0;
    private int frameOffset = 0;
    private long frameCount = 0L;
    private int packetSize = 1456;
    private long packetSeq = 0L;
    private long currentTime = 1L;
    private long deltaTime = 0L;
    private MPAHeader mpaHeader = null;
    private MPAParse mpaParse = new MPAParse();

    public Packetizer() {
        this.inputFormats = new AudioFormat[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1)};
        this.outputFormats = new AudioFormat[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, 1)};
    }

    public String getName() {
        return "MPEG Audio Packetizer";
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return new Format[]{new AudioFormat("mpegaudio/rtp")};
        }
        if (Packetizer.matches(in, this.inputFormats) == null) {
            return new Format[1];
        }
        if (!(in instanceof AudioFormat)) {
            return new Format[]{new AudioFormat("mpegaudio/rtp")};
        }
        return this.getMatchingOutputFormats(in);
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.outputFormats = new AudioFormat[]{new AudioFormat("mpegaudio/rtp", af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), af.getEndian(), 1, af.getFrameSizeInBits(), af.getFrameRate(), Format.byteArray)};
        return this.outputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.setPacketSize(this.packetSize);
        this.reset();
        this.currentTime = 1L;
        this.packetSeq = 0L;
        this.resetTime = true;
    }

    public synchronized void reset() {
        super.reset();
        this.mpaParse.reset();
        this.resetPendingData();
        this.state = 0;
        this.setMark = true;
        this.expectingSameInputBuffer = false;
        this.frameSize = 0;
        this.frameOffset = 0;
        this.frameCount = 0L;
        this.resetTime = true;
        this.deltaTime = 0L;
    }

    public void close() {
    }

    public synchronized int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (inputBuffer.isDiscard()) {
            this.updateOutput(outputBuffer, this.outputFormat, 0, 0);
            outputBuffer.setDiscard(true);
            return 0;
        }
        try {
            int rc = this.doProcess(inputBuffer, outputBuffer);
            if (rc != 4) {
                outputBuffer.setSequenceNumber(this.packetSeq++);
                outputBuffer.setTimeStamp(this.currentTime);
            }
            if (this.inputEOM) {
                if (outputBuffer.getLength() == 0) {
                    this.propagateEOM(outputBuffer);
                    outputBuffer.setSequenceNumber(this.packetSeq++);
                    this.mpaParse.reset();
                    this.resetPendingData();
                    this.state = 0;
                    return 0;
                }
                if (rc == 4) {
                    outputBuffer.setSequenceNumber(this.packetSeq++);
                    outputBuffer.setTimeStamp(this.currentTime);
                }
                rc = 2;
                this.expectingSameInputBuffer = true;
            } else if (this.pendingDataSize <= 1738) {
                rc &= 0xFFFFFFFD;
                this.shiftPendingData();
            }
            return rc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        this.inputEOM = false;
        if (this.isEOM(inputBuffer)) {
            if (this.pendingDataSize == 0) {
                this.propagateEOM(outputBuffer);
                this.mpaParse.reset();
                this.resetPendingData();
                this.state = 0;
                return 0;
            }
            this.inputEOM = true;
        }
        byte[] inData = (byte[])inputBuffer.getData();
        int inOffset = inputBuffer.getOffset();
        int inLength = inputBuffer.getLength();
        if (!this.expectingSameInputBuffer) {
            if (inLength > 0 && inData != null) {
                if (this.resetTime) {
                    this.currentTime = inputBuffer.getTimeStamp();
                    if (this.currentTime == 0L) {
                        this.currentTime = 1L;
                    }
                    this.resetTime = false;
                }
                if (inLength > this.pendingData.length - this.pendingDataSize) {
                    this.mpaParse.reset();
                    this.resetPendingData();
                }
                System.arraycopy(inData, inOffset, this.pendingData, this.pendingDataOffset + this.pendingDataSize, inLength);
                this.pendingDataSize += inLength;
            } else if (!this.inputEOM) {
                return 4;
            }
            this.expectingSameInputBuffer = true;
        }
        if (this.mpaHeader == null) {
            this.mpaHeader = this.getMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        }
        switch (this.state) {
            case 0: {
                return this.newFrameNewBuffer(outputBuffer);
            }
            case 1: {
                return this.continueFrameInBuffer(outputBuffer);
            }
            case 2: {
                return this.continueFrameNewBuffer(outputBuffer);
            }
            case 3: {
                return this.newFrameInBuffer(outputBuffer);
            }
        }
        return 1;
    }

    protected int continueFrameNewBuffer(Buffer outputBuffer) {
        int copyLen = Math.min(this.pendingDataSize, this.frameSize - this.frameOffset);
        this.checkMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        if (this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
            this.state = 0;
            return this.newFrameNewBuffer(outputBuffer);
        }
        copyLen = Math.min(copyLen, this.packetSize - 4);
        this.setStartOfBuffer(outputBuffer, this.frameOffset);
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, copyLen, outputBuffer)) {
            this.state = 0;
            return 1;
        }
        this.frameOffset += copyLen;
        outputBuffer.setTimeStamp(this.currentTime);
        outputBuffer.setFormat(this.outputFormat);
        if (copyLen < this.pendingDataSize) {
            this.pendingDataOffset += copyLen;
            this.pendingDataSize -= copyLen;
            if (this.frameOffset >= this.frameSize || this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
                this.state = 0;
            }
            return 2;
        }
        this.pendingDataOffset += copyLen;
        this.pendingDataSize -= copyLen;
        this.shiftPendingData();
        if (!this.isOutputBufferFull(outputBuffer)) {
            this.state = 1;
            return 4;
        }
        return 0;
    }

    protected int continueFrameInBuffer(Buffer outputBuffer) {
        this.checkMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        int copyLen = Math.min(this.pendingDataSize, this.frameSize - this.frameOffset);
        if (this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
            this.state = 3;
            return this.newFrameInBuffer(outputBuffer);
        }
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, copyLen = Math.min(copyLen, this.packetSize - outputBuffer.getLength()), outputBuffer)) {
            this.state = 0;
            return 1;
        }
        this.frameOffset += copyLen;
        outputBuffer.setTimeStamp(this.currentTime);
        outputBuffer.setFormat(this.outputFormat);
        if (copyLen < this.pendingDataSize) {
            this.pendingDataOffset += copyLen;
            this.pendingDataSize -= copyLen;
            if (this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
                this.state = 3;
                return this.newFrameInBuffer(outputBuffer);
            }
            this.state = 2;
            return 2;
        }
        this.pendingDataOffset += copyLen;
        this.pendingDataSize -= copyLen;
        this.shiftPendingData();
        if (!this.isOutputBufferFull(outputBuffer)) {
            this.state = 1;
            return 4;
        }
        return 0;
    }

    protected int newFrameNewBuffer(Buffer outputBuffer) {
        if (this.mpaHeader == null) {
            this.shiftPendingData();
            return 4;
        }
        if (this.mpaHeader.headerOffset != this.pendingDataOffset) {
            this.pendingDataSize += this.pendingDataOffset - this.mpaHeader.headerOffset;
            this.pendingDataOffset = this.mpaHeader.headerOffset;
        }
        this.frameSize = this.mpaHeader.bitsInFrame >> 3;
        String encoding = "mpegaudio/rtp";
        AudioFormat af = (AudioFormat)this.outputFormat;
        if (af == null || af.getEncoding() != encoding || af.getSampleRate() != (double)this.mpaHeader.samplingRate || af.getChannels() != this.mpaHeader.nChannels) {
            int endian = 1;
            if (af != null) {
                endian = af.getEndian();
            }
            this.outputFormat = new AudioFormat(encoding, this.mpaHeader.samplingRate, 16, this.mpaHeader.nChannels, endian, 1);
        }
        this.setStartOfBuffer(outputBuffer, 0);
        int copyLen = Math.min(this.mpaHeader.bitsInFrame >> 3, this.pendingDataSize);
        copyLen = Math.min(copyLen, this.packetSize - 4);
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, copyLen, outputBuffer)) {
            this.state = 0;
            return 1;
        }
        this.frameOffset = copyLen;
        ++this.frameCount;
        this.currentTime += this.deltaTime;
        this.deltaTime = (long)this.mpaHeader.nSamples * 1000L * 1000000L / (long)this.mpaHeader.samplingRate;
        outputBuffer.setFormat(this.outputFormat);
        outputBuffer.setTimeStamp(this.currentTime);
        if (copyLen < this.pendingDataSize) {
            this.pendingDataOffset += copyLen;
            this.pendingDataSize -= copyLen;
            if (copyLen == this.mpaHeader.bitsInFrame >> 3) {
                this.state = 3;
                this.mpaHeader = this.getMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
                return this.newFrameInBuffer(outputBuffer);
            }
            this.state = 2;
            this.mpaHeader = null;
            return 2;
        }
        this.pendingDataOffset += copyLen;
        this.pendingDataSize -= copyLen;
        if (copyLen == this.mpaHeader.bitsInFrame >> 3) {
            this.shiftPendingData();
            if (this.isOutputBufferFull(outputBuffer)) {
                this.state = 0;
                return 0;
            }
            this.state = 3;
            return 4;
        }
        if (!this.isOutputBufferFull(outputBuffer)) {
            this.state = 1;
            this.shiftPendingData();
            return 4;
        }
        this.state = 2;
        this.shiftPendingData();
        return 0;
    }

    protected int newFrameInBuffer(Buffer outputBuffer) {
        int copyLen;
        if (this.mpaHeader == null) {
            this.state = 0;
            this.shiftPendingData();
            return 0;
        }
        if (this.pendingDataSize <= 1738 && !this.inputEOM) {
            this.state = 3;
            this.shiftPendingData();
            return 4;
        }
        if (this.mpaHeader.headerOffset != this.pendingDataOffset) {
            this.pendingDataSize += this.pendingDataOffset - this.mpaHeader.headerOffset;
            this.pendingDataOffset = this.mpaHeader.headerOffset;
        }
        if ((copyLen = this.mpaHeader.bitsInFrame >> 3) > this.pendingDataSize) {
            this.state = 3;
            this.shiftPendingData();
            return 4;
        }
        if (copyLen > this.packetSize - outputBuffer.getLength()) {
            this.state = 0;
            return 2;
        }
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, copyLen, outputBuffer)) {
            this.state = 0;
            return 2;
        }
        ++this.frameCount;
        this.deltaTime += (long)this.mpaHeader.nSamples * 1000L * 1000000L / (long)this.mpaHeader.samplingRate;
        this.pendingDataOffset += copyLen;
        this.pendingDataSize -= copyLen;
        if (this.pendingDataSize == 0) {
            this.state = 3;
            this.shiftPendingData();
            return 4;
        }
        this.state = 3;
        this.mpaHeader = this.getMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        return this.newFrameInBuffer(outputBuffer);
    }

    protected void shiftPendingData() {
        if (this.pendingDataOffset != 0 && this.pendingDataSize > 0) {
            System.arraycopy(this.pendingData, this.pendingDataOffset, this.pendingData, 0, this.pendingDataSize);
        }
        this.pendingDataOffset = 0;
        this.expectingSameInputBuffer = false;
        this.mpaHeader = null;
    }

    protected void resetPendingData() {
        this.pendingDataSize = 0;
        this.pendingDataOffset = 0;
        this.expectingSameInputBuffer = false;
        this.mpaHeader = null;
    }

    protected void checkMPAHeader(byte[] inData, int inOffset, int inLength) {
        int off = inOffset + this.frameSize - this.frameOffset;
        if (this.mpaHeader == null || this.mpaHeader.headerOffset == off) {
            return;
        }
        int len = inLength - (this.frameSize - this.frameOffset);
        this.mpaHeader = this.getMPAHeader(inData, off, len);
    }

    protected MPAHeader getMPAHeader(byte[] inData, int inOffset, int inLength) {
        MPAHeader header = new MPAHeader();
        int rc = this.mpaParse.getHeader(header, inData, inOffset, inLength);
        if (rc == MPAParse.MPA_OK) {
            return header;
        }
        if (this.inputEOM) {
            if (rc == MPAParse.MPA_HDR_DOUBTED) {
                return header;
            }
        }
        return null;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new PacketSizeAdapter(this, this.packetSize, true);
        }
        return this.controls;
    }

    public synchronized void setPacketSize(int newPacketSize) {
        this.packetSize = newPacketSize;
    }

    private boolean isOutputBufferFull(Buffer outputBuffer) {
        return this.packetSize <= outputBuffer.getLength() + 40;
    }

    private void setStartOfBuffer(Buffer outputBuffer, int frameOff) {
        byte[] outData = (byte[])outputBuffer.getData();
        if (outData == null || this.packetSize > outData.length) {
            outData = new byte[this.packetSize];
            outputBuffer.setData(outData);
        }
        outData[0] = 0;
        outData[1] = 0;
        outData[2] = (byte)(frameOff >> 8);
        outData[3] = (byte)frameOff;
        outputBuffer.setOffset(0);
        outputBuffer.setLength(4);
        if (this.setMark) {
            outputBuffer.setFlags(2048);
            this.setMark = false;
        } else {
            outputBuffer.setFlags(0);
        }
    }

    private boolean copyBuffer(byte[] inData, int inOff, int inLen, Buffer outputBuffer) {
        byte[] outData = (byte[])outputBuffer.getData();
        int outOff = outputBuffer.getLength();
        if (outOff + inLen > outData.length) {
            if (outOff + inLen > this.packetSize) {
                return false;
            }
            byte[] newData = new byte[this.packetSize];
            if (outOff > 0) {
                System.arraycopy(outData, 0, newData, 0, outOff);
            }
            outData = newData;
            outputBuffer.setData(outData);
        }
        System.arraycopy(inData, inOff, outData, outOff, inLen);
        outputBuffer.setLength(outOff + inLen);
        return true;
    }
}

