/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepak;

import com.sun.media.codec.video.cinepak.CineStore;
import com.sun.media.codec.video.cinepak.CodeEntry;
import com.sun.media.codec.video.cinepak.CpStrip;
import javax.media.Buffer;
import javax.media.format.VideoFormat;

public class CPChunk {
    int fChunkType;
    int fChunkLen;
    int[] lookup;
    static int[] fBounding24;
    static int firstFlag;

    public CPChunk() {
        firstFlag = 1;
    }

    public CPChunk(int[] nArray) {
        this.lookup = nArray;
        firstFlag = 1;
    }

    public void setLookup(int[] nArray) {
        this.lookup = nArray;
    }

    public void processChunk(byte[] byArray, CineStore cineStore, int n2, int n3, Buffer buffer) {
        fBounding24 = CineStore.BOUNDING24;
        this.fChunkType = (byArray[n3] & 0xFF) * 256 + (byArray[n3 + 1] & 0xFF);
        this.fChunkLen = (byArray[n3 + 2] & 0xFF) * 256 + (byArray[n3 + 3] & 0xFF);
        switch (this.fChunkType) {
            case 8192: {
                this.doCFUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Detail);
                break;
            }
            case 8704: {
                this.doCFUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Smooth);
                break;
            }
            case 8448: {
                this.doCPUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Detail);
                break;
            }
            case 8960: {
                this.doCPUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Smooth);
                break;
            }
            case 12288: {
                this.doFKUpdate(byArray, n3 + 4, cineStore, n2, buffer);
                break;
            }
            case 12800: {
                this.doFSKUpdate(byArray, n3 + 4, cineStore, n2, buffer);
                break;
            }
            case 12544: {
                this.doIUpdate(byArray, n3 + 4, cineStore, n2, buffer);
                break;
            }
            case 9216: {
                this.doGFUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Detail);
                break;
            }
            case 9728: {
                this.doGFUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Smooth);
                break;
            }
            case 9472: {
                this.doGPUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Detail);
                break;
            }
            case 9984: {
                this.doGPUpdate(byArray, n3 + 4, cineStore.StripVec[n2].Smooth);
                break;
            }
        }
    }

    public String getChunkType() {
        switch (this.fChunkType) {
            case 8704: {
                return "color full    smooth codebook update";
            }
            case 8192: {
                return "color full    detail codebook update";
            }
            case 8960: {
                return "color partial smooth codebook update";
            }
            case 8448: {
                return "color partial detail codebook update";
            }
            case 12288: {
                return "full key frame update";
            }
            case 12800: {
                return "full smooth key frame update";
            }
            case 12544: {
                return "interframe update";
            }
            case 9216: {
                return "greyscale full smooth codebook update";
            }
            case 9728: {
                return "greyscale full detail codebook update";
            }
            case 9472: {
                return "greyscale partial smooth codebook update";
            }
            case 9984: {
                return "greyscale partial detail codebook update";
            }
        }
        return "WARNING******* unknown atom chunk type...*******";
    }

    public int getChunkLength() {
        return this.fChunkLen;
    }

    private void doCFUpdate(byte[] byArray, int n2, CodeEntry[] codeEntryArray) {
        int n3 = ((byArray[n2 - 2] & 0xFF) * 256 + (byArray[n2 - 1] & 0xFF) - 4) / 6;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = byArray[n2 + n4 * 6] & 0xFF;
            int n6 = byArray[n2 + n4 * 6 + 1] & 0xFF;
            int n7 = byArray[n2 + n4 * 6 + 2] & 0xFF;
            int n8 = byArray[n2 + n4 * 6 + 3] & 0xFF;
            byte by = byArray[n2 + n4 * 6 + 4];
            byte by2 = byArray[n2 + n4 * 6 + 5];
            int n9 = 2 * by + 128;
            int n10 = 2 * by2 + 128;
            int n11 = -(by / 2) - by2 + 128;
            codeEntryArray[n4].aRGB0 = (fBounding24[n5 + n9] << 16) + (fBounding24[n5 + n11] << 8) + fBounding24[n5 + n10];
            codeEntryArray[n4].aRGB1 = (fBounding24[n6 + n9] << 16) + (fBounding24[n6 + n11] << 8) + fBounding24[n6 + n10];
            codeEntryArray[n4].aRGB2 = (fBounding24[n7 + n9] << 16) + (fBounding24[n7 + n11] << 8) + fBounding24[n7 + n10];
            codeEntryArray[n4].aRGB3 = (fBounding24[n8 + n9] << 16) + (fBounding24[n8 + n11] << 8) + fBounding24[n8 + n10];
            ++n4;
        }
    }

    private void doCPUpdate(byte[] byArray, int n2, CodeEntry[] codeEntryArray) {
        int n3 = n2;
        int n4 = 0;
        int n5 = (byArray[n2 - 2] & 0xFF) * 256 + (byArray[n2 - 1] & 0xFF) - 4 + n3;
        while (n3 < n5 && n4 < 256) {
            int n6 = byArray[n3++] & 0xFF;
            n6 = n6 * 256 + (byArray[n3++] & 0xFF);
            n6 = n6 * 256 + (byArray[n3++] & 0xFF);
            n6 = n6 * 256 + (byArray[n3++] & 0xFF);
            int n7 = Integer.MIN_VALUE;
            int n8 = 0;
            while (n8 < 32 && n3 < n5 && n4 < 256) {
                if ((n7 & n6) != 0) {
                    int n9 = byArray[n3++] & 0xFF;
                    int n10 = byArray[n3++] & 0xFF;
                    int n11 = byArray[n3++] & 0xFF;
                    int n12 = byArray[n3++] & 0xFF;
                    byte by = byArray[n3++];
                    byte by2 = byArray[n3++];
                    int n13 = 2 * by + 128;
                    int n14 = 2 * by2 + 128;
                    int n15 = -(by / 2) - by2 + 128;
                    codeEntryArray[n4].aRGB0 = (fBounding24[n9 + n13] << 16) + (fBounding24[n9 + n15] << 8) + fBounding24[n9 + n14];
                    codeEntryArray[n4].aRGB1 = (fBounding24[n10 + n13] << 16) + (fBounding24[n10 + n15] << 8) + fBounding24[n10 + n14];
                    codeEntryArray[n4].aRGB2 = (fBounding24[n11 + n13] << 16) + (fBounding24[n11 + n15] << 8) + fBounding24[n11 + n14];
                    codeEntryArray[n4].aRGB3 = (fBounding24[n12 + n13] << 16) + (fBounding24[n12 + n15] << 8) + fBounding24[n12 + n14];
                }
                n7 >>>= 1;
                ++n4;
                ++n8;
            }
        }
    }

    private void doFKUpdate(byte[] byArray, int n2, CineStore cineStore, int n3, Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n4 = videoFormat.getSize().width;
        CpStrip cpStrip = cineStore.StripVec[n3];
        CodeEntry[] codeEntryArray = cpStrip.Detail;
        CodeEntry[] codeEntryArray2 = cpStrip.Smooth;
        int n5 = (byArray[n2 - 2] & 0xFF) * 256 + (byArray[n2 - 1] & 0xFF) - 4 + n2;
        int n6 = cineStore.ImagePosX + cineStore.StripPosX;
        int n7 = cineStore.ImagePosY + cineStore.StripPosY;
        int n8 = n2;
        int n9 = 0;
        while (n8 < n5 && n7 < cineStore.ImagePosY + cineStore.ImageSizeY) {
            int n10 = byArray[n8++] & 0xFF;
            n10 = n10 * 256 + (byArray[n8++] & 0xFF);
            n10 = n10 * 256 + (byArray[n8++] & 0xFF);
            n10 = n10 * 256 + (byArray[n8++] & 0xFF);
            int n11 = Integer.MIN_VALUE;
            int n12 = 0;
            while (n12 < 32 && n8 < n5 && n7 < cineStore.ImagePosY + cineStore.ImageSizeY) {
                int n13;
                int n14;
                int n15;
                CodeEntry codeEntry;
                if ((n11 & n10) != 0) {
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    n15 = codeEntry.aRGB0;
                    n13 = n14 = n6 + n4 * n7;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB1;
                    n13 = n14 + 1;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB2;
                    n13 = n14 + n4;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB3;
                    nArray[++n13] = n15;
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    n15 = codeEntry.aRGB0;
                    n13 = n14 = n6 + 2 + n4 * n7;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB1;
                    n13 = n14 + 1;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB2;
                    n13 = n14 + n4;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB3;
                    nArray[++n13] = n15;
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    n15 = codeEntry.aRGB0;
                    n13 = n14 = n6 + n4 * (n7 + 2);
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB1;
                    n13 = n14 + 1;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB2;
                    n13 = n14 + n4;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB3;
                    nArray[++n13] = n15;
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    n15 = codeEntry.aRGB0;
                    n13 = n14 = n6 + 2 + n4 * (n7 + 2);
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB1;
                    n13 = n14 + 1;
                    nArray[n13] = n15;
                    n15 = codeEntry.aRGB2;
                    n13 = n14 + n4;
                    nArray[n13] = n15;
                    nArray[n13 + 1] = n15 = codeEntry.aRGB3;
                } else {
                    codeEntry = codeEntryArray2[byArray[n8++] & 0xFF];
                    n15 = codeEntry.aRGB0;
                    n13 = n14 = n6 + n4 * n7;
                    nArray[n13] = n15;
                    nArray[n13 + 1] = n15;
                    nArray[n13 += n4] = n15;
                    nArray[n13 + 1] = n15;
                    n15 = codeEntry.aRGB1;
                    n13 = n14 + 2;
                    nArray[n13] = n15;
                    nArray[n13 + 1] = n15;
                    nArray[n13 += n4] = n15;
                    nArray[n13 + 1] = n15;
                    n15 = codeEntry.aRGB2;
                    n13 = n14 += n4 * 2;
                    nArray[n13] = n15;
                    nArray[n13 + 1] = n15;
                    nArray[n13 += n4] = n15;
                    nArray[n13 + 1] = n15;
                    n15 = codeEntry.aRGB3;
                    n13 = n14 + 2;
                    nArray[n13] = n15;
                    nArray[n13 + 1] = n15;
                    nArray[n13 += n4] = n15;
                    nArray[n13 + 1] = n15;
                }
                n11 >>>= 1;
                ++n9;
                if ((n6 += 4) > cineStore.ImageSizeX - 4) {
                    n6 = cineStore.ImagePosX + cineStore.StripPosX;
                    n7 += 4;
                }
                ++n12;
            }
        }
    }

    private void doFSKUpdate(byte[] byArray, int n2, CineStore cineStore, int n3, Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n4 = videoFormat.getSize().width;
        CpStrip cpStrip = cineStore.StripVec[n3];
        CodeEntry[] codeEntryArray = cpStrip.Detail;
        CodeEntry[] codeEntryArray2 = cpStrip.Smooth;
        int n5 = (byArray[n2 - 2] & 0xFF) * 256 + (byArray[n2 - 1] & 0xFF) - 4 + n2;
        int n6 = cineStore.ImagePosX + cineStore.StripPosX;
        int n7 = cineStore.ImagePosY + cineStore.StripPosY;
        int n8 = n2;
        while (n8 < n5) {
            CodeEntry codeEntry = codeEntryArray2[byArray[n8++] & 0xFF];
            int n9 = codeEntry.aRGB0;
            int n10 = n6 + n4 * n7;
            if (n10 >= nArray.length) break;
            int n11 = n10;
            nArray[n11] = n9;
            nArray[n11 + 1] = n9;
            nArray[n11 += n4] = n9;
            nArray[n11 + 1] = n9;
            n9 = codeEntry.aRGB1;
            n11 = n10 + 2;
            nArray[n11] = n9;
            nArray[n11 + 1] = n9;
            nArray[n11 += n4] = n9;
            nArray[n11 + 1] = n9;
            n9 = codeEntry.aRGB2;
            n11 = n10 += n4 * 2;
            nArray[n11] = n9;
            nArray[n11 + 1] = n9;
            nArray[n11 += n4] = n9;
            nArray[n11 + 1] = n9;
            n9 = codeEntry.aRGB3;
            n11 = n10 + 2;
            nArray[n11] = n9;
            nArray[n11 + 1] = n9;
            nArray[n11 += n4] = n9;
            nArray[n11 + 1] = n9;
            if ((n6 += 4) <= cineStore.ImageSizeX - 4) continue;
            n6 = cineStore.ImagePosX + cineStore.StripPosX;
            n7 += 4;
        }
    }

    private void doIUpdate(byte[] byArray, int n2, CineStore cineStore, int n3, Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n4 = videoFormat.getSize().width;
        CodeEntry[] codeEntryArray = cineStore.StripVec[n3].Detail;
        CodeEntry[] codeEntryArray2 = cineStore.StripVec[n3].Smooth;
        int n5 = (byArray[n2 - 2] & 0xFF) * 256 + (byArray[n2 - 1] & 0xFF) - 4 + n2;
        int n6 = cineStore.ImagePosX + cineStore.StripPosX;
        int n7 = cineStore.ImagePosY + cineStore.StripPosY;
        int n8 = n2;
        int n9 = 0;
        int n10 = 0;
        int n11 = cineStore.ImagePosY + cineStore.StripPosY + cineStore.StripPosY1;
        while (n8 < n5 && n7 < n11) {
            if ((n10 >>>= 1) == 0) {
                n9 = byArray[n8++] & 0xFF;
                n9 = n9 * 256 + (byArray[n8++] & 0xFF);
                n9 = n9 * 256 + (byArray[n8++] & 0xFF);
                n9 = n9 * 256 + (byArray[n8++] & 0xFF);
                n10 = Integer.MIN_VALUE;
            }
            if ((n10 & n9) != 0 && n8 < n5) {
                CodeEntry codeEntry;
                int n12;
                if ((n10 >>>= 1) == 0) {
                    n9 = byArray[n8++] & 0xFF;
                    n9 = n9 * 256 + (byArray[n8++] & 0xFF);
                    n9 = n9 * 256 + (byArray[n8++] & 0xFF);
                    n9 = n9 * 256 + (byArray[n8++] & 0xFF);
                    n10 = Integer.MIN_VALUE;
                }
                if ((n10 & n9) != 0) {
                    n12 = n6 + n4 * n7;
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    nArray[n12] = codeEntry.aRGB0;
                    nArray[n12 + 1] = codeEntry.aRGB1;
                    nArray[n12 + n4] = codeEntry.aRGB2;
                    nArray[n12 + n4 + 1] = codeEntry.aRGB3;
                    n12 = n6 + 2 + n4 * n7;
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    nArray[n12] = codeEntry.aRGB0;
                    nArray[n12 + 1] = codeEntry.aRGB1;
                    nArray[n12 + n4] = codeEntry.aRGB2;
                    nArray[n12 + n4 + 1] = codeEntry.aRGB3;
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    n12 = n6 + n4 * (n7 + 2);
                    nArray[n12] = codeEntry.aRGB0;
                    nArray[n12 + 1] = codeEntry.aRGB1;
                    nArray[n12 + n4] = codeEntry.aRGB2;
                    nArray[n12 + n4 + 1] = codeEntry.aRGB3;
                    codeEntry = codeEntryArray[byArray[n8++] & 0xFF];
                    n12 = n6 + 2 + n4 * (n7 + 2);
                    nArray[n12] = codeEntry.aRGB0;
                    nArray[n12 + 1] = codeEntry.aRGB1;
                    nArray[n12 + n4] = codeEntry.aRGB2;
                    nArray[n12 + n4 + 1] = codeEntry.aRGB3;
                } else {
                    codeEntry = codeEntryArray2[byArray[n8++] & 0xFF];
                    int n13 = codeEntry.aRGB0;
                    int n14 = n12 = n6 + n4 * n7;
                    nArray[n14] = n13;
                    nArray[n14 + 1] = n13;
                    nArray[n14 += n4] = n13;
                    nArray[n14 + 1] = n13;
                    n13 = codeEntry.aRGB1;
                    n14 = n12 + 2;
                    nArray[n14] = n13;
                    nArray[n14 + 1] = n13;
                    nArray[n14 += n4] = n13;
                    nArray[n14 + 1] = n13;
                    n13 = codeEntry.aRGB2;
                    n14 = n12 += n4 * 2;
                    nArray[n14] = n13;
                    nArray[n14 + 1] = n13;
                    nArray[n14 += n4] = n13;
                    nArray[n14 + 1] = n13;
                    n13 = codeEntry.aRGB3;
                    n14 = n12 + 2;
                    nArray[n14] = n13;
                    nArray[n14 + 1] = n13;
                    nArray[n14 += n4] = n13;
                    nArray[n14 + 1] = n13;
                }
            }
            if ((n6 += 4) <= cineStore.ImageSizeX - 4) continue;
            n6 = cineStore.ImagePosX + cineStore.StripPosX;
            n7 += 4;
        }
    }

    private void doGFUpdate(byte[] byArray, int n2, CodeEntry[] codeEntryArray) {
        int n3 = n2;
        int n4 = ((byArray[n2 - 2] & 0xFF) * 256 + (byArray[n2 - 1] & 0xFF) - 4) / 4;
        if (this.lookup == null) {
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                if (firstFlag == 1) {
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB0 = (n6 << 16) + (n6 << 8) + n6;
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB1 = (n6 << 16) + (n6 << 8) + n6;
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB2 = (n6 << 16) + (n6 << 8) + n6;
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB3 = (n6 << 16) + (n6 << 8) + n6;
                } else {
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB0 = n6 << 16 | n6 << 8 | n6;
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB1 = n6 << 16 | n6 << 8 | n6;
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB2 = n6 << 16 | n6 << 8 | n6;
                    n6 = byArray[n3++] & 0xFF;
                    codeEntryArray[n5].aRGB3 = n6 << 16 | n6 << 8 | n6;
                }
                ++n5;
            }
        } else {
            int n7 = 0;
            while (n7 < n4) {
                int n8;
                if (firstFlag == 1) {
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB0 = this.lookup[n8];
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB1 = this.lookup[n8];
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB2 = this.lookup[n8];
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB3 = this.lookup[n8];
                } else {
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB0 = this.lookup[n8];
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB1 = this.lookup[n8];
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB2 = this.lookup[n8];
                    n8 = byArray[n3++] & 0xFF;
                    codeEntryArray[n7].aRGB3 = this.lookup[n8];
                }
                ++n7;
            }
        }
        firstFlag = 0;
    }

    /*
     * Unable to fully structure code
     */
    private void doGPUpdate(byte[] var1_1, int var2_2, CodeEntry[] var3_3) {
        block6: {
            var4_4 = var2_2;
            var5_5 = 0;
            var6_6 = (var1_1[var2_2 - 2] & 255) * 256 + (var1_1[var2_2 - 1] & 255) - 4 + var2_2;
            if (this.lookup != null) ** GOTO lbl48
            while (var4_4 < var6_6 && var5_5 < 256) {
                var7_7 = var1_1[var4_4++] & 255;
                var7_7 = var7_7 * 256 + (var1_1[var4_4++] & 255);
                var7_7 = var7_7 * 256 + (var1_1[var4_4++] & 255);
                var7_7 = var7_7 * 256 + (var1_1[var4_4++] & 255);
                var8_9 = -2147483648;
                var10_13 = 0;
                while (var10_13 < 32 && var4_4 < var6_6 && var5_5 < 256) {
                    if ((var8_9 & var7_7) != 0) {
                        var9_11 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB0 = var9_11 << 16 | var9_11 << 8 | var9_11;
                        var9_11 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB1 = var9_11 << 16 | var9_11 << 8 | var9_11;
                        var9_11 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB2 = var9_11 << 16 | var9_11 << 8 | var9_11;
                        var9_11 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB3 = var9_11 << 16 | var9_11 << 8 | var9_11;
                    }
                    var8_9 >>>= 1;
                    ++var5_5;
                    ++var10_13;
                }
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                var7_8 = var1_1[var4_4++] & 255;
                var7_8 = var7_8 * 256 + (var1_1[var4_4++] & 255);
                var7_8 = var7_8 * 256 + (var1_1[var4_4++] & 255);
                var7_8 = var7_8 * 256 + (var1_1[var4_4++] & 255);
                var8_10 = -2147483648;
                var10_14 = 0;
                while (var10_14 < 32 && var4_4 < var6_6 && var5_5 < 256) {
                    if ((var8_10 & var7_8) != 0) {
                        var9_12 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB0 = this.lookup[var9_12];
                        var9_12 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB1 = this.lookup[var9_12];
                        var9_12 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB2 = this.lookup[var9_12];
                        var9_12 = var1_1[var4_4++] & 255;
                        var3_3[var5_5].aRGB3 = this.lookup[var9_12];
                    }
                    var8_10 >>>= 1;
                    ++var5_5;
                    ++var10_14;
                }
lbl48:
                // 2 sources

                ** while (var4_4 < var6_6 && var5_5 < 256)
            }
        }
    }
}

