/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.codec.video.colorspace.RGBConverter;
import javax.media.Format;
import javax.media.format.RGBFormat;

public class JavaRGBConverter
extends RGBConverter {
    private static final String PLUGIN_NAME = "RGB Converter";

    public JavaRGBConverter() {
        this.inputFormats = new Format[]{new RGBFormat()};
        this.outputFormats = new Format[]{new RGBFormat()};
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    protected void componentToComponent(Object inData, int inPS, int inLS, int inBPP, int inRed, int inGreen, int inBlue, boolean inPacked, int inEndian, Object outData, int outPS, int outLS, int outBPP, int outRed, int outGreen, int outBlue, boolean outPacked, int outEndian, int width, int height, boolean flip) {
        block14: {
            int dstInc;
            int srcInc;
            int srcPtr;
            block16: {
                block15: {
                    block13: {
                        srcPtr = 0;
                        int dstPtr = 0;
                        srcInc = inLS - width * inPS;
                        dstInc = outLS - width * outPS;
                        if (flip) {
                            dstPtr = outLS * (height - 1);
                            dstInc = -(3 * outLS - width * outPS);
                        }
                        if (!inPacked || !outPacked) break block13;
                        int[] in = (int[])inData;
                        int[] out = (int[])outData;
                        if (inRed == outRed && inGreen == outGreen && inBlue == outBlue) {
                            for (int y = 0; y < height; ++y) {
                                for (int x = 0; x < width; ++x) {
                                    out[dstPtr] = in[srcPtr];
                                    srcPtr += inPS;
                                    dstPtr += outPS;
                                }
                                srcPtr += srcInc;
                                dstPtr += dstInc;
                            }
                        } else {
                            int inrs = this.getShift(inRed);
                            int ings = this.getShift(inGreen);
                            int inbs = this.getShift(inBlue);
                            int outrs = this.getShift(outRed);
                            int outgs = this.getShift(outGreen);
                            int outbs = this.getShift(outBlue);
                            for (int y = 0; y < height; ++y) {
                                for (int x = 0; x < width; ++x) {
                                    int outPixel;
                                    int inPixel = in[srcPtr];
                                    out[dstPtr] = outPixel = (inPixel >> inrs & 0xFF) << outrs | (inPixel >> ings & 0xFF) << outgs | (inPixel >> inbs & 0xFF) << outbs;
                                    srcPtr += inPS;
                                    dstPtr += outPS;
                                }
                                srcPtr += srcInc;
                                dstPtr += dstInc;
                            }
                        }
                        break block14;
                    }
                    if (!inPacked || outPacked) break block15;
                    int[] in = (int[])inData;
                    byte[] out = (byte[])outData;
                    int redShift = this.getShift(inRed);
                    int greenShift = this.getShift(inGreen);
                    int blueShift = this.getShift(inBlue);
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int pixel = in[srcPtr];
                            byte red = (byte)(pixel >> redShift & 0xFF);
                            byte green = (byte)(pixel >> greenShift & 0xFF);
                            byte blue = (byte)(pixel >> blueShift & 0xFF);
                            out[dstPtr + outRed - 1] = red;
                            out[dstPtr + outGreen - 1] = green;
                            out[dstPtr + outBlue - 1] = blue;
                            srcPtr += inPS;
                            dstPtr += outPS;
                        }
                        srcPtr += srcInc;
                        dstPtr += dstInc;
                    }
                    break block14;
                }
                if (inPacked || !outPacked) break block16;
                byte[] in = (byte[])inData;
                int[] out = (int[])outData;
                int redShift = this.getShift(outRed);
                int greenShift = this.getShift(outGreen);
                int blueShift = this.getShift(outBlue);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel;
                        byte red = in[srcPtr + inRed - 1];
                        byte green = in[srcPtr + inGreen - 1];
                        byte blue = in[srcPtr + inBlue - 1];
                        out[dstPtr] = pixel = (red & 0xFF) << redShift | (green & 0xFF) << greenShift | (blue & 0xFF) << blueShift;
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
                break block14;
            }
            if (inPacked || outPacked) break block14;
            byte[] in = (byte[])inData;
            byte[] out = (byte[])outData;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    out[dstPtr + outRed - 1] = in[srcPtr + inRed - 1];
                    out[dstPtr + outGreen - 1] = in[srcPtr + inGreen - 1];
                    out[dstPtr + outBlue - 1] = in[srcPtr + inBlue - 1];
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        }
    }

    protected void componentToSixteen(Object inData, int inPS, int inLS, int inBPP, int inRed, int inGreen, int inBlue, boolean inPacked, int inEndian, Object outData, int outPS, int outLS, int outBPP, int outRed, int outGreen, int outBlue, boolean outPacked, int outEndian, int width, int height, boolean flip) {
        int srcPtr = 0;
        int dstPtr = 0;
        int srcInc = inLS - width * inPS;
        int dstInc = outLS - width * outPS;
        int outrs = this.getShift(outRed) - 3;
        int outgs = this.getShift(outGreen) - (outGreen == 2016 ? 2 : 3);
        int inrs = this.getShift(inRed);
        int ings = this.getShift(inGreen);
        int inbs = this.getShift(inBlue);
        int outfs = 0;
        int outss = 0;
        if (!outPacked) {
            if (outEndian == 0) {
                outfs = 8;
                outss = 0;
            } else {
                outfs = 0;
                outss = 8;
            }
        }
        if (flip) {
            dstPtr = outLS * (height - 1);
            dstInc = -(3 * outLS - width * outPS);
        }
        if (inPacked && outPacked) {
            int[] in = (int[])inData;
            short[] out = (short[])outData;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = in[srcPtr];
                    out[dstPtr] = (short)(pixel >> inrs << outrs & outRed | pixel >> ings << outgs & outGreen | (pixel >> inbs & 0xFF) >> 3);
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        } else if (!inPacked && outPacked) {
            byte[] in = (byte[])inData;
            short[] out = (short[])outData;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    out[dstPtr] = (short)(in[srcPtr + inRed - 1] << outrs & outRed | in[srcPtr + inGreen - 1] << outgs & outGreen | (in[srcPtr + inBlue - 1] & 0xFF) >> 3);
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        } else if (!inPacked && !outPacked) {
            byte[] in = (byte[])inData;
            byte[] out = (byte[])outData;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = in[srcPtr + inRed - 1] << outrs & outRed | in[srcPtr + inGreen - 1] << outgs & outGreen | (in[srcPtr + inBlue - 1] & 0xFF) >> 3;
                    out[dstPtr] = (byte)(pixel >> outfs);
                    out[dstPtr + 1] = (byte)(pixel >> outss);
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        } else {
            int[] in = (int[])inData;
            byte[] out = (byte[])outData;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = in[srcPtr];
                    pixel = pixel >> inrs << outrs & outRed | pixel >> ings << outgs & outGreen | (pixel >> inbs & 0xFF) >> 3;
                    out[dstPtr] = (byte)(pixel >> outfs);
                    out[dstPtr + 1] = (byte)(pixel >> outss);
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        }
    }

    protected void sixteenToComponent(Object inData, int inPS, int inLS, int inBPP, int inRed, int inGreen, int inBlue, boolean inPacked, int inEndian, Object outData, int outPS, int outLS, int outBPP, int outRed, int outGreen, int outBlue, boolean outPacked, int outEndian, int width, int height, boolean flip) {
        int srcPtr = 0;
        int dstPtr = 0;
        int srcInc = inLS - width * inPS;
        int dstInc = outLS - width * outPS;
        if (flip) {
            dstPtr = outLS * (height - 1);
            dstInc = -(3 * outLS - width * outPS);
        }
        int inrs = this.getShift(inRed) - 3;
        int ings = this.getShift(inGreen) - (inGreen == 2016 ? 2 : 3);
        int outrs = this.getShift(outRed);
        int outgs = this.getShift(outGreen);
        int outbs = this.getShift(outBlue);
        if (inPacked && outPacked) {
            short[] in = (short[])inData;
            int[] out = (int[])outData;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int outpixel;
                    int pixel = in[srcPtr] & 0xFFFF;
                    out[dstPtr] = outpixel = (pixel & inRed) >> inrs << outrs | (pixel & inGreen) >> ings << outgs | (pixel & inBlue) << 3 << outbs;
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        } else if (!inPacked && outPacked) {
            int sbshift;
            int fbshift;
            byte[] in = (byte[])inData;
            int[] out = (int[])outData;
            if (inEndian == 0) {
                fbshift = 8;
                sbshift = 0;
            } else {
                fbshift = 0;
                sbshift = 8;
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int outpixel;
                    int pixel = (in[srcPtr] & 0xFF) << fbshift | (in[srcPtr + 1] & 0xFF) << sbshift;
                    out[dstPtr] = outpixel = (pixel & inRed) >> inrs << outrs | (pixel & inGreen) >> ings << outgs | (pixel & inBlue) << 3 << outbs;
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        } else if (inPacked && !outPacked) {
            short[] in = (short[])inData;
            byte[] out = (byte[])outData;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    short pixel = in[srcPtr];
                    out[dstPtr + outRed - 1] = (byte)((pixel & inRed) >> inrs);
                    out[dstPtr + outGreen - 1] = (byte)((pixel & inGreen) >> ings);
                    out[dstPtr + outBlue - 1] = (byte)((pixel & inBlue) << 3);
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        } else {
            int sbshift;
            int fbshift;
            byte[] in = (byte[])inData;
            byte[] out = (byte[])outData;
            if (inEndian == 0) {
                fbshift = 8;
                sbshift = 0;
            } else {
                fbshift = 0;
                sbshift = 8;
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = (in[srcPtr] & 0xFF) << fbshift | (in[srcPtr + 1] & 0xFF) << sbshift;
                    out[dstPtr + outRed - 1] = (byte)((pixel & inRed) >> inrs);
                    out[dstPtr + outGreen - 1] = (byte)((pixel & inGreen) >> ings);
                    out[dstPtr + outBlue - 1] = (byte)((pixel & inBlue) << 3);
                    srcPtr += inPS;
                    dstPtr += outPS;
                }
                srcPtr += srcInc;
                dstPtr += dstInc;
            }
        }
    }

    protected void sixteenToSixteen(Object inData, int inPS, int inLS, int inBPP, int inRed, int inGreen, int inBlue, boolean inPacked, int inEndian, Object outData, int outPS, int outLS, int outBPP, int outRed, int outGreen, int outBlue, boolean outPacked, int outEndian, int width, int height, boolean flip) {
        int srcPtr = 0;
        int dstPtr = 0;
        int srcInc = inLS - width * inPS;
        int dstInc = outLS - width * outPS;
        int shift = 0;
        int infs = 0;
        int inss = 0;
        int outfs = 0;
        int outss = 0;
        if (flip) {
            dstPtr = outLS * (height - 1);
            dstInc = -(3 * outLS - width * outPS);
        }
        if (!inPacked) {
            if (inEndian == 0) {
                infs = 8;
                inss = 0;
            } else {
                infs = 0;
                inss = 8;
            }
        }
        if (!outPacked) {
            if (outEndian == 0) {
                outfs = 8;
                outss = 0;
            } else {
                outfs = 0;
                outss = 8;
            }
        }
        if (inRed != outRed || inGreen != outGreen) {
            shift = inRed > outRed ? 1 : -1;
        }
        if (inPacked && outPacked) {
            short[] in = (short[])inData;
            short[] out = (short[])outData;
            if (shift == 0) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        out[dstPtr] = in[srcPtr];
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            } else if (shift == 1) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        short pixel = in[srcPtr];
                        out[dstPtr] = (short)(pixel >> 1 & (outGreen | outRed) | pixel & outBlue);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            } else {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        short pixel = in[srcPtr];
                        out[dstPtr] = (short)((pixel & (inGreen | inRed)) << 1 | pixel & outBlue);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            }
        } else if (!inPacked && outPacked) {
            byte[] in = (byte[])inData;
            short[] out = (short[])outData;
            if (shift == 0) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = (in[srcPtr] & 0xFF) << infs | (in[srcPtr + 1] & 0xFF) << inss;
                        out[dstPtr] = (short)pixel;
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            } else if (shift == 1) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = (in[srcPtr] & 0xFF) << infs | (in[srcPtr + 1] & 0xFF) << inss;
                        out[dstPtr] = (short)(pixel >> 1 & (outGreen | outRed) | pixel & outBlue);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            } else {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = (in[srcPtr] & 0xFF) << infs | (in[srcPtr + 1] & 0xFF) << inss;
                        out[dstPtr] = (short)((pixel & (inGreen | inRed)) << 1 | pixel & outBlue);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            }
        } else if (!inPacked && !outPacked) {
            byte[] in = (byte[])inData;
            byte[] out = (byte[])outData;
            if (shift == 0) {
                if (inEndian == outEndian) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            out[dstPtr] = in[srcPtr];
                            out[dstPtr + 1] = in[srcPtr + 1];
                            srcPtr += inPS;
                            dstPtr += outPS;
                        }
                        srcPtr += srcInc;
                        dstPtr += dstInc;
                    }
                } else {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int pixel = (in[srcPtr] & 0xFF) << infs | (in[srcPtr + 1] & 0xFF) << inss;
                            out[dstPtr] = (byte)(pixel >> outfs);
                            out[dstPtr + 1] = (byte)(pixel >> outss);
                            srcPtr += inPS;
                            dstPtr += outPS;
                        }
                        srcPtr += srcInc;
                        dstPtr += dstInc;
                    }
                }
            } else if (shift == 1) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = (in[srcPtr] & 0xFF) << infs | (in[srcPtr + 1] & 0xFF) << inss;
                        pixel = pixel >> 1 & (outGreen | outRed) | pixel & outBlue;
                        out[dstPtr] = (byte)(pixel >> outfs);
                        out[dstPtr + 1] = (byte)(pixel >> outss);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            } else {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = (in[srcPtr] & 0xFF) << infs | (in[srcPtr + 1] & 0xFF) << inss;
                        pixel = pixel >> 1 & (outGreen | outRed) | pixel & outBlue;
                        out[dstPtr] = (byte)(pixel >> outfs);
                        out[dstPtr + 1] = (byte)(pixel >> outss);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            }
        } else {
            short[] in = (short[])inData;
            byte[] out = (byte[])outData;
            if (shift == 0) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        short pixel = in[srcPtr];
                        out[dstPtr] = (byte)(pixel >> outfs);
                        out[dstPtr + 1] = (byte)(pixel >> outss);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            } else if (shift == 1) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = in[srcPtr];
                        pixel = pixel >> 1 & (outGreen | outRed) | pixel & outBlue;
                        out[dstPtr] = (byte)(pixel >> outfs);
                        out[dstPtr + 1] = (byte)(pixel >> outss);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            } else {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = in[srcPtr];
                        pixel = pixel >> 1 & (outGreen | outRed) | pixel & outBlue;
                        out[dstPtr] = (byte)(pixel >> outfs);
                        out[dstPtr + 1] = (byte)(pixel >> outss);
                        srcPtr += inPS;
                        dstPtr += outPS;
                    }
                    srcPtr += srcInc;
                    dstPtr += dstInc;
                }
            }
        }
    }
}

