/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.controls.QualityAdapter;
import com.sun.media.format.AviVideoFormat;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeEncoder
extends BasicCodec {
    private RGBFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private static boolean loaded = false;
    private static boolean canLoad = true;
    private int peer = 0;
    private static int QSCALE = 99;
    private float quality = 0.6f;
    private float prevQuality = 0.0f;
    private boolean isMotionJPEG = false;
    private boolean firstFrame = true;
    private int PACKET_SIZE = 960;
    private int currentSeq = (int)System.currentTimeMillis();
    private long timestamp = (long)((double)System.currentTimeMillis() * Math.random());
    private byte[] rtp_data = null;
    static Integer processLock = new Integer(1);
    private int copyLength = this.PACKET_SIZE;
    private boolean newframe = true;
    private int current_offset = 0;
    int returnVal = 0;
    private boolean dropFrame = false;
    private boolean minimal = false;
    private static final int DEFAULT_FRAMERATE = 15;
    private byte[] mjpgExtraBytes = new byte[]{44, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 8, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0};

    public NativeEncoder() {
        this.inputFormats = new RGBFormat[1];
        this.inputFormats[0] = new RGBFormat();
        this.outputFormats = new VideoFormat[2];
        this.outputFormats[0] = new JPEGFormat();
        this.outputFormats[1] = new VideoFormat("mjpg");
        class QCA
        extends QualityAdapter
        implements Owned {
            public QCA() {
                super(0.6f, 0.0f, 1.0f, true);
            }

            public float setQuality(float newValue) {
                NativeEncoder.this.quality = super.setQuality(newValue);
                return NativeEncoder.this.quality;
            }

            public String getName() {
                return "JPEG Quality";
            }

            public Object getOwner() {
                return NativeEncoder.this;
            }
        }
        QCA qualityControl = new QCA();
        FrameProcessingControl fpc = new FrameProcessingControl(){

            public boolean setMinimalProcessing(boolean newMinimal) {
                NativeEncoder.this.minimal = newMinimal;
                return NativeEncoder.this.minimal;
            }

            public void setFramesBehind(float frames) {
                if (frames >= 1.0f) {
                    NativeEncoder.this.dropFrame = true;
                } else {
                    NativeEncoder.this.dropFrame = false;
                }
            }

            public Component getControlComponent() {
                return null;
            }

            public int getFramesDropped() {
                return 0;
            }
        };
        this.controls = new Control[2];
        this.controls[0] = qualityControl;
        this.controls[1] = fpc;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    protected float qfToQuality(float quality) {
        if (quality < 0.1f) {
            quality = 0.1f;
        }
        if (this.isMotionJPEG) {
            return quality * (float)QSCALE;
        }
        if (quality < 0.8f) {
            return quality * 1.25f * (float)QSCALE;
        }
        return QSCALE;
    }

    protected int qfToDecimation(float quality) {
        if (this.isMotionJPEG) {
            return 2;
        }
        if (quality >= 0.8f) {
            if (quality >= 0.9f) {
                return 4;
            }
            return 2;
        }
        return 1;
    }

    protected int qfToType(float quality) {
        switch (this.qfToDecimation(quality)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 2;
            }
        }
        return 1;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(in)) {
            return new Format[0];
        }
        Format[] out = new Format[2];
        RGBFormat rgb = (RGBFormat)in;
        Dimension size = rgb.getSize();
        int maxDataLength = size.width * size.height * 3;
        JPEGFormat jpeg = new JPEGFormat(size, maxDataLength, Format.byteArray, rgb.getFrameRate(), -1, -1);
        AviVideoFormat mjpg = new AviVideoFormat("mjpg", size, maxDataLength, Format.byteArray, rgb.getFrameRate(), 1, 24, maxDataLength, 0, 0, 0, 0, this.mjpgExtraBytes);
        out[0] = jpeg;
        out[1] = mjpg;
        return out;
    }

    private boolean verifyInputFormat(Format input) {
        if (!(input instanceof RGBFormat)) {
            return false;
        }
        RGBFormat rgb = (RGBFormat)input;
        return rgb.getDataType() == Format.byteArray && rgb.getBitsPerPixel() == 24 && rgb.getRedMask() == 3 && rgb.getGreenMask() == 2 && rgb.getBlueMask() == 1 && rgb.getSize() != null && rgb.getLineStride() >= rgb.getSize().width && rgb.getPixelStride() == 3;
    }

    public Format setInputFormat(Format input) {
        if (!this.verifyInputFormat(input)) {
            return null;
        }
        this.inputFormat = (RGBFormat)input;
        if (this.opened) {
            this.close();
            Dimension size = this.inputFormat.getSize();
            int maxDataLength = size.width * size.height * 3;
            this.outputFormat = this.outputFormat instanceof JPEGFormat ? new JPEGFormat(size, maxDataLength, Format.byteArray, this.inputFormat.getFrameRate(), (int)this.qfToQuality(this.quality), this.qfToType(this.quality)) : new AviVideoFormat("mjpg", size, maxDataLength, Format.byteArray, this.inputFormat.getFrameRate(), 1, 24, maxDataLength, 0, 0, 0, 0, this.mjpgExtraBytes);
        }
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (NativeEncoder.matches(output, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (VideoFormat)output;
        this.isMotionJPEG = this.outputFormat.getEncoding().equalsIgnoreCase("mjpg");
        return output;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native JPEG converter");
        }
        Dimension size = this.inputFormat.getSize();
        if (size == null || size.width % 8 != 0 || size.height % 8 != 0) {
            Log.error("Class: " + this);
            Log.error("  can only encode in sizes of multiple of 8 pixels.");
            throw new ResourceUnavailableException("Unable to encode in size " + size);
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jmjpeg");
                loaded = true;
            }
            catch (Throwable t) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native JPEG encoder");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set on the JPEG encoder");
        }
        if (this.peer != 0) {
            this.close();
        }
        try {
            this.peer = this.initJPEGEncoder(size.width, size.height, (int)this.qfToQuality(this.quality), this.qfToDecimation(this.quality));
            this.firstFrame = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize JPEG encoder");
        }
        super.open();
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeJPEGEncoder(this.peer);
        }
        this.peer = 0;
        super.close();
    }

    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        int changeDecimation;
        float changeQuality;
        Object header = null;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (this.minimal || this.dropFrame) {
            outBuffer.setFlags(outBuffer.getFlags() | 2);
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        Object inData = this.getInputData(inBuffer);
        long inBytes = this.getNativeData(inData);
        boolean flipped = ((RGBFormat)inFormat).getFlipped() == 1;
        byte[] outData = (byte[])outBuffer.getData();
        if (outData == null || outData.length < this.outputFormat.getMaxDataLength()) {
            outData = new byte[this.outputFormat.getMaxDataLength()];
            outBuffer.setData(outData);
        }
        outBuffer.setFormat(this.outputFormat);
        if (this.prevQuality != this.quality) {
            this.prevQuality = this.quality;
            changeQuality = this.qfToQuality(this.quality);
            this.outputFormat = new JPEGFormat(this.outputFormat.getSize(), this.outputFormat.getMaxDataLength(), Format.byteArray, this.outputFormat.getFrameRate(), (int)this.qfToQuality(this.quality), this.qfToType(this.quality));
            this.close();
            changeDecimation = this.firstFrame ? this.qfToDecimation(this.quality) : -1;
        } else {
            changeQuality = -1.0f;
            changeDecimation = -1;
        }
        if (this.peer == 0) {
            try {
                this.open();
            }
            catch (ResourceUnavailableException re) {
                return 1;
            }
        }
        Dimension size = this.inputFormat.getSize();
        Integer n2 = processLock;
        synchronized (n2) {
            this.returnVal = this.encodeJPEG(this.peer, inData, inBytes, size.width, size.height, outData, outData.length, (int)changeQuality, changeDecimation, flipped);
        }
        this.firstFrame = false;
        if (this.returnVal > 0) {
            outBuffer.setLength(this.returnVal);
            outBuffer.setOffset(0);
            inBuffer.setLength(0);
            outBuffer.setFlags(16);
            outBuffer.setTimeStamp(inBuffer.getTimeStamp());
            outBuffer.setFormat(this.outputFormat);
            return 0;
        }
        outBuffer.setDiscard(true);
        return 1;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Encoder";
    }

    private native int initJPEGEncoder(int var1, int var2, int var3, int var4);

    private native int encodeJPEG(int var1, Object var2, long var3, int var5, int var6, byte[] var7, int var8, int var9, int var10, boolean var11);

    private native boolean freeJPEGEncoder(int var1);

    public static void main(String[] args) {
        int width = 320;
        int height = 240;
        RGBFormat in = new RGBFormat(new Dimension(width, height), width * height * 3, Format.byteArray, -1.0f, 24, 1, 2, 3, 3, width * 3, 0, -1);
        VideoFormat out = new VideoFormat("jpeg", new Dimension(width, height), width * height * 3, Format.byteArray, -1.0f);
        NativeEncoder e2 = new NativeEncoder();
        if (e2.setInputFormat(in) != null && e2.setOutputFormat(out) != null) {
            try {
                e2.open();
            }
            catch (ResourceUnavailableException rue) {
                System.err.println("Couldn't open encoder");
                System.exit(0);
            }
            byte[] rgbData = new byte[width * height * 3];
            System.err.println("Filling rgb data");
            for (int i2 = 0; i2 < width * height * 3; ++i2) {
                rgbData[i2] = (byte)(i2 % 3 * (i2 % width) % 255);
            }
            System.err.println("Encoding");
            Buffer inBuffer = new Buffer();
            inBuffer.setFormat(in);
            inBuffer.setData(rgbData);
            inBuffer.setLength(width * height * 3);
            Buffer outBuffer = new Buffer();
            outBuffer.setFormat(out);
            int result = e2.process(inBuffer, outBuffer);
            System.err.println("Result = " + result);
            e2.close();
        }
        System.exit(0);
    }
}

