/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import java.awt.Component;
import java.util.Vector;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public class GainControlAdapter
implements GainControl {
    private Vector listeners = null;
    private boolean muteState;
    private Component component;
    private float DefLevel = 0.4f;
    private float dB = 0.0f;
    private float level = this.DefLevel;

    public GainControlAdapter() {
    }

    public GainControlAdapter(float defLevel) {
        this.DefLevel = defLevel;
        this.level = defLevel;
    }

    public GainControlAdapter(boolean mute) {
        this.muteState = mute;
        this.setLevel(this.DefLevel);
    }

    public void setMute(boolean mute) {
        if (this.muteState != mute) {
            this.muteState = mute;
            this.informListeners();
        }
    }

    public boolean getMute() {
        return this.muteState;
    }

    public float setDB(float gain) {
        if (this.dB != gain) {
            this.dB = gain;
            float mult = (float)Math.pow(10.0, (double)this.dB / 20.0);
            this.level = mult * this.DefLevel;
            if ((double)this.level < 0.0) {
                this.setLevel(0.0f);
            } else if ((double)this.level > 1.0) {
                this.setLevel(1.0f);
            } else {
                this.setLevel(this.level);
                this.informListeners();
            }
        }
        return this.dB;
    }

    public float getDB() {
        return this.dB;
    }

    public float setLevel(float level) {
        if ((double)level < 0.0) {
            level = 0.0f;
        }
        if ((double)level > 1.0) {
            level = 1.0f;
        }
        if (this.level != level) {
            this.level = level;
            float mult = level / this.DefLevel;
            this.dB = (float)(Math.log((double)mult == 0.0 ? 1.0E-4 : (double)mult) / Math.log(10.0) * 20.0);
            this.informListeners();
        }
        return this.level;
    }

    public float getLevel() {
        return this.level;
    }

    public synchronized void addGainChangeListener(GainChangeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.addElement(listener);
        }
    }

    public synchronized void removeGainChangeListener(GainChangeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    public Component getControlComponent() {
        return null;
    }

    protected synchronized void informListeners() {
        if (this.listeners != null) {
            GainChangeEvent gce = new GainChangeEvent(this, this.muteState, this.dB, this.level);
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                GainChangeListener gcl = (GainChangeListener)this.listeners.elementAt(i2);
                gcl.gainChange(gce);
            }
        }
    }
}

