/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink.file;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Syncable;
import com.sun.media.datasink.BasicDataSink;
import com.sun.media.datasink.RandomAccess;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12DeleteFileAction;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Control;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class Handler
extends BasicDataSink
implements SourceTransferHandler,
Seekable,
Runnable,
RandomAccess,
Syncable {
    private static final boolean DEBUG = false;
    protected static final int NOT_INITIALIZED = 0;
    protected static final int OPENED = 1;
    protected static final int STARTED = 2;
    protected static final int CLOSED = 3;
    protected int state = 0;
    protected DataSource source;
    protected SourceStream[] streams;
    protected SourceStream stream;
    protected boolean push;
    protected boolean errorEncountered = false;
    protected String errorReason = null;
    protected Control[] controls;
    protected File file;
    protected File tempFile = null;
    protected RandomAccessFile raFile = null;
    protected RandomAccessFile qtStrRaFile = null;
    protected boolean fileClosed = false;
    protected FileDescriptor fileDescriptor = null;
    protected MediaLocator locator = null;
    protected String contentType = null;
    protected int fileSize = 0;
    protected int filePointer = 0;
    protected int bytesWritten = 0;
    protected static final int BUFFER_LEN = 131072;
    protected boolean syncEnabled = false;
    protected byte[] buffer1 = new byte[131072];
    protected byte[] buffer2 = new byte[131072];
    protected boolean buffer1Pending = false;
    protected long buffer1PendingLocation = -1L;
    protected int buffer1Length;
    protected boolean buffer2Pending = false;
    protected long buffer2PendingLocation = -1L;
    protected int buffer2Length;
    protected long nextLocation = 0L;
    protected Thread writeThread = null;
    private Integer bufferLock = new Integer(0);
    private boolean receivedEOS = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    public int WRITE_CHUNK_SIZE = 16384;
    private boolean streamingEnabled = false;
    private boolean errorCreatingStreamingFile = false;
    long lastSyncTime = -1L;

    public void setSource(DataSource ds) throws IncompatibleSourceException {
        if (!(ds instanceof PushDataSource) && !(ds instanceof PullDataSource)) {
            throw new IncompatibleSourceException("Incompatible datasource");
        }
        this.source = ds;
        if (this.source instanceof PushDataSource) {
            this.push = true;
            try {
                ((PushDataSource)this.source).connect();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.streams = ((PushDataSource)this.source).getStreams();
        } else {
            this.push = false;
            try {
                ((PullDataSource)this.source).connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streams = ((PullDataSource)this.source).getStreams();
        }
        if (this.streams == null || this.streams.length != 1) {
            throw new IncompatibleSourceException("DataSource should have 1 stream");
        }
        this.stream = this.streams[0];
        this.contentType = this.source.getContentType();
        if (this.push) {
            ((PushSourceStream)this.stream).setTransferHandler(this);
        }
    }

    public void setOutputLocator(MediaLocator output) {
        this.locator = output;
    }

    public void setEnabled(boolean b2) {
        this.streamingEnabled = b2;
    }

    public void setSyncEnabled() {
        this.syncEnabled = true;
    }

    public boolean write(long inOffset, int numBytes) {
        try {
            if (inOffset >= 0L && numBytes > 0) {
                int bytesToRead;
                this.raFile.seek(inOffset);
                for (int remaining = numBytes; remaining > 0; remaining -= bytesToRead) {
                    bytesToRead = remaining > 131072 ? 131072 : remaining;
                    this.raFile.read(this.buffer1, 0, bytesToRead);
                    this.qtStrRaFile.write(this.buffer1, 0, bytesToRead);
                }
            } else if (inOffset < 0L && numBytes > 0) {
                this.qtStrRaFile.seek(0L);
                this.qtStrRaFile.seek(numBytes - 1);
                this.qtStrRaFile.writeByte(0);
                this.qtStrRaFile.seek(0L);
            } else {
                this.sendEndofStreamEvent();
            }
        }
        catch (Exception e2) {
            this.errorCreatingStreamingFile = true;
            System.err.println("Exception when creating streamable version of media file: " + e2.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException, SecurityException {
        block25: {
            try {
                if (this.state != 0 || this.locator == null) break block25;
                String pathName = this.locator.getRemainder();
                while (pathName.charAt(0) == '/' && (pathName.charAt(1) == '/' || pathName.charAt(2) == ':')) {
                    pathName = pathName.substring(1);
                }
                String fileSeparator = System.getProperty("file.separator");
                if (fileSeparator.equals("\\")) {
                    pathName = pathName.replace('/', '\\');
                }
                JMFSecurityManager.checkFileSave();
                if (securityPrivelege && jmfSecurity != null) {
                    String permission = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            permission = "read file";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            permission = "write file";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 4);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                        }
                    }
                    catch (Exception e2) {
                        securityPrivelege = false;
                        if (this.push) {
                            ((PushSourceStream)this.stream).setTransferHandler(null);
                        }
                        throw new SecurityException(e2.getMessage());
                    }
                    catch (Error e3) {
                        securityPrivelege = false;
                        if (this.push) {
                            ((PushSourceStream)this.stream).setTransferHandler(null);
                        }
                        throw new SecurityException(e3.getMessage());
                    }
                }
                if (!securityPrivelege) {
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw new IOException("Datasink: Unable to get security privileges for file writing");
                }
                this.file = new File(pathName);
                if (this.file.exists() && !this.deleteFile(this.file)) {
                    System.err.println("datasink open: Existing file " + pathName + " cannot be deleted. Check if " + "some other process is using " + " this file");
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw new IOException("Existing file " + pathName + " cannot be deleted");
                }
                String parent = this.file.getParent();
                if (parent != null) {
                    new File(parent).mkdirs();
                }
                try {
                    if (!this.streamingEnabled) {
                        this.raFile = new RandomAccessFile(this.file, "rw");
                        this.fileDescriptor = this.raFile.getFD();
                    } else {
                        int index = pathName.lastIndexOf(".");
                        String fileqt = index > 0 ? pathName.substring(0, index) + ".nonstreamable" + pathName.substring(index, pathName.length()) : this.file + ".nonstreamable.mov";
                        this.tempFile = new File(fileqt);
                        this.raFile = new RandomAccessFile(this.tempFile, "rw");
                        this.fileDescriptor = this.raFile.getFD();
                        this.qtStrRaFile = new RandomAccessFile(this.file, "rw");
                    }
                }
                catch (IOException e4) {
                    System.err.println("datasink open: IOException when creating RandomAccessFile " + pathName + " : " + e4);
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw e4;
                }
                this.setState(1);
            }
            finally {
                if (this.state == 0 && this.stream != null) {
                    ((PushSourceStream)this.stream).setTransferHandler(null);
                }
            }
        }
    }

    public MediaLocator getOutputLocator() {
        return this.locator;
    }

    public void start() throws IOException {
        if (this.state == 1) {
            if (this.source != null) {
                this.source.start();
            }
            if (this.writeThread == null) {
                this.writeThread = new Thread(this);
                this.writeThread.start();
            }
            this.setState(2);
        }
    }

    public void stop() throws IOException {
        if (this.state == 2) {
            if (this.source != null) {
                this.source.stop();
            }
            this.setState(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int state) {
        Handler handler = this;
        synchronized (handler) {
            this.state = state;
        }
    }

    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void close(String reason) {
        Handler handler = this;
        synchronized (handler) {
            if (this.state == 3) {
                return;
            }
            this.setState(3);
        }
        if (this.push) {
            for (int i2 = 0; i2 < this.streams.length; ++i2) {
                ((PushSourceStream)this.streams[i2]).setTransferHandler(null);
            }
        }
        if (reason != null) {
            this.errorEncountered = true;
            this.sendDataSinkErrorEvent(reason);
            Integer i2 = this.bufferLock;
            synchronized (i2) {
                this.bufferLock.notifyAll();
            }
        }
        try {
            this.source.stop();
        }
        catch (IOException e2) {
            System.err.println("IOException when stopping source " + e2);
        }
        try {
            if (this.raFile != null) {
                this.raFile.close();
            }
            if (this.streamingEnabled && this.qtStrRaFile != null) {
                this.qtStrRaFile.close();
            }
            if (this.source != null) {
                this.source.disconnect();
            }
            if (this.streamingEnabled && this.tempFile != null) {
                if (!this.errorCreatingStreamingFile) {
                    boolean status = this.deleteFile(this.tempFile);
                } else {
                    boolean status = this.deleteFile(this.file);
                }
            }
        }
        catch (IOException e3) {
            System.out.println("close: " + e3);
        }
        this.raFile = null;
        this.qtStrRaFile = null;
        this.removeAllListeners();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[0];
        }
        return this.controls;
    }

    public Object getControl(String controlName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transferData(PushSourceStream pss) {
        int totalRead = 0;
        int spaceAvailable = 131072;
        int bytesRead = 0;
        if (this.errorEncountered) {
            return;
        }
        if (this.buffer1Pending) {
            Integer n2 = this.bufferLock;
            synchronized (n2) {
                while (this.buffer1Pending) {
                    try {
                        this.bufferLock.wait();
                    }
                    catch (InterruptedException ie) {}
                }
            }
        }
        while (spaceAvailable > 0) {
            try {
                bytesRead = pss.read(this.buffer1, totalRead, spaceAvailable);
                if (bytesRead > 16384 && this.WRITE_CHUNK_SIZE < 32768) {
                    if (bytesRead > 65536 && this.WRITE_CHUNK_SIZE < 131072) {
                        this.WRITE_CHUNK_SIZE = 131072;
                    } else if (bytesRead > 32768 && this.WRITE_CHUNK_SIZE < 65536) {
                        this.WRITE_CHUNK_SIZE = 65536;
                    } else if (this.WRITE_CHUNK_SIZE < 32768) {
                        this.WRITE_CHUNK_SIZE = 32768;
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (bytesRead <= 0) break;
            totalRead += bytesRead;
            spaceAvailable -= bytesRead;
        }
        if (totalRead > 0) {
            Integer ioe = this.bufferLock;
            synchronized (ioe) {
                this.buffer1Pending = true;
                this.buffer1PendingLocation = this.nextLocation;
                this.buffer1Length = totalRead;
                this.nextLocation = -1L;
                this.bufferLock.notifyAll();
            }
        }
        if (bytesRead == -1) {
            this.receivedEOS = true;
            while (!this.fileClosed && !this.errorEncountered && this.state != 3) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.state != 3 && !this.errorEncountered) {
            Integer n2 = this.bufferLock;
            synchronized (n2) {
                while (!(this.buffer1Pending || this.buffer2Pending || this.errorEncountered || this.state == 3 || this.receivedEOS)) {
                    try {
                        this.bufferLock.wait(500L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            if (this.buffer2Pending) {
                this.write(this.buffer2, this.buffer2PendingLocation, this.buffer2Length);
                this.buffer2Pending = false;
            }
            n2 = this.bufferLock;
            synchronized (n2) {
                if (this.buffer1Pending) {
                    byte[] tempBuffer = this.buffer2;
                    this.buffer2 = this.buffer1;
                    this.buffer2Pending = true;
                    this.buffer2PendingLocation = this.buffer1PendingLocation;
                    this.buffer2Length = this.buffer1Length;
                    this.buffer1Pending = false;
                    this.buffer1 = tempBuffer;
                    this.bufferLock.notifyAll();
                } else if (this.receivedEOS) {
                    break;
                }
            }
        }
        if (this.receivedEOS) {
            if (this.raFile != null) {
                if (!this.streamingEnabled) {
                    try {
                        this.raFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.raFile = null;
                }
                this.fileClosed = true;
            }
            if (!this.streamingEnabled) {
                this.sendEndofStreamEvent();
            }
        }
        if (this.errorEncountered && this.state != 3) {
            this.close(this.errorReason);
        }
    }

    public synchronized long seek(long where) {
        this.nextLocation = where;
        return where;
    }

    private void write(byte[] buffer, long location, int length) {
        try {
            if (location != -1L) {
                this.doSeek(location);
            }
            int offset = 0;
            while (length > 0) {
                int toWrite = this.WRITE_CHUNK_SIZE;
                if (length < toWrite) {
                    toWrite = length;
                }
                this.raFile.write(buffer, offset, toWrite);
                this.bytesWritten += toWrite;
                if (this.fileDescriptor != null && this.syncEnabled && this.bytesWritten >= this.WRITE_CHUNK_SIZE) {
                    this.bytesWritten -= this.WRITE_CHUNK_SIZE;
                    this.fileDescriptor.sync();
                }
                this.filePointer += toWrite;
                length -= toWrite;
                offset += toWrite;
                if (this.filePointer > this.fileSize) {
                    this.fileSize = this.filePointer;
                }
                Thread.yield();
            }
        }
        catch (IOException ioe) {
            this.errorEncountered = true;
            this.errorReason = ioe.toString();
        }
    }

    public long doSeek(long where) {
        if (this.raFile != null) {
            try {
                this.raFile.seek(where);
                this.filePointer = (int)where;
                return where;
            }
            catch (IOException ioe) {
                this.close("Error in seek: " + ioe);
            }
        }
        return -1L;
    }

    public long tell() {
        return this.nextLocation;
    }

    public long doTell() {
        if (this.raFile != null) {
            try {
                return this.raFile.getFilePointer();
            }
            catch (IOException ioe) {
                this.close("Error in tell: " + ioe);
            }
        }
        return -1L;
    }

    public boolean isRandomAccess() {
        return true;
    }

    private boolean deleteFile(File file) {
        boolean fileDeleted = false;
        try {
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 8);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                    }
                }
                catch (Exception e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12DeleteFileAction.cons;
                Boolean success = (Boolean)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(file));
                fileDeleted = success;
            } else {
                fileDeleted = file.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fileDeleted;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

