/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Suwak
extends JPanel
implements ChangeListener {
    private JSlider suwak;
    private JLabel label;
    private JLabel valStr;
    private double value;

    public Suwak(String name, int min, int max, double val, int majorTickSpacing, int minorTickSpacing) {
        this.createSuwak(name, min, max, val, majorTickSpacing, minorTickSpacing);
    }

    public Suwak(String name, int min, int max, double val) {
        this.createSuwak(name, min, max, val, (max - min) / 5, 1);
    }

    public void createSuwak(String name, int min, int max, double val, int majorTickSpacing, int minorTickSpacing) {
        this.value = val;
        this.setLayout(new BorderLayout());
        this.suwak = new JSlider(0, min, max, (int)val);
        this.suwak.setPaintTicks(true);
        this.suwak.setPaintLabels(true);
        this.suwak.setMajorTickSpacing(majorTickSpacing);
        this.suwak.setMinorTickSpacing(minorTickSpacing);
        this.suwak.addChangeListener(this);
        JPanel p = new JPanel(new FlowLayout(1));
        this.label = new JLabel(name + ":");
        this.valStr = new JLabel(" " + val);
        p.add(this.label);
        p.add(this.valStr);
        this.add((Component)this.suwak, "North");
        this.add((Component)p, "South");
    }

    public double getValue() {
        return this.value;
    }

    public void stateChanged(ChangeEvent e2) {
        this.value = this.suwak.getValue();
        this.valStr.setText(" " + (int)this.value);
    }

    public void setMinorTickSpacing(int spacing) {
        this.suwak.setMinorTickSpacing(spacing);
    }

    public void setMajorTickSpacing(int spacing) {
        this.suwak.setMajorTickSpacing(spacing);
    }
}

