/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.protocol.v4l.V4LCapture;
import com.sun.media.protocol.v4l.VCapability;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.VideoFormat;

public class V4LDeviceQuery
extends CaptureDeviceInfo {
    private transient V4LCapture capture;
    private transient Vector vecFormats = new Vector();
    private transient byte[] buffer = new byte[0x1B0000];
    protected transient Dimension[] sizes = new Dimension[]{new Dimension(160, 120), new Dimension(320, 240), new Dimension(640, 480), new Dimension(176, 144), new Dimension(352, 288), new Dimension(768, 576)};

    private void addFormat(Format fin) {
        Enumeration enumeration = this.vecFormats.elements();
        while (enumeration.hasMoreElements()) {
            Format f2 = (Format)enumeration.nextElement();
            if (!f2.equals(fin)) continue;
            return;
        }
        this.vecFormats.addElement(fin);
    }

    private void tryFormat(V4LCapture capture, int palette, int width, int height) {
        System.err.println("Trying " + palette + " " + width + " " + height);
        if (capture.setFormat(capture.paletteToDepth(palette), palette, width, height, 30.0f) < 0) {
            return;
        }
        if (capture.start() < 0) {
            return;
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            if (capture.readNextFrame(this.buffer, 0, this.buffer.length) < 0) continue;
            VideoFormat f2 = capture.paletteToFormat(palette, new Dimension(width, height));
            System.err.println("Format is " + f2);
            if (f2 != null) {
                this.addFormat(f2);
            }
            capture.stop();
            return;
        }
        capture.stop();
    }

    public V4LDeviceQuery(int index) {
        VCapability vcap = new VCapability();
        this.capture = new V4LCapture(index);
        this.capture.getCapability(vcap);
        this.name = "v4l:" + vcap.name + ":" + index;
        System.err.println("Name = " + this.name);
        this.tryFormat(this.capture, 4, 320, 240);
        for (int iPal = 3; iPal < 16; ++iPal) {
            for (int iSize = 0; iSize < this.sizes.length; ++iSize) {
                this.tryFormat(this.capture, iPal, this.sizes[iSize].width, this.sizes[iSize].height);
            }
        }
        this.formats = new Format[this.vecFormats.size()];
        Enumeration enumeration = this.vecFormats.elements();
        int i2 = 0;
        while (enumeration.hasMoreElements()) {
            Format f2 = (Format)enumeration.nextElement();
            this.formats[i2++] = f2;
        }
        this.locator = new MediaLocator("v4l://" + index);
    }
}

