/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.BasicPlugIn;
import com.sun.media.protocol.v4l.V4LCapture;
import com.sun.media.protocol.v4l.V4LDeviceQuery;
import com.sun.media.protocol.v4l.V4LPreviewWindow;
import com.sun.media.protocol.v4l.V4LSourceDialog;
import com.sun.media.protocol.v4l.VCapability;
import com.sun.media.protocol.v4l.VChannel;
import com.sun.media.protocol.v4l.VPicture;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Control;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.SystemTimeBase;
import javax.media.control.DirectAviRecorderControl;
import javax.media.control.FormatControl;
import javax.media.control.MonitorControl;
import javax.media.control.VideoSourceControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class V4LSourceStream
implements PushBufferStream,
FormatControl,
VideoSourceControl,
DirectAviRecorderControl,
Runnable {
    protected CaptureDeviceInfo cdi = null;
    protected FormatControl[] formatControls = null;
    protected ContentDescriptor cd = new ContentDescriptor("raw");
    protected Format[] supportedFormats = null;
    protected int maxDataLength;
    protected byte[] data;
    protected int deviceNo = 0;
    protected int seqNo = 0;
    protected VideoFormat currentFormat = null;
    protected VideoFormat requestedFormat = null;
    protected int requestedPort = -1;
    protected boolean started = false;
    protected boolean stopped = true;
    protected Thread thread;
    protected float frameRate = 30.0f;
    protected BufferTransferHandler transferHandler;
    protected Control[] controls = null;
    protected V4LCapture capture;
    private volatile boolean sourceDialogShown = false;
    SystemTimeBase systemTimeBase = new SystemTimeBase();
    V4LPreviewWindow previewWindow = null;

    public V4LSourceStream(MediaLocator locator) {
        VideoFormat locatorFormat = this.parseLocator(locator);
        if (this.getCaptureDeviceInfo() == null) {
            throw new Error("No such capture device!");
        }
        this.requestedFormat = (VideoFormat)this.getSupportedFormats()[0];
        if (locatorFormat != null) {
            this.requestedFormat = (VideoFormat)locatorFormat.intersects(this.requestedFormat);
        }
        try {
            this.capture = new V4LCapture(this.deviceNo);
        }
        catch (Throwable t) {
            throw new Error("Couldn't initialize capture device");
        }
        if (this.requestedPort != -1) {
            this.setPort(this.requestedPort);
        }
        this.setFormat(this.requestedFormat);
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        if (this.cdi == null) {
            String url = "v4l://" + this.deviceNo;
            Vector cdiList = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
            if (cdiList != null && cdiList.size() > 0) {
                for (int i2 = 0; i2 < cdiList.size(); ++i2) {
                    CaptureDeviceInfo tempCDI = (CaptureDeviceInfo)cdiList.elementAt(i2);
                    if (!tempCDI.getLocator().toString().equalsIgnoreCase(url)) continue;
                    this.cdi = tempCDI;
                    break;
                }
            }
            if (this.cdi == null) {
                this.cdi = this.autoDetect(this.deviceNo);
            }
        }
        if (this.cdi != null) {
            this.supportedFormats = this.cdi.getFormats();
        }
        return this.cdi;
    }

    protected CaptureDeviceInfo autoDetect(int cardNo) {
        V4LDeviceQuery cdi;
        block3: {
            cdi = null;
            try {
                cdi = new V4LDeviceQuery(cardNo);
                if (cdi != null && cdi.getFormats() != null && cdi.getFormats().length > 0 && CaptureDeviceManager.addDevice(cdi)) {
                    CaptureDeviceManager.commit();
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)t;
            }
        }
        return cdi;
    }

    public FormatControl[] getFormatControls() {
        if (this.formatControls == null) {
            this.formatControls = new FormatControl[1];
            this.formatControls[0] = this;
        }
        return this.formatControls;
    }

    protected VideoFormat parseLocator(MediaLocator loc) {
        this.deviceNo = this.getDeviceNo(loc);
        return null;
    }

    protected int getDeviceNo(MediaLocator locator) {
        int deviceNo = 0;
        String remainder = locator.getRemainder();
        if (remainder != null && remainder.length() > 0) {
            while (remainder.length() > 1 && remainder.charAt(0) == '/') {
                remainder = remainder.substring(1);
            }
            try {
                Integer integer = Integer.valueOf(remainder);
                if (integer != null) {
                    deviceNo = integer;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return deviceNo;
    }

    protected void setPort(String portMatch) {
        portMatch = portMatch.toLowerCase();
        VCapability vcap = new VCapability();
        this.capture.getCapability(vcap);
        for (int i2 = 0; i2 < vcap.channels; ++i2) {
            VChannel vchan = new VChannel(i2);
            this.capture.getChannel(vchan);
            if (vchan.name == null || vchan.name.toLowerCase().indexOf(portMatch) < 0) continue;
            this.capture.setChannel(vchan);
            return;
        }
    }

    protected void setPort(int portNo) {
    }

    public Format[] getSupportedFormats() {
        return this.supportedFormats;
    }

    public Format setFormat(Format inf) {
        if (BasicPlugIn.matches(inf, this.getSupportedFormats()) == null) {
            return null;
        }
        this.requestedFormat = (VideoFormat)inf;
        if (!this.started) {
            return this.handleFormatChange();
        }
        return this.requestedFormat;
    }

    protected Format handleFormatChange() {
        VideoFormat inf = this.requestedFormat;
        this.requestedFormat = null;
        int palette = this.capture.formatToPalette(inf);
        float frameRate = inf.getFrameRate();
        if (frameRate < 0.0f) {
            frameRate = 30.0f;
        }
        VPicture vpict = new VPicture();
        this.capture.getPicture(vpict);
        vpict.palette = palette;
        vpict.depth = this.capture.paletteToDepth(palette);
        this.capture.setPicture(vpict);
        if (this.capture.setFormat(vpict.depth, palette, inf.getSize().width, inf.getSize().height, frameRate) < 0) {
            return null;
        }
        this.currentFormat = inf;
        return this.currentFormat;
    }

    public void setEnabled(boolean value) {
    }

    public boolean isEnabled() {
        return true;
    }

    public Component getControlComponent() {
        return null;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.cd;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return false;
    }

    public Format getFormat() {
        return this.currentFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        int retVal = 0;
        if (!this.started) {
            throw new IOException("Not started");
        }
        this.maxDataLength = this.currentFormat.getMaxDataLength();
        Object outdata = buffer.getData();
        if (!(outdata instanceof byte[]) || ((byte[])outdata).length < this.maxDataLength) {
            outdata = new byte[this.maxDataLength];
            buffer.setData(outdata);
        }
        V4LSourceStream v4LSourceStream = this;
        synchronized (v4LSourceStream) {
            for (int count = 0; (retVal = this.capture.readNextFrame((byte[])outdata, 0, this.maxDataLength)) < 0 && count < 20; ++count) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            buffer.setFormat(this.currentFormat);
            buffer.setSequenceNumber(this.seqNo);
            buffer.setLength(this.maxDataLength);
            buffer.setFlags(32912);
            buffer.setHeader(null);
            buffer.setTimeStamp(this.systemTimeBase.getNanoseconds());
            ++this.seqNo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransferHandler(BufferTransferHandler transferHandler) {
        V4LSourceStream v4LSourceStream = this;
        synchronized (v4LSourceStream) {
            this.transferHandler = transferHandler;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(boolean started) {
        V4LSourceStream v4LSourceStream = this;
        synchronized (v4LSourceStream) {
            if (this.started == started) {
                return;
            }
            this.started = started;
            if (started) {
                if (this.requestedFormat != null) {
                    this.handleFormatChange();
                }
                this.thread = new Thread(this);
                this.capture.start();
                this.thread.start();
            } else {
                this.stopped = true;
                this.capture.stop();
            }
            this.notifyAll();
        }
    }

    synchronized void close() {
        if (this.capture != null) {
            if (this.started) {
                this.start(false);
            }
            this.capture.close();
            this.capture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.stopped = false;
        while (this.started) {
            V4LSourceStream v4LSourceStream = this;
            synchronized (v4LSourceStream) {
                while (this.transferHandler == null && this.started) {
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.started || this.transferHandler == null) continue;
            this.transferHandler.transferData(this);
            try {
                Thread.currentThread();
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stopped = true;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[2];
            this.controls[0] = this;
            this.controls[1] = new MC();
        }
        return this.controls;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i2 = 0; i2 < cs.length; ++i2) {
                if (!cls.isInstance(cs[i2])) continue;
                return cs[i2];
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public void displaySourceDialog(Frame owner) {
        this.sourceDialogShown = true;
        new V4LSourceDialog(owner, this);
        this.sourceDialogShown = false;
    }

    public boolean isSourceDialogShown() {
        return this.sourceDialogShown;
    }

    public boolean startAviRecording(String fileName) throws IOException {
        return false;
    }

    public boolean stopAviRecording() throws IOException {
        return false;
    }

    public boolean hasDirectAviRecording() {
        return false;
    }

    private synchronized boolean setMonitorEnabled(boolean show) {
        if (show) {
            if (this.previewWindow == null) {
                this.start(true);
                this.previewWindow = new V4LPreviewWindow(this);
                new Thread(this.previewWindow).start();
            }
        } else if (this.previewWindow != null) {
            this.start(false);
            this.previewWindow.stopPreview();
            this.previewWindow.dispose();
            this.previewWindow = null;
        }
        return show;
    }

    class MC
    implements MonitorControl,
    Owned {
        public Component getControlComponent() {
            return null;
        }

        public float setPreviewFrameRate(float value) {
            return value;
        }

        public boolean setEnabled(boolean value) {
            return V4LSourceStream.this.setMonitorEnabled(value);
        }

        public Object getOwner() {
            return V4LSourceStream.this;
        }
    }
}

