/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class DirectAudioRenderer
extends AudioRenderer {
    static String NAME = "DirectAudioRenderer";
    static boolean loaded = false;
    private int nativeData = 0;

    public DirectAudioRenderer() {
        this.supportedFormats = new Format[]{new AudioFormat("LINEAR", 44100.0, -1, 2, 0, -1), new AudioFormat("LINEAR", 44100.0, -1, 1, 0, -1), new AudioFormat("LINEAR", 22050.0, -1, -1, 0, -1), new AudioFormat("LINEAR", 11025.0, -1, -1, 0, -1), new AudioFormat("LINEAR", 8000.0, -1, -1, 0, -1)};
        this.gainControl = new MCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null && !this.initDevice(this.inputFormat)) {
            throw new ResourceUnavailableException("Cannot intialize audio device for playback");
        }
    }

    public void close() {
        super.close();
    }

    public void flush() {
        this.device.flush();
    }

    protected AudioOutput createDevice(AudioFormat format) {
        return new DirectAudioOutput();
    }

    private static synchronized boolean grabDevice() {
        return true;
    }

    public float setRate(float factor) {
        return super.setRate(1.0f);
    }

    private native boolean nOpen(int var1, int var2, int var3, int var4);

    private native void nClose();

    private native void nPause();

    private native void nResume();

    private native void nDrain();

    private native void nFlush();

    private native void nSetGain(float var1);

    private native void nSetMute(boolean var1);

    private native long nGetSamplesPlayed();

    private native int nBufferAvailable();

    private native int nWrite(byte[] var1, int var2, int var3);

    static {
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmdaud");
                loaded = true;
            }
            catch (UnsatisfiedLinkError e2) {
                loaded = false;
            }
        }
    }

    class DirectAudioOutput
    implements AudioOutput {
        private int bufSize;
        private AudioFormat format;
        private double gain;
        private boolean muted;

        public boolean initialize(AudioFormat format, int bufSize) {
            if (!loaded) {
                return false;
            }
            this.format = format;
            bufSize = (int)(format.getSampleRate() * (double)format.getSampleSizeInBits() * (double)format.getChannels() / 8.0 / 32.0);
            return DirectAudioRenderer.this.nOpen((int)format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), bufSize);
        }

        public void dispose() {
            DirectAudioRenderer.this.nClose();
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.dispose();
        }

        public void pause() {
            DirectAudioRenderer.this.nPause();
        }

        public void resume() {
            DirectAudioRenderer.this.nResume();
        }

        public void drain() {
            DirectAudioRenderer.this.nDrain();
        }

        public void flush() {
            DirectAudioRenderer.this.nFlush();
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public long getMediaNanoseconds() {
            long samples = DirectAudioRenderer.this.nGetSamplesPlayed();
            long t = (long)((double)(1000000L * samples) / this.format.getSampleRate()) * 1000L;
            return t;
        }

        public double getGain() {
            return this.gain;
        }

        public void setGain(double g2) {
            DirectAudioRenderer.this.nSetGain(DirectAudioRenderer.this.gainControl.getLevel());
            this.gain = g2;
        }

        public void setMute(boolean m2) {
            DirectAudioRenderer.this.nSetMute(m2);
            this.muted = m2;
        }

        public boolean getMute() {
            return this.muted;
        }

        public float setRate(float r) {
            return 1.0f;
        }

        public float getRate() {
            return 1.0f;
        }

        public int bufferAvailable() {
            return DirectAudioRenderer.this.nBufferAvailable();
        }

        public int write(byte[] data, int off, int len) {
            return DirectAudioRenderer.this.nWrite(data, off, len);
        }
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer r) {
            super(1.0f);
            this.renderer = r;
        }

        public void setMute(boolean mute) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(mute);
            }
            super.setMute(mute);
        }

        public float setLevel(float g2) {
            float level = super.setLevel(g2);
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(g2);
            }
            return level;
        }
    }
}

