/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.WindowUtil;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.IndexedColorFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class XLibRenderer
extends BasicVideoRenderer
implements DynamicPlugIn {
    private static boolean available = true;
    private static int jawtAvail = WindowUtil.getJAWTAvail();
    private int blitter = 0;
    protected Object data = null;
    private int defBitsPerPixel = 32;
    private int defRedMask = 255;
    private int defGreenMask = 65280;
    private int defBlueMask = 0xFF0000;
    private int offsetX = 0;
    private int offsetY = 0;
    private int bytesPerPixel = 4;
    private int bitsPerPixel;
    private int rMask;
    private int gMask;
    private int bMask;
    private int pixelStride;
    private int lineStride;
    private int lastOutWidth = -1;
    private int lastOutHeight = -1;
    private boolean firstTime = true;
    protected VideoFormat defaultFormat;

    private native void xlibSetJAWT(int var1);

    private synchronized native boolean xlibInitialize();

    private synchronized native boolean xlibSetComponent(Object var1);

    private synchronized native boolean xlibSetInputFormat(int var1, int var2, int var3);

    private synchronized native boolean xlibSetOutputSize(int var1, int var2);

    private synchronized native boolean xlibDraw(Object var1, long var2, int var4);

    private synchronized native boolean xlibFree();

    public XLibRenderer() {
        super("XLib Renderer");
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmxlib");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            available = false;
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
            available = false;
        }
        if (!available) {
            throw new RuntimeException("Could not load jmxlib library");
        }
        this.xlibSetJAWT(jawtAvail);
        if (this.xlibInitialize()) {
            ColorModel cm = Toolkit.getDefaultToolkit().getColorModel();
            if (!(cm instanceof DirectColorModel)) {
                throw new RuntimeException("Cannot render to non-TrueColor visuals");
            }
            DirectColorModel dcm = (DirectColorModel)cm;
            int pixelStride = 1;
            this.defBitsPerPixel = dcm.getPixelSize();
            Class arrayType = Format.intArray;
            if (this.defBitsPerPixel == 16 || this.defBitsPerPixel == 15) {
                this.defBitsPerPixel = 16;
                arrayType = Format.shortArray;
                this.bytesPerPixel = 2;
            }
            if (this.defBitsPerPixel == 24) {
                this.defBitsPerPixel = 32;
                arrayType = Format.intArray;
            }
            this.defRedMask = dcm.getRedMask();
            this.defBlueMask = dcm.getBlueMask();
            this.defGreenMask = dcm.getGreenMask();
            this.defaultFormat = new RGBFormat(null, -1, arrayType, -1.0f, this.defBitsPerPixel, this.defRedMask, this.defGreenMask, this.defBlueMask, pixelStride, -1, 0, -1);
            this.supportedFormats = new VideoFormat[1];
            this.supportedFormats[0] = this.defaultFormat;
            this.close();
        } else {
            available = false;
        }
    }

    public void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("XLib not available");
        }
    }

    public void reset() {
    }

    public void close() {
        if (available && this.blitter != 0) {
            this.xlibFree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Format setInputFormat(Format format) {
        if (!available) {
            return null;
        }
        if (!(format instanceof RGBFormat)) {
            return null;
        }
        if (!(Toolkit.getDefaultToolkit().getColorModel() instanceof DirectColorModel)) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            if (this.inputFormat instanceof RGBFormat) {
                RGBFormat rgbf = (RGBFormat)this.inputFormat;
                this.bitsPerPixel = rgbf.getBitsPerPixel();
                this.rMask = rgbf.getRedMask();
                this.gMask = rgbf.getGreenMask();
                this.bMask = rgbf.getBlueMask();
                this.lineStride = rgbf.getLineStride();
                this.pixelStride = rgbf.getPixelStride();
            } else if (this.inputFormat instanceof IndexedColorFormat) {
                this.lineStride = ((IndexedColorFormat)format).getLineStride();
            } else {
                return null;
            }
            XLibRenderer xLibRenderer = this;
            synchronized (xLibRenderer) {
                if (this.blitter != 0) {
                    this.xlibSetInputFormat(this.inWidth, this.inHeight, this.lineStride);
                }
            }
            if (this.outWidth == -1 || this.outHeight == -1) {
                this.outWidth = this.inWidth;
                this.outHeight = this.inHeight;
            }
            if (this.component != null) {
                this.component.setSize(this.outWidth, this.outHeight);
            }
            return format;
        }
        return null;
    }

    protected synchronized void removingComponent() {
        if (this.blitter != 0) {
            this.xlibFree();
        }
    }

    protected int doProcess(Buffer buffer) {
        return this.doProcess(buffer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doProcess(Buffer buffer, boolean repaint) {
        boolean resetOutputSize = false;
        if (!available || this.component == null) {
            return 0;
        }
        if (!repaint) {
            if (!buffer.getFormat().equals(this.inputFormat) && this.setInputFormat(buffer.getFormat()) == null) {
                return 1;
            }
            this.data = this.getInputData(buffer);
        } else if (this.data == null) {
            return 1;
        }
        XLibRenderer xLibRenderer = this;
        synchronized (xLibRenderer) {
            if (!this.componentAvailable || this.data == null) {
                return 0;
            }
            if (this.blitter == 0 || this.firstTime) {
                int handle = 0;
                this.firstTime = false;
                if (this.blitter == 0) {
                    handle = WindowUtil.getWindowHandle(this.component);
                    if (handle == 0) {
                        return 0;
                    }
                    this.xlibInitialize();
                    this.xlibSetComponent(this.component);
                    this.xlibSetInputFormat(this.inWidth, this.inHeight, this.lineStride);
                    resetOutputSize = true;
                    this.inputFormat = new VideoFormat(null);
                }
                if (this.blitter == 0) {
                    return 1;
                }
            }
            if (this.outWidth > 0 && this.outHeight > 0) {
                if (this.outWidth != this.lastOutWidth || this.outHeight != this.lastOutHeight || resetOutputSize) {
                    this.outWidth &= 0xFFFFFFFE;
                    this.lastOutWidth = this.outWidth;
                    this.lastOutHeight = this.outHeight;
                    if (this.blitter != 0) {
                        this.xlibSetOutputSize(this.outWidth, this.outHeight);
                    }
                }
                long dataBytes = this.getNativeData(this.data);
                if (this.data == null) {
                    return 0;
                }
                return this.xlibDraw(this.data, dataBytes, this.bytesPerPixel) ? 0 : 1;
            }
            return 1;
        }
    }

    public Format[] getBaseInputFormats() {
        Format[] formats = new Format[]{new RGBFormat()};
        return formats;
    }

    public Format[] getBaseOutputFormats() {
        Format[] formats = new Format[]{};
        return formats;
    }

    protected synchronized void repaint() {
        if (!this.isStarted() && this.data != null) {
            this.doProcess(null, true);
        }
    }
}

