/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sdp;

import com.sun.media.sdp.MediaAttribute;
import com.sun.media.sdp.Parser;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class MediaDescription
extends Parser {
    public String name;
    public String port;
    public String protocol;
    public int payload_type;
    public String payload;
    public String mediaTitle;
    public String connectionInfo;
    public String bandwidthInfo;
    public String encryptionKey;
    public Vector mediaAttributes;

    public MediaDescription(ByteArrayInputStream bin, boolean connectionIncluded) {
        String line = this.getLine(bin);
        int end = line.indexOf(32);
        this.name = line.substring(0, end);
        int start = end + 1;
        end = line.indexOf(32, start);
        this.port = line.substring(start, end);
        start = end + 1;
        end = line.indexOf(32, start);
        this.protocol = line.substring(start, end);
        start = end + 1;
        this.payload = line.substring(start);
        try {
            this.payload_type = new Integer(this.payload);
        }
        catch (Exception e2) {
            this.payload_type = -1;
        }
        if (this.getToken(bin, "i=", false)) {
            this.mediaTitle = this.getLine(bin);
            System.out.println("media title: " + this.mediaTitle);
        }
        boolean mandatory = true;
        if (connectionIncluded) {
            mandatory = false;
        }
        if (this.getToken(bin, "c=", mandatory)) {
            this.connectionInfo = this.getLine(bin);
            System.out.println("connection info: " + this.connectionInfo);
        }
        if (this.getToken(bin, "b=", false)) {
            this.bandwidthInfo = this.getLine(bin);
            System.out.println("bandwidth info: " + this.bandwidthInfo);
        }
        if (this.getToken(bin, "k=", false)) {
            this.encryptionKey = this.getLine(bin);
            System.out.println("encryption key: " + this.encryptionKey);
        }
        this.mediaAttributes = new Vector();
        boolean found = this.getToken(bin, "a=", false);
        while (found) {
            String mediaAttribute = this.getLine(bin);
            int index = mediaAttribute.indexOf(58);
            if (index > 0) {
                String name = mediaAttribute.substring(0, index);
                String value = mediaAttribute.substring(index + 1);
                MediaAttribute attribute = new MediaAttribute(name, value);
                this.mediaAttributes.addElement(attribute);
            }
            found = this.getToken(bin, "a=", false);
        }
    }

    public MediaAttribute getMediaAttribute(String name) {
        MediaAttribute attribute = null;
        if (this.mediaAttributes != null) {
            for (int i2 = 0; i2 < this.mediaAttributes.size(); ++i2) {
                MediaAttribute entry = (MediaAttribute)this.mediaAttributes.elementAt(i2);
                if (!entry.getName().equals(name)) continue;
                attribute = entry;
                break;
            }
        }
        return attribute;
    }
}

