/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sdp;

import com.sun.media.sdp.MediaAttribute;
import com.sun.media.sdp.MediaDescription;
import com.sun.media.sdp.Parser;
import com.sun.media.sdp.SessionDescription;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class SdpParser
extends Parser {
    public SessionDescription sessionDescription;
    public Vector mediaDescriptions;
    static String input = "v=0\r\no=mhandley 2890844526 2890842807 IN IP4 126.16.64.4\r\ns=SDP Seminar\r\ni=A Seminar on the session description protocol\r\nu=http://www.cs.ucl.ac.uk/staff/M.Handley/sdp.03.ps\r\ne=mjb@isi.edu (Mark Handley)\r\nc=IN IP4 224.2.17.12/127\r\nt=2873397496 2873404696\r\na=recvonly\r\nm=audio 49170 RTP/AVP 0\r\nm=video 51372 RTP/AVP 31\r\nm=application 32416 udp wbr\na=orient:portrait\r\n";

    public SdpParser(byte[] data) {
        this.init();
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        this.parseData(bin);
    }

    public void parseData(ByteArrayInputStream bin) {
        if (this.getToken(bin, "v=", true)) {
            this.sessionDescription = new SessionDescription(bin);
            this.mediaDescriptions = new Vector();
            boolean found = this.getToken(bin, "m=", false);
            while (found) {
                MediaDescription mediaDescription = new MediaDescription(bin, this.sessionDescription.connectionIncluded);
                this.mediaDescriptions.addElement(mediaDescription);
                found = this.getToken(bin, "m=", false);
            }
        }
    }

    public MediaAttribute getSessionAttribute(String name) {
        MediaAttribute attribute = null;
        if (this.sessionDescription != null) {
            attribute = this.sessionDescription.getSessionAttribute(name);
        }
        return attribute;
    }

    public MediaDescription getMediaDescription(String name) {
        MediaDescription description = null;
        if (this.mediaDescriptions != null) {
            for (int i2 = 0; i2 < this.mediaDescriptions.size(); ++i2) {
                MediaDescription entry = (MediaDescription)this.mediaDescriptions.elementAt(i2);
                if (!entry.name.equals(name)) continue;
                description = entry;
                break;
            }
        }
        return description;
    }

    public Vector getMediaDescriptions() {
        return this.mediaDescriptions;
    }

    public static void main(String[] args) {
        new SdpParser(input.getBytes());
    }
}

