/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.Region;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;

public class BufferedPanelLight
extends Container {
    protected boolean buffered;
    protected boolean autoFlushing;
    protected Image background;
    protected boolean windowCreated;
    protected transient Image buffer;
    protected transient Graphics bufferGraphics;
    protected transient Region damage;
    protected Object lock = new Object();

    public BufferedPanelLight(LayoutManager layout) {
        this.setLayout(layout);
        this.buffered = true;
        this.autoFlushing = true;
        this.background = null;
        this.windowCreated = false;
        this.buffer = null;
        this.bufferGraphics = null;
        this.damage = new Region();
    }

    public BufferedPanelLight() {
        this(null);
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        if (buffered != this.buffered) {
            this.buffered = buffered;
            if (buffered) {
                this.repaint();
            }
        }
    }

    public boolean isAutoFlushing() {
        return this.autoFlushing;
    }

    public void setAutoFlushing(boolean flushing) {
        if (flushing != this.autoFlushing) {
            this.autoFlushing = flushing;
        }
    }

    public Image getBackgroundTile() {
        return this.background;
    }

    public void setBackgroundTile(Image background) {
        this.background = background;
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.windowCreated = true;
        if (this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void reshape(int x, int y, int width, int height) {
        Rectangle old = this.getBounds();
        super.reshape(x, y, width, height);
        if (this.windowCreated && (width != old.width || height != old.height) && this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void flushBuffer() {
        Dimension size = this.getSize();
        super.repaint(0L, 0, 0, size.width, size.height);
    }

    void createBufferImage() {
        Dimension size = this.getSize();
        if (size.width > 0 && size.height > 0) {
            this.buffer = this.createImage(size.width, size.height);
            if (this.buffer != null) {
                this.bufferGraphics = this.buffer.getGraphics();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderBuffer() {
        Region rects;
        if (this.damage.isEmpty()) {
            return;
        }
        if (this.buffer == null) {
            return;
        }
        Region region = this.damage;
        synchronized (region) {
            rects = this.damage;
            this.damage = new Region();
        }
        Enumeration e2 = rects.rectangles();
        while (e2.hasMoreElements()) {
            Rectangle rect = (Rectangle)e2.nextElement();
            this.render(rect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(Rectangle rect) {
        Component[] children = this.getComponents();
        Image image = this.buffer;
        synchronized (image) {
            this.bufferGraphics.setClip(rect);
            this.paintBackground(this.bufferGraphics);
            this.bufferGraphics.setColor(this.getForeground());
            for (int c2 = children.length - 1; c2 >= 0; --c2) {
                Rectangle clip;
                Component child = children[c2];
                if (!this.isLightweight(child) || !child.isVisible() || !(clip = child.getBounds()).intersects(rect)) continue;
                Graphics g2 = this.bufferGraphics.create(clip.x, clip.y, clip.width, clip.height);
                child.paint(g2);
                g2.dispose();
            }
            this.bufferGraphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    protected void paintBackground(Graphics g2) {
        Dimension size = this.getSize();
        if (this.background == null) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        } else {
            Rectangle tile = new Rectangle(0, 0, this.background.getWidth(this), this.background.getHeight(this));
            Rectangle clip = g2.getClipBounds();
            while (tile.y < size.height) {
                while (tile.x < size.width) {
                    if (clip == null || clip.intersects(tile)) {
                        g2.drawImage(this.background, tile.x, tile.y, this);
                    }
                    tile.x += tile.width;
                }
                tile.x = 0;
                tile.y += tile.height;
            }
        }
    }

    boolean isLightweight(Component comp) {
        return comp.getPeer() instanceof LightweightPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(long time, int x, int y, int width, int height) {
        if (this.buffered) {
            Region region = this.damage;
            synchronized (region) {
                this.damage.addRectangle(new Rectangle(x, y, width, height));
            }
            if (this.autoFlushing) {
                this.flushBuffer();
            }
        } else {
            super.repaint(time, x, y, width, height);
        }
    }

    public void update(Graphics g2) {
        if (this.buffered) {
            this.paint(g2);
        } else {
            super.update(g2);
        }
    }

    public void paint(Graphics g2) {
        if (this.buffered && this.buffer != null) {
            this.renderBuffer();
            g2.drawImage(this.buffer, 0, 0, this);
        } else {
            super.paint(g2);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.damage = new Region();
    }
}

